/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.xml;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.latka.LatkaProperties;
import org.apache.commons.latka.event.LatkaEventInfo;
import org.apache.commons.latka.event.RequestErrorEvent;
import org.apache.commons.latka.event.RequestSkippedEvent;
import org.apache.commons.latka.event.RequestSucceededEvent;
import org.apache.commons.latka.http.Request;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.http.Session;
import org.apache.commons.latka.xml.LatkaHandler;
import org.apache.commons.latka.xml.ParameterHandler;
import org.apache.commons.latka.xml.RequestHeaderHandler;
import org.apache.commons.latka.xml.ValidationReflectionHandler;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RequestHandler
extends LatkaHandler {
    protected LatkaEventInfo _listener = null;
    protected Session _session = null;
    protected String _defaultHost = null;
    protected int _defaultPort = -1;
    protected boolean _skipped = false;
    protected Request _request = null;
    protected Response _response = null;
    protected boolean _requestExecuted = false;
    protected static final Category _log = Category.getInstance((Class)(class$org$apache$commons$latka$xml$RequestHandler == null ? (class$org$apache$commons$latka$xml$RequestHandler = RequestHandler.class$("org.apache.commons.latka.xml.RequestHandler")) : class$org$apache$commons$latka$xml$RequestHandler));
    static /* synthetic */ Class class$org$apache$commons$latka$xml$RequestHandler;

    public RequestHandler(XMLReader xMLReader, Session session, LatkaEventInfo latkaEventInfo) {
        super(xMLReader);
        this._session = session;
        this._listener = latkaEventInfo;
        this._skipped = false;
        Properties properties = LatkaProperties.getProperties();
        this._defaultHost = properties.getProperty("latka.defaultHost");
        String string = properties.getProperty("latka.defaultPort");
        if (string != null) {
            this._defaultPort = Integer.parseInt(string);
        }
        _log.debug((Object)"request handler instantiated");
    }

    public RequestHandler(XMLReader xMLReader, Session session, LatkaEventInfo latkaEventInfo, boolean bl) {
        this(xMLReader, session, latkaEventInfo);
        this._skipped = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        _log.debug((Object)"received start element event");
        if (!this._listener.didRequestSucceed(this._request)) {
            return;
        }
        if (string2.equals("request")) {
            try {
                this._request = this.buildRequest(attributes);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SAXException(malformedURLException);
            }
            if (this._skipped) {
                this._listener.requestSkipped(new RequestSkippedEvent(this._request, null));
                _log.info((Object)"request skipped");
            }
        } else if (string2.equals("credentials")) {
            this._request.setCredentials(attributes.getValue("userName"), attributes.getValue("password"));
        } else if (string2.equals("requestHeader")) {
            _log.info((Object)"adding request headers");
            RequestHeaderHandler requestHeaderHandler = new RequestHeaderHandler(this._reader, this._request);
            requestHeaderHandler.delegate(string, string2, string3, attributes);
        } else {
            if (string2.equals("param")) {
                _log.info((Object)"adding parameters: params should follow");
                ParameterHandler parameterHandler = new ParameterHandler(this._reader, this._request);
                parameterHandler.delegate(string, string2, string3, attributes);
                return;
            }
            if (string2.equals("validate")) {
                _log.info((Object)"encountered validations");
                try {
                    this._response = this._request.execute();
                    _log.debug((Object)"request executed and response obtained");
                    ValidationReflectionHandler validationReflectionHandler = new ValidationReflectionHandler(this._reader, this._response, this._listener);
                    validationReflectionHandler.delegate(string, string2, string3, attributes);
                }
                catch (IOException iOException) {
                    this._listener.requestError(new RequestErrorEvent(this._request, this._response, iOException));
                }
                this._requestExecuted = true;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("request")) {
            if (!this._requestExecuted && !this._skipped) {
                try {
                    this._request.execute();
                    this._listener.requestSucceeded(new RequestSucceededEvent(this._request, this._response));
                }
                catch (IOException iOException) {
                    this._listener.requestError(new RequestErrorEvent(this._request, this._response, iOException));
                }
            } else if (this._listener.didRequestSucceed(this._request)) {
                this._listener.requestSucceeded(new RequestSucceededEvent(this._request, this._response));
            }
            this.release();
        }
    }

    protected Request buildRequest(Attributes attributes) throws MalformedURLException {
        String string = attributes.getValue("host");
        if (string == null) {
            string = this._defaultHost;
        }
        String string2 = attributes.getValue("path");
        boolean bl = false;
        String string3 = attributes.getValue("secure");
        bl = null == string3 ? false : "true".equalsIgnoreCase(string3);
        String string4 = attributes.getValue("port");
        int n = this._defaultPort;
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        URL uRL = new URL(bl ? "https" : "http", string, n, string2);
        String string5 = attributes.getValue("method");
        int n2 = -1;
        n2 = string5 == null ? 0 : (string5.equalsIgnoreCase("post") ? 1 : (string5.equalsIgnoreCase("head") ? 2 : 0));
        String string6 = attributes.getValue("label");
        _log.info((Object)"creating request with label:");
        _log.info((Object)string6);
        boolean bl2 = true;
        String string7 = attributes.getValue("followRedirects");
        bl2 = null == string7 ? true : "true".equalsIgnoreCase(string7);
        return this._session.createRequest(string6, uRL, n2, bl2);
    }

    protected void printFailure(Request request, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("REQUEST FAILED for URL ");
        stringBuffer.append(this._request.getURL());
        stringBuffer.append(": ");
        stringBuffer.append(exception);
        System.out.println(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

