/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.WeakHashtable;

public class WeakHashtableTestCase
extends TestCase {
    private static final int WAIT_FOR_THREAD_COMPLETION = 5000;
    private static final int RUN_LOOPS = 3000;
    private static final int OUTER_LOOP = 400;
    private static final int THREAD_COUNT = 10;
    private static WeakHashtable hashtable;
    private static final int MAX_GC_ITERATIONS = 50;
    private WeakHashtable weakHashtable;
    private Long keyOne;
    private Long keyTwo;
    private Long keyThree;
    private Long valueOne;
    private Long valueTwo;
    private Long valueThree;

    public WeakHashtableTestCase(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.weakHashtable = new WeakHashtable();
        this.keyOne = new Long(1L);
        this.keyTwo = new Long(2L);
        this.keyThree = new Long(3L);
        this.valueOne = new Long(100L);
        this.valueTwo = new Long(200L);
        this.valueThree = new Long(300L);
        this.weakHashtable.put((Object)this.keyOne, (Object)this.valueOne);
        this.weakHashtable.put((Object)this.keyTwo, (Object)this.valueTwo);
        this.weakHashtable.put((Object)this.keyThree, (Object)this.valueThree);
    }

    public void testContains() throws Exception {
        Assert.assertFalse((boolean)this.weakHashtable.contains(new Long(1L)));
        Assert.assertFalse((boolean)this.weakHashtable.contains(new Long(2L)));
        Assert.assertFalse((boolean)this.weakHashtable.contains(new Long(3L)));
        Assert.assertTrue((boolean)this.weakHashtable.contains(new Long(100L)));
        Assert.assertTrue((boolean)this.weakHashtable.contains(new Long(200L)));
        Assert.assertTrue((boolean)this.weakHashtable.contains(new Long(300L)));
        Assert.assertFalse((boolean)this.weakHashtable.contains(new Long(400L)));
    }

    public void testContainsKey() throws Exception {
        Assert.assertTrue((boolean)this.weakHashtable.containsKey((Object)new Long(1L)));
        Assert.assertTrue((boolean)this.weakHashtable.containsKey((Object)new Long(2L)));
        Assert.assertTrue((boolean)this.weakHashtable.containsKey((Object)new Long(3L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsKey((Object)new Long(100L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsKey((Object)new Long(200L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsKey((Object)new Long(300L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsKey((Object)new Long(400L)));
    }

    public void testContainsValue() throws Exception {
        Assert.assertFalse((boolean)this.weakHashtable.containsValue(new Long(1L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsValue(new Long(2L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsValue(new Long(3L)));
        Assert.assertTrue((boolean)this.weakHashtable.containsValue(new Long(100L)));
        Assert.assertTrue((boolean)this.weakHashtable.containsValue(new Long(200L)));
        Assert.assertTrue((boolean)this.weakHashtable.containsValue(new Long(300L)));
        Assert.assertFalse((boolean)this.weakHashtable.containsValue(new Long(400L)));
    }

    public void testElements() throws Exception {
        ArrayList elements = new ArrayList();
        Enumeration e = this.weakHashtable.elements();
        while (e.hasMoreElements()) {
            elements.add(e.nextElement());
        }
        Assert.assertEquals((int)3, (int)elements.size());
        Assert.assertTrue((boolean)elements.contains(this.valueOne));
        Assert.assertTrue((boolean)elements.contains(this.valueTwo));
        Assert.assertTrue((boolean)elements.contains(this.valueThree));
    }

    public void testEntrySet() throws Exception {
        Set entrySet = this.weakHashtable.entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            if (this.keyOne.equals(key)) {
                Assert.assertEquals((Object)this.valueOne, entry.getValue());
                continue;
            }
            if (this.keyTwo.equals(key)) {
                Assert.assertEquals((Object)this.valueTwo, entry.getValue());
                continue;
            }
            if (this.keyThree.equals(key)) {
                Assert.assertEquals((Object)this.valueThree, entry.getValue());
                continue;
            }
            Assert.fail((String)"Unexpected key");
        }
    }

    public void testGet() throws Exception {
        Assert.assertEquals((Object)this.valueOne, (Object)this.weakHashtable.get((Object)this.keyOne));
        Assert.assertEquals((Object)this.valueTwo, (Object)this.weakHashtable.get((Object)this.keyTwo));
        Assert.assertEquals((Object)this.valueThree, (Object)this.weakHashtable.get((Object)this.keyThree));
        Assert.assertNull((Object)this.weakHashtable.get((Object)new Long(50L)));
    }

    public void testKeys() throws Exception {
        ArrayList keys = new ArrayList();
        Enumeration e = this.weakHashtable.keys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        Assert.assertEquals((int)3, (int)keys.size());
        Assert.assertTrue((boolean)keys.contains(this.keyOne));
        Assert.assertTrue((boolean)keys.contains(this.keyTwo));
        Assert.assertTrue((boolean)keys.contains(this.keyThree));
    }

    public void testKeySet() throws Exception {
        Set keySet = this.weakHashtable.keySet();
        Assert.assertEquals((int)3, (int)keySet.size());
        Assert.assertTrue((boolean)keySet.contains(this.keyOne));
        Assert.assertTrue((boolean)keySet.contains(this.keyTwo));
        Assert.assertTrue((boolean)keySet.contains(this.keyThree));
    }

    public void testPut() throws Exception {
        Long anotherKey = new Long(2004L);
        this.weakHashtable.put((Object)anotherKey, (Object)new Long(1066L));
        Assert.assertEquals((Object)new Long(1066L), (Object)this.weakHashtable.get((Object)anotherKey));
        Exception caught = null;
        try {
            this.weakHashtable.put(null, new Object());
        }
        catch (Exception e) {
            caught = e;
        }
        Assert.assertNotNull((String)"did not throw an exception adding a null key", (Object)caught);
        caught = null;
        try {
            this.weakHashtable.put(new Object(), null);
        }
        catch (Exception e) {
            caught = e;
        }
        Assert.assertNotNull((String)"did not throw an exception adding a null value", (Object)caught);
    }

    public void testPutAll() throws Exception {
        HashMap<Long, Long> newValues = new HashMap<Long, Long>();
        Long newKey = new Long(1066L);
        Long newValue = new Long(1415L);
        newValues.put(newKey, newValue);
        Long anotherNewKey = new Long(1645L);
        Long anotherNewValue = new Long(1815L);
        newValues.put(anotherNewKey, anotherNewValue);
        this.weakHashtable.putAll(newValues);
        Assert.assertEquals((int)5, (int)this.weakHashtable.size());
        Assert.assertEquals((Object)newValue, (Object)this.weakHashtable.get((Object)newKey));
        Assert.assertEquals((Object)anotherNewValue, (Object)this.weakHashtable.get((Object)anotherNewKey));
    }

    public void testRemove() throws Exception {
        this.weakHashtable.remove((Object)this.keyOne);
        Assert.assertEquals((int)2, (int)this.weakHashtable.size());
        Assert.assertNull((Object)this.weakHashtable.get((Object)this.keyOne));
    }

    public void testValues() throws Exception {
        Collection values = this.weakHashtable.values();
        Assert.assertEquals((int)3, (int)values.size());
        Assert.assertTrue((boolean)values.contains(this.valueOne));
        Assert.assertTrue((boolean)values.contains(this.valueTwo));
        Assert.assertTrue((boolean)values.contains(this.valueThree));
    }

    public void xxxIgnoretestRelease() throws Exception {
        Assert.assertNotNull((Object)this.weakHashtable.get((Object)new Long(1L)));
        ReferenceQueue testQueue = new ReferenceQueue();
        WeakReference<Long> weakKeyOne = new WeakReference<Long>(this.keyOne, testQueue);
        this.keyOne = null;
        this.keyTwo = null;
        this.keyThree = null;
        this.valueOne = null;
        this.valueTwo = null;
        this.valueThree = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                Assert.fail((String)"Max iterations reached before resource released.");
            }
            if (this.weakHashtable.get((Object)new Long(1L)) == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
        while (testQueue.poll() == null) {
        }
        Assert.assertEquals((String)"underlying table not emptied", (int)0, (int)this.weakHashtable.size());
    }

    public void testLOGGING_119() throws Exception {
        Thread[] t = new Thread[10];
        for (int j = 1; j <= 400; ++j) {
            int i;
            hashtable = new WeakHashtable();
            for (i = 0; i < t.length; ++i) {
                t[i] = new StupidThread("Thread:" + i);
                t[i].setDaemon(true);
                t[i].start();
            }
            for (i = 0; i < t.length; ++i) {
                t[i].join(5000L);
                if (t[i].isAlive()) break;
            }
            int active = 0;
            for (int i2 = 0; i2 < t.length; ++i2) {
                if (!t[i2].isAlive()) continue;
                ++active;
            }
            if (active <= 0) continue;
            Assert.fail((String)("Attempt: " + j + " Stuck threads: " + active));
        }
    }

    public static class StupidThread
    extends Thread {
        public StupidThread(String name) {
            super(name);
        }

        public void run() {
            for (int i = 0; i < 3000; ++i) {
                hashtable.put((Object)("key:" + i % 10), (Object)Boolean.TRUE);
                if (i % 50 != 0) continue;
                Thread.yield();
            }
        }
    }
}

