/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class PathableTestSuite
extends TestSuite {
    private final ClassLoader contextLoader;

    public PathableTestSuite(Class testClass, ClassLoader contextClassLoader) {
        super(testClass);
        this.contextLoader = contextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(Test test, TestResult result) {
        ClassLoader origContext = Thread.currentThread().getContextClassLoader();
        Properties oldSysProps = (Properties)((Hashtable)System.getProperties()).clone();
        try {
            Thread.currentThread().setContextClassLoader(this.contextLoader);
            test.run(result);
        }
        finally {
            System.setProperties(oldSysProps);
            Thread.currentThread().setContextClassLoader(origContext);
        }
    }
}

