/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.common;

import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.StoreInstruction;

public class ByteCode {
    public static void printOpCode(Instruction ins, ConstantPoolGen cpg) {
        if (ins instanceof InvokeInstruction) {
            InvokeInstruction invokeIns = (InvokeInstruction)ins;
            System.out.println(ByteCode.formatName(ins) + " " + invokeIns.getClassName(cpg).replaceAll("\\.", "/") + "." + invokeIns.getMethodName(cpg) + invokeIns.getSignature(cpg));
        } else if (ins instanceof LDC) {
            LDC i = (LDC)ins;
            System.out.println(ByteCode.formatName(ins) + " \"" + i.getValue(cpg).toString() + "\"");
        } else if (ins instanceof NEW) {
            NEW i = (NEW)ins;
            ObjectType type = i.getLoadClassType(cpg);
            System.out.println(ByteCode.formatName(ins) + " " + type.toString());
        } else if (ins instanceof LoadInstruction) {
            LoadInstruction i = (LoadInstruction)ins;
            System.out.println(ByteCode.formatName(ins) + " " + i.getIndex() + " => [stack]");
        } else if (ins instanceof StoreInstruction) {
            StoreInstruction i = (StoreInstruction)ins;
            System.out.println(ByteCode.formatName(ins) + " (objectref) => " + i.getIndex() + "");
        } else if (ins instanceof FieldInstruction) {
            FieldInstruction i = (FieldInstruction)ins;
            System.out.println(ByteCode.formatName(ins) + " " + i.getFieldName(cpg) + "");
        } else if (ins instanceof IfInstruction) {
            IfInstruction i = (IfInstruction)ins;
            System.out.println(ByteCode.formatName(ins) + " target => " + i.getTarget().toString() + "");
        } else if (ins instanceof ICONST) {
            ICONST i = (ICONST)ins;
            System.out.println(ByteCode.formatName(ins) + " " + i.getValue() + " (" + i.getType(cpg) + ")");
        } else if (ins instanceof GOTO) {
            GOTO i = (GOTO)ins;
            System.out.println(ByteCode.formatName(ins) + " target => " + i.getTarget().toString());
        } else {
            System.out.println(ByteCode.formatName(ins));
        }
    }

    private static String formatName(Instruction ins) {
        return String.format("%-15s", ins.getName());
    }

    public static <T> T getConstantLDC(InstructionHandle h, ConstantPoolGen cpg, Class<T> clazz) {
        INVOKESPECIAL invoke;
        Instruction prevIns = h.getInstruction();
        if (prevIns instanceof LDC) {
            LDC ldcInst = (LDC)prevIns;
            Object val = ldcInst.getValue(cpg);
            if (val.getClass().equals(clazz)) {
                return clazz.cast(val);
            }
        } else if (clazz.equals(String.class) && prevIns instanceof INVOKESPECIAL && (invoke = (INVOKESPECIAL)prevIns).getMethodName(cpg).equals("<init>") && invoke.getClassName(cpg).equals("java.lang.String") && invoke.getSignature(cpg).equals("(Ljava/lang/String;)V")) {
            return ByteCode.getConstantLDC(h.getPrev(), cpg, clazz);
        }
        return null;
    }

    public static Integer getConstantInt(InstructionHandle h) {
        Instruction prevIns = h.getInstruction();
        if (prevIns instanceof ICONST) {
            ICONST ldcCipher = (ICONST)prevIns;
            Number num = ldcCipher.getValue();
            return num.intValue();
        }
        return null;
    }

    public static Number getPushNumber(InstructionHandle h) {
        Instruction prevIns = h.getInstruction();
        if (prevIns instanceof BIPUSH) {
            BIPUSH ldcCipher = (BIPUSH)prevIns;
            return ldcCipher.getValue();
        }
        if (prevIns instanceof SIPUSH) {
            SIPUSH ldcCipher = (SIPUSH)prevIns;
            return ldcCipher.getValue();
        }
        return null;
    }

    public static <T> T getPrevInstruction(InstructionHandle startHandle, Class<T> clazz) {
        InstructionHandle curHandle = startHandle;
        while (curHandle != null) {
            if ((curHandle = curHandle.getPrev()) == null || !clazz.isInstance(curHandle.getInstruction())) continue;
            return clazz.cast(curHandle.getInstruction());
        }
        return null;
    }
}

