/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.sql;

import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import edu.umd.cs.findbugs.BugReporter;

public class SqlInjectionDetector
extends BasicInjectionDetector {
    public SqlInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("sql-hibernate.txt", "SQL_INJECTION_HIBERNATE");
        this.loadConfiguredSinks("sql-jdo.txt", "SQL_INJECTION_JDO");
        this.loadConfiguredSinks("sql-jpa.txt", "SQL_INJECTION_JPA");
        this.loadConfiguredSinks("sql-jdbc.txt", "SQL_INJECTION_JDBC");
        this.loadConfiguredSinks("sql-spring.txt", "SQL_INJECTION_SPRING_JDBC");
        this.loadConfiguredSinks("sql-scala-slick.txt", "SCALA_SQL_INJECTION_SLICK");
        this.loadConfiguredSinks("sql-scala-anorm.txt", "SCALA_SQL_INJECTION_ANORM");
        this.loadConfiguredSinks("sql-turbine.txt", "SQL_INJECTION_TURBINE");
        this.loadConfiguredSinks("sql-vertx-sql-client.txt", "SQL_INJECTION_VERTX");
    }

    @Override
    protected int getPriority(Taint taint) {
        if (!taint.isSafe() && taint.hasTag(Taint.Tag.SQL_INJECTION_SAFE)) {
            return 5;
        }
        if (!taint.isSafe() && taint.hasTag(Taint.Tag.APOSTROPHE_ENCODED)) {
            return 3;
        }
        return super.getPriority(taint);
    }
}

