/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;

public class BigMatrixImpl
implements BigMatrix,
Serializable {
    private static final long serialVersionUID = -1011428905656140431L;
    private BigDecimal[][] data = null;
    private BigDecimal[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;
    private int roundingMode = 4;
    private int scale = 64;
    protected static BigDecimal TOO_SMALL = new BigDecimal(1.0E-11);
    static final BigDecimal ZERO = new BigDecimal(0.0);
    static final BigDecimal ONE = new BigDecimal(1.0);

    public BigMatrixImpl() {
    }

    public BigMatrixImpl(int rowDimension, int columnDimension) {
        if (rowDimension <= 0 || columnDimension <= 0) {
            throw new IllegalArgumentException("row and column dimensions must be positive");
        }
        this.data = new BigDecimal[rowDimension][columnDimension];
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d) {
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(double[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int row = 1;
        while (row < nRows) {
            if (d[row].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++row;
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(String[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int row = 1;
        while (row < nRows) {
            if (d[row].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++row;
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[] v) {
        int nRows = v.length;
        this.data = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    public BigMatrix copy() {
        return new BigMatrixImpl(this.copyOut());
    }

    public BigMatrix add(BigMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getColumnDimension() || this.getRowDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].add(m.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix subtract(BigMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getColumnDimension() || this.getRowDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].subtract(m.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix scalarAdd(BigDecimal d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].add(d);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix scalarMultiply(BigDecimal d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].multiply(d);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix multiply(BigMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("Matrices are not multiplication compatible.");
        }
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nRows][nCols];
        BigDecimal sum = ZERO;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                sum = ZERO;
                int i = 0;
                while (i < nSum) {
                    sum = sum.add(this.data[row][i].multiply(m.getEntry(i, col)));
                    ++i;
                }
                outData[row][col] = sum;
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix preMultiply(BigMatrix m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    public BigDecimal[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataAsDoubleArray() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[][] d = new double[nRows][nCols];
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nCols) {
                d[i][j] = this.data[i][j].doubleValue();
                ++j;
            }
            ++i;
        }
        return d;
    }

    public BigDecimal[][] getDataRef() {
        return this.data;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public BigDecimal getNorm() {
        BigDecimal maxColSum = ZERO;
        int col = 0;
        while (col < this.getColumnDimension()) {
            BigDecimal sum = ZERO;
            int row = 0;
            while (row < this.getRowDimension()) {
                sum = sum.add(this.data[row][col].abs());
                ++row;
            }
            maxColSum = maxColSum.max(sum);
            ++col;
        }
        return maxColSum;
    }

    public BigMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        if (startRow < 0 || startRow > endRow || endRow > this.data.length || startColumn < 0 || startColumn > endColumn || endColumn > this.data[0].length) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        BigMatrixImpl subMatrix = new BigMatrixImpl(endRow - startRow + 1, endColumn - startColumn + 1);
        BigDecimal[][] subMatrixData = subMatrix.getDataRef();
        int i = startRow;
        while (i <= endRow) {
            int j = startColumn;
            while (j <= endColumn) {
                subMatrixData[i - startRow][j - startColumn] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    public BigMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            throw new MatrixIndexException("selected row and column index arrays must be non-empty");
        }
        BigMatrixImpl subMatrix = new BigMatrixImpl(selectedRows.length, selectedColumns.length);
        BigDecimal[][] subMatrixData = subMatrix.getDataRef();
        try {
            int i = 0;
            while (i < selectedRows.length) {
                int j = 0;
                while (j < selectedColumns.length) {
                    subMatrixData[i][j] = this.data[selectedRows[i]][selectedColumns[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("matrix dimension mismatch");
        }
        return subMatrix;
    }

    public void setSubMatrix(BigDecimal[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (row < 0 || column < 0) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++r;
        }
        if (this.data == null) {
            if (row > 0 || column > 0) {
                throw new MatrixIndexException("matrix must be initialized to perfom this method");
            }
            this.data = new BigDecimal[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        }
        if (nRows + row > this.getRowDimension() || nCols + column > this.getColumnDimension()) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int i = 0;
        while (i < nRows) {
            System.arraycopy(subMatrix[i], 0, this.data[row + i], column, nCols);
            ++i;
        }
        this.lu = null;
    }

    public BigMatrix getRowMatrix(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        BigDecimal[][] out = new BigDecimal[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new BigMatrixImpl(out);
    }

    public BigMatrix getColumnMatrix(int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, column)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            out[row][0] = this.data[row][column];
            ++row;
        }
        return new BigMatrixImpl(out);
    }

    public BigDecimal[] getRow(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    public double[] getRowAsDoubleArray(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        int i = 0;
        while (i < ncols) {
            out[i] = this.data[row][i].doubleValue();
            ++i;
        }
        return out;
    }

    public BigDecimal[] getColumn(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        int i = 0;
        while (i < nRows) {
            out[i] = this.data[i][col];
            ++i;
        }
        return out;
    }

    public double[] getColumnAsDoubleArray(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nrows = this.getRowDimension();
        double[] out = new double[nrows];
        int i = 0;
        while (i < nrows) {
            out[i] = this.data[i][col].doubleValue();
            ++i;
        }
        return out;
    }

    public BigDecimal getEntry(int row, int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, column)) {
            throw new MatrixIndexException("matrix entry does not exist");
        }
        return this.data[row][column];
    }

    public double getEntryAsDouble(int row, int column) throws MatrixIndexException {
        return this.getEntry(row, column).doubleValue();
    }

    public BigMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigMatrixImpl out = new BigMatrixImpl(nCols, nRows);
        BigDecimal[][] outData = out.getDataRef();
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                outData[col][row] = this.data[row][col];
                ++col;
            }
            ++row;
        }
        return out;
    }

    public BigMatrix inverse() throws InvalidMatrixException {
        return this.solve(MatrixUtils.createBigIdentityMatrix(this.getRowDimension()));
    }

    public BigDecimal getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new InvalidMatrixException("matrix is not square");
        }
        if (this.isSingular()) {
            return ZERO;
        }
        BigDecimal det = this.parity == 1 ? ONE : ONE.negate();
        int i = 0;
        while (i < this.getRowDimension()) {
            det = det.multiply(this.lu[i][i]);
            ++i;
        }
        return det;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data[0].length;
    }

    public BigDecimal getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("matrix is not square");
        }
        BigDecimal trace = this.data[0][0];
        int i = 1;
        while (i < this.getRowDimension()) {
            trace = trace.add(this.data[i][i]);
            ++i;
        }
        return trace;
    }

    public BigDecimal[] operate(BigDecimal[] v) throws IllegalArgumentException {
        if (v.length != this.getColumnDimension()) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[v.length];
        int row = 0;
        while (row < nRows) {
            BigDecimal sum = ZERO;
            int i = 0;
            while (i < nCols) {
                sum = sum.add(this.data[row][i].multiply(v[i]));
                ++i;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    public BigDecimal[] operate(double[] v) throws IllegalArgumentException {
        BigDecimal[] bd = new BigDecimal[v.length];
        int i = 0;
        while (i < bd.length) {
            bd[i] = new BigDecimal(v[i]);
            ++i;
        }
        return this.operate(bd);
    }

    public BigDecimal[] preMultiply(BigDecimal[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v.length != nRows) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nCols];
        int col = 0;
        while (col < nCols) {
            BigDecimal sum = ZERO;
            int i = 0;
            while (i < nRows) {
                sum = sum.add(this.data[i][col].multiply(v[i]));
                ++i;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    public BigDecimal[] solve(BigDecimal[] b) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b.length != nRows) {
            throw new IllegalArgumentException("constant vector has wrong length");
        }
        BigMatrixImpl bMatrix = new BigMatrixImpl(b);
        BigDecimal[][] solution = ((BigMatrixImpl)this.solve(bMatrix)).getDataRef();
        BigDecimal[] out = new BigDecimal[nRows];
        int row = 0;
        while (row < nRows) {
            out[row] = solution[row][0];
            ++row;
        }
        return out;
    }

    public BigDecimal[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        BigDecimal[] bd = new BigDecimal[b.length];
        int i = 0;
        while (i < bd.length) {
            bd[i] = new BigDecimal(b[i]);
            ++i;
        }
        return this.solve(bd);
    }

    public BigMatrix solve(BigMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        int j;
        int col;
        if (b.getRowDimension() != this.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect row dimension");
        }
        if (!this.isSquare()) {
            throw new InvalidMatrixException("coefficient matrix is not square");
        }
        if (this.isSingular()) {
            throw new InvalidMatrixException("Matrix is singular.");
        }
        int nCol = this.getColumnDimension();
        int nColB = b.getColumnDimension();
        int nRowB = b.getRowDimension();
        BigDecimal[][] bp = new BigDecimal[nRowB][nColB];
        int row = 0;
        while (row < nRowB) {
            col = 0;
            while (col < nColB) {
                bp[row][col] = b.getEntry(this.permutation[row], col);
                ++col;
            }
            ++row;
        }
        col = 0;
        while (col < nCol) {
            int i = col + 1;
            while (i < nCol) {
                j = 0;
                while (j < nColB) {
                    bp[i][j] = bp[i][j].subtract(bp[col][j].multiply(this.lu[i][col]));
                    ++j;
                }
                ++i;
            }
            ++col;
        }
        int col2 = nCol - 1;
        while (col2 >= 0) {
            j = 0;
            while (j < nColB) {
                bp[col2][j] = bp[col2][j].divide(this.lu[col2][col2], this.scale, this.roundingMode);
                ++j;
            }
            int i = 0;
            while (i < col2) {
                int j2 = 0;
                while (j2 < nColB) {
                    bp[i][j2] = bp[i][j2].subtract(bp[col2][j2].multiply(this.lu[i][col2]));
                    ++j2;
                }
                ++i;
            }
            --col2;
        }
        BigMatrixImpl outMat = new BigMatrixImpl(bp);
        return outMat;
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new InvalidMatrixException("LU decomposition requires that the matrix be square.");
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        int row = 0;
        while (row < nRows) {
            this.permutation[row] = row;
            ++row;
        }
        this.parity = 1;
        int col = 0;
        while (col < nCols) {
            BigDecimal sum = ZERO;
            int row2 = 0;
            while (row2 < col) {
                sum = this.lu[row2][col];
                int i = 0;
                while (i < row2) {
                    sum = sum.subtract(this.lu[row2][i].multiply(this.lu[i][col]));
                    ++i;
                }
                this.lu[row2][col] = sum;
                ++row2;
            }
            int max = col;
            BigDecimal largest = ZERO;
            int row3 = col;
            while (row3 < nRows) {
                sum = this.lu[row3][col];
                int i = 0;
                while (i < col) {
                    sum = sum.subtract(this.lu[row3][i].multiply(this.lu[i][col]));
                    ++i;
                }
                this.lu[row3][col] = sum;
                if (sum.abs().compareTo(largest) == 1) {
                    largest = sum.abs();
                    max = row3;
                }
                ++row3;
            }
            if (this.lu[max][col].abs().compareTo(TOO_SMALL) <= 0) {
                this.lu = null;
                throw new InvalidMatrixException("matrix is singular");
            }
            if (max != col) {
                BigDecimal tmp = ZERO;
                int i = 0;
                while (i < nCols) {
                    tmp = this.lu[max][i];
                    this.lu[max][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                    ++i;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            int row4 = col + 1;
            while (row4 < nRows) {
                this.lu[row4][col] = this.lu[row4][col].divide(this.lu[col][col], this.scale, this.roundingMode);
                ++row4;
            }
            ++col;
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("BigMatrixImpl{");
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                if (i > 0) {
                    res.append(",");
                }
                res.append("{");
                int j = 0;
                while (j < this.data[0].length) {
                    if (j > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i][j]);
                    ++j;
                }
                res.append("}");
                ++i;
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigMatrixImpl)) {
            return false;
        }
        BigMatrix m = (BigMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (!this.data[row][col].equals(m.getEntry(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * this.data[row][col].hashCode();
                ++col;
            }
            ++row;
        }
        return ret;
    }

    protected BigMatrix getIdentity(int dimension) {
        return MatrixUtils.createBigIdentityMatrix(dimension);
    }

    protected BigMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new BigMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private BigDecimal[][] copyOut() {
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][this.getColumnDimension()];
        int i = 0;
        while (i < nRows) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
            ++i;
        }
        return out;
    }

    private void copyIn(BigDecimal[][] in) {
        this.setSubMatrix(in, 0, 0);
    }

    private void copyIn(double[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nCols) {
                this.data[i][j] = new BigDecimal(in[i][j]);
                ++j;
            }
            ++i;
        }
        this.lu = null;
    }

    private void copyIn(String[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nCols) {
                this.data[i][j] = new BigDecimal(in[i][j]);
                ++j;
            }
            ++i;
        }
        this.lu = null;
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        return row >= 0 && row < nRows && col >= 0 && col < nCols;
    }
}

