/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;

public class FastFourierTransformer
implements Serializable {
    static final long serialVersionUID = 5138259215438106000L;
    private Complex[] omega = new Complex[0];
    private int omegaCount = 0;

    public Complex[] transform(double[] f) throws MathException, IllegalArgumentException {
        return this.fft(f, false);
    }

    public Complex[] transform(UnivariateRealFunction f, double min, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        return this.fft(data, false);
    }

    public Complex[] transform(Complex[] f) throws MathException, IllegalArgumentException {
        this.computeOmega(f.length);
        return this.fft(f);
    }

    public Complex[] transform2(double[] f) throws MathException, IllegalArgumentException {
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f, false), scaling_coefficient);
    }

    public Complex[] transform2(UnivariateRealFunction f, double min, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        double scaling_coefficient = 1.0 / Math.sqrt(n);
        return FastFourierTransformer.scaleArray(this.fft(data, false), scaling_coefficient);
    }

    public Complex[] transform2(Complex[] f) throws MathException, IllegalArgumentException {
        this.computeOmega(f.length);
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f), scaling_coefficient);
    }

    public Complex[] inversetransform(double[] f) throws MathException, IllegalArgumentException {
        double scaling_coefficient = 1.0 / (double)f.length;
        return FastFourierTransformer.scaleArray(this.fft(f, true), scaling_coefficient);
    }

    public Complex[] inversetransform(UnivariateRealFunction f, double min, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        double scaling_coefficient = 1.0 / (double)n;
        return FastFourierTransformer.scaleArray(this.fft(data, true), scaling_coefficient);
    }

    public Complex[] inversetransform(Complex[] f) throws MathException, IllegalArgumentException {
        this.computeOmega(-f.length);
        double scaling_coefficient = 1.0 / (double)f.length;
        return FastFourierTransformer.scaleArray(this.fft(f), scaling_coefficient);
    }

    public Complex[] inversetransform2(double[] f) throws MathException, IllegalArgumentException {
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f, true), scaling_coefficient);
    }

    public Complex[] inversetransform2(UnivariateRealFunction f, double min, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        double scaling_coefficient = 1.0 / Math.sqrt(n);
        return FastFourierTransformer.scaleArray(this.fft(data, true), scaling_coefficient);
    }

    public Complex[] inversetransform2(Complex[] f) throws MathException, IllegalArgumentException {
        this.computeOmega(-f.length);
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f), scaling_coefficient);
    }

    protected Complex[] fft(double[] f, boolean isInverse) throws MathException, IllegalArgumentException {
        FastFourierTransformer.verifyDataSet(f);
        Complex[] F = new Complex[f.length];
        if (f.length == 1) {
            F[0] = new Complex(f[0], 0.0);
            return F;
        }
        int N = f.length >> 1;
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = new Complex(f[2 * i], f[2 * i + 1]);
        }
        this.computeOmega(isInverse ? -N : N);
        Complex[] z = this.fft(c);
        this.computeOmega(isInverse ? -2 * N : 2 * N);
        F[0] = new Complex(2.0 * (z[0].getReal() + z[0].getImaginary()), 0.0);
        F[N] = new Complex(2.0 * (z[0].getReal() - z[0].getImaginary()), 0.0);
        for (int i = 1; i < N; ++i) {
            Complex A = z[N - i].conjugate();
            Complex B = z[i].add(A);
            Complex C = z[i].subtract(A);
            Complex D = this.omega[i].multiply(Complex.I);
            F[i] = B.subtract(C.multiply(D));
            F[2 * N - i] = F[i].conjugate();
        }
        return FastFourierTransformer.scaleArray(F, 0.5);
    }

    protected Complex[] fft(Complex[] data) throws MathException, IllegalArgumentException {
        int k;
        int i;
        int N = data.length;
        Complex[] f = new Complex[N];
        FastFourierTransformer.verifyDataSet(data);
        if (N == 1) {
            f[0] = data[0];
            return f;
        }
        if (N == 2) {
            f[0] = data[0].add(data[1]);
            f[1] = data[0].subtract(data[1]);
            return f;
        }
        int j = 0;
        for (i = 0; i < N; ++i) {
            f[i] = data[j];
            for (k = N >> 1; j >= k && k > 0; j -= k, k >>= 1) {
            }
            j += k;
        }
        for (i = 0; i < N; i += 4) {
            Complex A = f[i].add(f[i + 1]);
            Complex B = f[i + 2].add(f[i + 3]);
            Complex C = f[i].subtract(f[i + 1]);
            Complex D = f[i + 2].subtract(f[i + 3]);
            Complex E = C.add(D.multiply(Complex.I));
            Complex F = C.subtract(D.multiply(Complex.I));
            f[i] = A.add(B);
            f[i + 2] = A.subtract(B);
            f[i + 1] = this.omegaCount < 0 ? E : F;
            f[i + 3] = this.omegaCount > 0 ? E : F;
        }
        for (i = 4; i < N; i <<= 1) {
            int m = N / (i << 1);
            for (j = 0; j < N; j += i << 1) {
                for (k = 0; k < i; ++k) {
                    Complex z = f[i + j + k].multiply(this.omega[k * m]);
                    f[i + j + k] = f[j + k].subtract(z);
                    f[j + k] = f[j + k].add(z);
                }
            }
        }
        return f;
    }

    protected void computeOmega(int n) throws IllegalArgumentException {
        if (n == 0) {
            throw new IllegalArgumentException("Cannot compute 0-th root of unity, indefinite result.");
        }
        if (n == this.omegaCount) {
            return;
        }
        if (n + this.omegaCount == 0) {
            for (int i = 0; i < Math.abs(this.omegaCount); ++i) {
                this.omega[i] = this.omega[i].conjugate();
            }
            this.omegaCount = n;
            return;
        }
        this.omega = new Complex[Math.abs(n)];
        double t = Math.PI * 2 / (double)n;
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        this.omega[0] = new Complex(1.0, 0.0);
        for (int i = 1; i < Math.abs(n); ++i) {
            this.omega[i] = new Complex(this.omega[i - 1].getReal() * cost + this.omega[i - 1].getImaginary() * sint, this.omega[i - 1].getImaginary() * cost - this.omega[i - 1].getReal() * sint);
        }
        this.omegaCount = n;
    }

    public static double[] sample(UnivariateRealFunction f, double min, double max, int n) throws MathException, IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of samples not positive.");
        }
        FastFourierTransformer.verifyInterval(min, max);
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        for (int i = 0; i < n; ++i) {
            s[i] = f.value(min + (double)i * h);
        }
        return s;
    }

    public static double[] scaleArray(double[] f, double d) {
        int i = 0;
        while (i < f.length) {
            int n = i++;
            f[n] = f[n] * d;
        }
        return f;
    }

    public static Complex[] scaleArray(Complex[] f, double d) {
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Complex(d * f[i].getReal(), d * f[i].getImaginary());
        }
        return f;
    }

    public static boolean isPowerOf2(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static void verifyDataSet(double[] d) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2(d.length)) {
            throw new IllegalArgumentException("Number of samples not power of 2, consider padding for fix.");
        }
    }

    public static void verifyDataSet(Object[] o) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2(o.length)) {
            throw new IllegalArgumentException("Number of samples not power of 2, consider padding for fix.");
        }
    }

    public static void verifyInterval(double lower, double upper) throws IllegalArgumentException {
        if (lower >= upper) {
            throw new IllegalArgumentException("Endpoints do not specify an interval: [" + lower + ", " + upper + "]");
        }
    }
}

