/*
 * Copyright 2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.math.analysis;

/**
 * Extension of {@link UnivariateRealFunction} representing a differentiable univariate real function.
 *
 * @version $Revision: 1.2 $ $Date: 2004/06/23 16:26:14 $
 */
public interface DifferentiableUnivariateRealFunction
    extends UnivariateRealFunction {
 
    /**
     * Returns the derivative of the function
     * 
     * @return  the derivative function
     */
    public UnivariateRealFunction derivative();

}
