/*
 * Copyright 2003-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.math.util;

import junit.framework.TestCase;

/**
 * @version $Revision: 155427 $ $Date: 2005-02-26 06:11:52 -0700 (Sat, 26 Feb 2005) $
 */
public class TransformerMapTest extends TestCase {
    /**
     * 
     */
    public void testPutTransformer(){
        NumberTransformer expected = new DefaultTransformer();
        
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertEquals(expected, map.getTransformer(TransformerMapTest.class));
    }
    
    /**
     * 
     */
    public void testContainsClass(){
        NumberTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertTrue(map.containsClass(TransformerMapTest.class));
    }
    
    /**
     * 
     */
    public void testContainsTransformer(){
        NumberTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertTrue(map.containsTransformer(expected));
    }

    /**
     * 
     */
    public void testRemoveTransformer(){
        NumberTransformer expected = new DefaultTransformer();
        
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertTrue(map.containsClass(TransformerMapTest.class));
        assertTrue(map.containsTransformer(expected));
        map.removeTransformer(TransformerMapTest.class);
        assertFalse(map.containsClass(TransformerMapTest.class));
        assertFalse(map.containsTransformer(expected));
    }

    /**
     * 
     */
    public void testClear(){
        NumberTransformer expected = new DefaultTransformer();
        
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertTrue(map.containsClass(TransformerMapTest.class));
        map.clear();
        assertFalse(map.containsClass(TransformerMapTest.class));
    }
    
    /**
     * 
     */
    public void testClasses(){
        NumberTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertTrue(map.classes().contains(TransformerMapTest.class));
    }
    
    /**
     * 
     */
    public void testTransformers(){
        NumberTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, expected);
        assertTrue(map.transformers().contains(expected));
    }
}
