/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.ManagedBean;

public final class Registry {
    private HashMap beans = new HashMap();
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$modeler$Registry == null ? (class$org$apache$commons$modeler$Registry = Registry.class$("org.apache.commons.modeler.Registry")) : class$org$apache$commons$modeler$Registry));
    private static Registry registry = null;
    private static MBeanServer server = null;
    static /* synthetic */ Class class$org$apache$commons$modeler$Registry;

    private Registry() {
    }

    public void addManagedBean(ManagedBean bean) {
        this.beans.put(bean.getName(), bean);
    }

    public ManagedBean findManagedBean(String name) {
        return (ManagedBean)this.beans.get(name);
    }

    public String[] findManagedBeans() {
        return this.beans.keySet().toArray(new String[0]);
    }

    public String[] findManagedBeans(String group) {
        ArrayList<String> results = new ArrayList<String>();
        Iterator items = this.beans.values().iterator();
        while (items.hasNext()) {
            ManagedBean item = (ManagedBean)items.next();
            if (group == null && item.getGroup() == null) {
                results.add(item.getName());
                continue;
            }
            if (!group.equals(item.getGroup())) continue;
            results.add(item.getName());
        }
        String[] values = new String[results.size()];
        return results.toArray(values);
    }

    public void removeManagedBean(ManagedBean bean) {
        this.beans.remove(bean.getName());
    }

    public static synchronized Registry getRegistry() {
        if (registry == null) {
            log.info((Object)"Creating new Registry instance");
            registry = new Registry();
        }
        return registry;
    }

    public static synchronized MBeanServer getServer() {
        if (server == null) {
            log.info((Object)"Creating MBeanServer");
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }

    public static void loadRegistry(InputStream stream) throws Exception {
        log.info((Object)"Loading registry information");
        Registry registry = Registry.getRegistry();
        Digester digester = new Digester();
        digester.setNamespaceAware(false);
        digester.setValidating(true);
        URL url = registry.getClass().getResource("/org/apache/commons/modeler/mbeans-descriptors.dtd");
        digester.register("-//Apache Software Foundation//DTD Model MBeans Configuration File", url.toString());
        digester.push((Object)registry);
        digester.addObjectCreate("mbeans-descriptors/mbean", "org.apache.commons.modeler.ManagedBean");
        digester.addSetProperties("mbeans-descriptors/mbean");
        digester.addSetNext("mbeans-descriptors/mbean", "addManagedBean", "org.apache.commons.modeler.ManagedBean");
        digester.addObjectCreate("mbeans-descriptors/mbean/attribute", "org.apache.commons.modeler.AttributeInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/attribute");
        digester.addSetNext("mbeans-descriptors/mbean/attribute", "addAttribute", "org.apache.commons.modeler.AttributeInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/constructor", "org.apache.commons.modeler.ConstructorInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/constructor");
        digester.addSetNext("mbeans-descriptors/mbean/constructor", "addConstructor", "org.apache.commons.modeler.ConstructorInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/constructor/parameter", "org.apache.commons.modeler.ParameterInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/constructor/parameter");
        digester.addSetNext("mbeans-descriptors/mbean/constructor/parameter", "addParameter", "org.apache.commons.modeler.ParameterInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/notification", "org.apache.commons.modeler.NotificationInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/notification");
        digester.addSetNext("mbeans-descriptors/mbean/notification", "addNotification", "org.apache.commons.modeler.NotificationInfo");
        digester.addCallMethod("mbeans-descriptors/mbean/notification/notification-type", "addNotificationType", 0);
        digester.addObjectCreate("mbeans-descriptors/mbean/operation", "org.apache.commons.modeler.OperationInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation");
        digester.addSetNext("mbeans-descriptors/mbean/operation", "addOperation", "org.apache.commons.modeler.OperationInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/operation/parameter", "org.apache.commons.modeler.ParameterInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation/parameter");
        digester.addSetNext("mbeans-descriptors/mbean/operation/parameter", "addParameter", "org.apache.commons.modeler.ParameterInfo");
        try {
            digester.parse(stream);
        }
        catch (Exception e) {
            log.error((Object)"Error digesting Registry data", (Throwable)e);
            throw e;
        }
    }

    public static void setServer(MBeanServer mbeanServer) {
        server = mbeanServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

