/*
 * Decompiled with CFR 0.152.
 */
package examples.ftp;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.util.TrustManagerUtils;

public final class FTPClientExample {
    public static final String USAGE = "Usage: ftp [options] <hostname> <username> <password> [<remote file> [<local file>]]\n\nDefault behavior is to download a file and use ASCII transfer mode.\n\t-a - use local active mode (default is local passive)\n\t-b - use binary transfer mode\n\t-c cmd - issue arbitrary command (remote is used as a parameter if provided) \n\t-d - list directory details using MLSD (remote is used as the pathname if provided)\n\t-e - use EPSV with IPv4 (default false)\n\t-f - issue FEAT command (remote and local files are ignored)\n\t-h - list hidden files (applies to -l and -n only)\n\t-k secs - use keep-alive timer (setControlKeepAliveTimeout)\n\t-l - list files using LIST (remote is used as the pathname if provided)\n\t-L - use lenient future dates (server dates may be up to 1 day into future)\n\t-n - list file names using NLST (remote is used as the pathname if provided)\n\t-p true|false|protocol[,true|false] - use FTPSClient with the specified protocol and/or isImplicit setting\n\t-s - store file on server (upload)\n\t-t - list file details using MLST (remote is used as the pathname if provided)\n\t-w msec - wait time for keep-alive reply (setControlKeepAliveReplyTimeout)\n\t-T  all|valid|none - use one of the built-in TrustManager implementations (none = JVM default)\n\t-# - add hash display during transfers\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        FTPClient ftp;
        int remain;
        boolean storeFile = false;
        boolean binaryTransfer = false;
        boolean error = false;
        boolean listFiles = false;
        boolean listNames = false;
        boolean hidden = false;
        boolean localActive = false;
        boolean useEpsvWithIPv4 = false;
        boolean feat = false;
        boolean printHash = false;
        boolean mlst = false;
        boolean mlsd = false;
        boolean lenient = false;
        long keepAliveTimeout = -1L;
        int controlKeepAliveReplyTimeout = -1;
        int minParams = 5;
        String protocol = null;
        String doCommand = null;
        String trustmgr = null;
        int base = 0;
        for (base = 0; base < args.length; ++base) {
            if (args[base].equals("-s")) {
                storeFile = true;
                continue;
            }
            if (args[base].equals("-a")) {
                localActive = true;
                continue;
            }
            if (args[base].equals("-b")) {
                binaryTransfer = true;
                continue;
            }
            if (args[base].equals("-c")) {
                doCommand = args[++base];
                minParams = 3;
                continue;
            }
            if (args[base].equals("-d")) {
                mlsd = true;
                minParams = 3;
                continue;
            }
            if (args[base].equals("-e")) {
                useEpsvWithIPv4 = true;
                continue;
            }
            if (args[base].equals("-f")) {
                feat = true;
                minParams = 3;
                continue;
            }
            if (args[base].equals("-h")) {
                hidden = true;
                continue;
            }
            if (args[base].equals("-k")) {
                keepAliveTimeout = Long.parseLong(args[++base]);
                continue;
            }
            if (args[base].equals("-l")) {
                listFiles = true;
                minParams = 3;
                continue;
            }
            if (args[base].equals("-L")) {
                lenient = true;
                continue;
            }
            if (args[base].equals("-n")) {
                listNames = true;
                minParams = 3;
                continue;
            }
            if (args[base].equals("-p")) {
                protocol = args[++base];
                continue;
            }
            if (args[base].equals("-t")) {
                mlst = true;
                minParams = 3;
                continue;
            }
            if (args[base].equals("-w")) {
                controlKeepAliveReplyTimeout = Integer.parseInt(args[++base]);
                continue;
            }
            if (args[base].equals("-T")) {
                trustmgr = args[++base];
                continue;
            }
            if (!args[base].equals("-#")) break;
            printHash = true;
        }
        if ((remain = args.length - base) < minParams) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String server = args[base++];
        int port = 0;
        String[] parts = server.split(":");
        if (parts.length == 2) {
            server = parts[0];
            port = Integer.parseInt(parts[1]);
        }
        String username = args[base++];
        String password = args[base++];
        String remote = null;
        if (args.length - base > 0) {
            remote = args[base++];
        }
        String local = null;
        if (args.length - base > 0) {
            local = args[base++];
        }
        if (protocol == null) {
            ftp = new FTPClient();
        } else {
            String[] prot;
            FTPSClient ftps = protocol.equals("true") ? new FTPSClient(true) : (protocol.equals("false") ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
            ftp = ftps;
            if ("all".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
            } else if ("valid".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
            } else if ("none".equals(trustmgr)) {
                ftps.setTrustManager(null);
            }
        }
        if (printHash) {
            ftp.setCopyStreamListener(FTPClientExample.createListener());
        }
        if (keepAliveTimeout >= 0L) {
            ftp.setControlKeepAliveTimeout(keepAliveTimeout);
        }
        if (controlKeepAliveReplyTimeout >= 0) {
            ftp.setControlKeepAliveReplyTimeout(controlKeepAliveReplyTimeout);
        }
        ftp.setListHiddenFiles(hidden);
        ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), true));
        try {
            if (port > 0) {
                ftp.connect(server, port);
            } else {
                ftp.connect(server);
            }
            System.out.println("Connected to " + server + " on " + ftp.getRemotePort());
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            System.err.println("Could not connect to server.");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (!ftp.login(username, password)) {
                ftp.logout();
                error = true;
            } else {
                System.out.println("Remote system is " + ftp.getSystemType());
                if (binaryTransfer) {
                    ftp.setFileType(2);
                }
                if (localActive) {
                    ftp.enterLocalActiveMode();
                } else {
                    ftp.enterLocalPassiveMode();
                }
                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                if (storeFile) {
                    FileInputStream input = new FileInputStream(local);
                    ftp.storeFile(remote, (InputStream)input);
                    ((InputStream)input).close();
                } else if (listFiles) {
                    if (lenient) {
                        FTPClientConfig config = new FTPClientConfig();
                        config.setLenientFutureDates(true);
                        ftp.configure(config);
                    }
                    for (FTPFile f : ftp.listFiles(remote)) {
                        System.out.println(f.getRawListing());
                        System.out.println(f.toFormattedString());
                    }
                } else if (mlsd) {
                    for (FTPFile f : ftp.mlistDir(remote)) {
                        System.out.println(f.getRawListing());
                        System.out.println(f.toFormattedString());
                    }
                } else if (mlst) {
                    FTPFile f = ftp.mlistFile(remote);
                    if (f != null) {
                        System.out.println(f.toFormattedString());
                    }
                } else if (listNames) {
                    for (String s : ftp.listNames(remote)) {
                        System.out.println(s);
                    }
                } else if (feat) {
                    if (remote != null) {
                        if (ftp.hasFeature(remote)) {
                            System.out.println("Has feature: " + remote);
                        } else if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " was not detected");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                        String[] features = ftp.featureValues(remote);
                        if (features != null) {
                            for (String f : features) {
                                System.out.println("FEAT " + remote + "=" + f + ".");
                            }
                        } else if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " is not present");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                    } else if (!ftp.features()) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else if (doCommand != null) {
                    if (!ftp.doCommand(doCommand, remote)) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else {
                    FileOutputStream output = new FileOutputStream(local);
                    ftp.retrieveFile(remote, (OutputStream)output);
                    ((OutputStream)output).close();
                }
                ftp.noop();
                ftp.logout();
            }
        }
        catch (FTPConnectionClosedException e) {
            error = true;
            System.err.println("Server closed connection.");
            e.printStackTrace();
        }
        catch (IOException e) {
            error = true;
            e.printStackTrace();
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {}
            }
        }
        System.exit(error ? 1 : 0);
    }

    private static CopyStreamListener createListener() {
        return new CopyStreamListener(){
            private long megsTotal = 0L;

            public void bytesTransferred(CopyStreamEvent event) {
                this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
            }

            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                long megs = totalBytesTransferred / 1000000L;
                for (long l = this.megsTotal; l < megs; ++l) {
                    System.err.print("#");
                }
                this.megsTotal = megs;
            }
        };
    }
}

