/*
 * Decompiled with CFR 0.152.
 */
package examples.nntp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketException;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.commons.net.nntp.NewsgroupInfo;

public class ArticleReader {
    public static void main(String[] args) throws SocketException, IOException {
        String line;
        long articleNum;
        BufferedReader br;
        String password;
        String user;
        if (args.length != 2 && args.length != 3 && args.length != 5) {
            System.out.println("Usage: MessageThreading <hostname> <groupname> [<article specifier> [<user> <password>]]");
            return;
        }
        String hostname = args[0];
        String newsgroup = args[1];
        String articleSpec = args.length >= 3 ? args[2] : null;
        NNTPClient client = new NNTPClient();
        client.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out), true));
        client.connect(hostname);
        if (args.length == 5 && !client.authenticate(user = args[3], password = args[4])) {
            System.out.println("Authentication failed for user " + user + "!");
            System.exit(1);
        }
        NewsgroupInfo group = new NewsgroupInfo();
        client.selectNewsgroup(newsgroup, group);
        if (articleSpec != null) {
            br = (BufferedReader)client.retrieveArticleHeader(articleSpec);
        } else {
            articleNum = group.getLastArticleLong();
            br = client.retrieveArticleHeader(articleNum);
        }
        if (br != null) {
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
        }
        if (articleSpec != null) {
            br = (BufferedReader)client.retrieveArticleBody(articleSpec);
        } else {
            articleNum = group.getLastArticleLong();
            br = client.retrieveArticleBody(articleNum);
        }
        if (br != null) {
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
        }
    }
}

