/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Main {
    public static void main(String[] args) throws Exception {
        String sourceFile;
        if (args.length == 0) {
            System.out.println("Usage: java -jar examples.jar <exampleClass> <exampleClass parameters>");
        }
        CodeSource codeSource = Main.class.getProtectionDomain().getCodeSource();
        HashMap<String, String> map = new HashMap<String, String>();
        if (codeSource != null && (sourceFile = codeSource.getLocation().getFile()).endsWith(".jar")) {
            if (args.length == 0) {
                System.out.println("\nClasses found in the jar:");
            }
            JarFile jf = new JarFile(sourceFile);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                String name = je.getName();
                if (!name.endsWith(".class") || name.contains("$") || name.equals("examples/nntp/NNTPUtils.class") || name.equals("examples/util/IOUtil.class") || name.equals("examples/Main.class")) continue;
                name = name.replace(".class", "");
                int lastSep = name.lastIndexOf(47);
                String alias = name.substring(lastSep + 1);
                if (args.length == 0) {
                    System.out.printf("%-25s %s%n", alias, name);
                }
                map.put(alias, name);
            }
            jf.close();
        }
        if (args.length == 0) {
            return;
        }
        String shortName = args[0];
        String fullName = (String)map.get(shortName);
        if (fullName == null) {
            fullName = shortName;
        }
        fullName = fullName.replace('/', '.');
        Class<?> clazz = Class.forName(fullName);
        Method m = clazz.getDeclaredMethod("main", args.getClass());
        String[] args2 = new String[args.length - 1];
        System.arraycopy(args, 1, args2, 0, args2.length);
        m.invoke(null, new Object[]{args2});
    }
}

