/*
 * Decompiled with CFR 0.152.
 */
package examples.ftp;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.util.TrustManagerUtils;

public final class FTPClientExample {
    public static final String USAGE = "Expected Parameters: [options] <hostname> <username> <password> [<remote file> [<local file>]]\n\nDefault behavior is to download a file and use ASCII transfer mode.\n\t-a - use local active mode (default is local passive)\n\t-A - anonymous login (omit username and password parameters)\n\t-b - use binary transfer mode\n\t-c cmd - issue arbitrary command (remote is used as a parameter if provided) \n\t-d - list directory details using MLSD (remote is used as the pathname if provided)\n\t-e - use EPSV with IPv4 (default false)\n\t-E - encoding to use for control channel\n\t-f - issue FEAT command (remote and local files are ignored)\n\t-h - list hidden files (applies to -l and -n only)\n\t-k secs - use keep-alive timer (setControlKeepAliveTimeout)\n\t-l - list files using LIST (remote is used as the pathname if provided)\n\t     Files are listed twice: first in raw mode, then as the formatted parsed data.\n\t     N.B. if the wrong server-type is used, output may be lost. Use -U or -S as necessary.\n\t-L - use lenient future dates (server dates may be up to 1 day into future)\n\t-m - list file details using MDTM (remote is used as the pathname if provided)\n\t-n - list file names using NLST (remote is used as the pathname if provided)\n\t-p true|false|protocol[,true|false] - use FTPSClient with the specified protocol and/or isImplicit setting\n\t-s - store file on server (upload)\n\t-S - systemType set server system type (e.g. UNIX VMS WINDOWS)\n\t-t - list file details using MLST (remote is used as the pathname if provided)\n\t-U - save unparseable responses\n\t-w msec - wait time for keep-alive reply (setControlKeepAliveReplyTimeout)\n\t-T  all|valid|none - use one of the built-in TrustManager implementations (none = JVM default)\n\t-y format - set default date format string\n\t-Y format - set recent date format string\n\t-Z timezone - set the server timezone for parsing LIST responses\n\t-z timezone - set the timezone for displaying MDTM, LIST, MLSD, MLST responses\n\t-PrH server[:port] - HTTP Proxy host and optional port[80] \n\t-PrU user - HTTP Proxy server username\n\t-PrP password - HTTP Proxy server password\n\t-# - add hash display during transfers\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws UnknownHostException {
        block106: {
            block105: {
                block103: {
                    storeFile = false;
                    binaryTransfer = false;
                    error = false;
                    listFiles = false;
                    listNames = false;
                    hidden = false;
                    localActive = false;
                    useEpsvWithIPv4 = false;
                    feat = false;
                    printHash = false;
                    mlst = false;
                    mlsd = false;
                    mdtm = false;
                    saveUnparseable = false;
                    lenient = false;
                    keepAliveTimeout = -1L;
                    controlKeepAliveReplyTimeout = -1;
                    minParams = 5;
                    protocol = null;
                    doCommand = null;
                    trustmgr = null;
                    proxyHost = null;
                    proxyPort = 80;
                    proxyUser = null;
                    proxyPassword = null;
                    username = null;
                    password = null;
                    encoding = null;
                    serverTimeZoneId = null;
                    displayTimeZoneId = null;
                    serverType = null;
                    defaultDateFormat = null;
                    recentDateFormat = null;
                    base = 0;
                    for (base = 0; base < args.length; ++base) {
                        if (args[base].equals("-s")) {
                            storeFile = true;
                            continue;
                        }
                        if (args[base].equals("-a")) {
                            localActive = true;
                            continue;
                        }
                        if (args[base].equals("-A")) {
                            username = "anonymous";
                            password = System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName();
                            continue;
                        }
                        if (args[base].equals("-b")) {
                            binaryTransfer = true;
                            continue;
                        }
                        if (args[base].equals("-c")) {
                            doCommand = args[++base];
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-d")) {
                            mlsd = true;
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-e")) {
                            useEpsvWithIPv4 = true;
                            continue;
                        }
                        if (args[base].equals("-E")) {
                            encoding = args[++base];
                            continue;
                        }
                        if (args[base].equals("-f")) {
                            feat = true;
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-h")) {
                            hidden = true;
                            continue;
                        }
                        if (args[base].equals("-k")) {
                            keepAliveTimeout = Long.parseLong(args[++base]);
                            continue;
                        }
                        if (args[base].equals("-l")) {
                            listFiles = true;
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-m")) {
                            mdtm = true;
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-L")) {
                            lenient = true;
                            continue;
                        }
                        if (args[base].equals("-n")) {
                            listNames = true;
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-p")) {
                            protocol = args[++base];
                            continue;
                        }
                        if (args[base].equals("-S")) {
                            serverType = args[++base];
                            continue;
                        }
                        if (args[base].equals("-t")) {
                            mlst = true;
                            minParams = 3;
                            continue;
                        }
                        if (args[base].equals("-U")) {
                            saveUnparseable = true;
                            continue;
                        }
                        if (args[base].equals("-w")) {
                            controlKeepAliveReplyTimeout = Integer.parseInt(args[++base]);
                            continue;
                        }
                        if (args[base].equals("-T")) {
                            trustmgr = args[++base];
                            continue;
                        }
                        if (args[base].equals("-y")) {
                            defaultDateFormat = args[++base];
                            continue;
                        }
                        if (args[base].equals("-Y")) {
                            recentDateFormat = args[++base];
                            continue;
                        }
                        if (args[base].equals("-Z")) {
                            serverTimeZoneId = args[++base];
                            continue;
                        }
                        if (args[base].equals("-z")) {
                            displayTimeZoneId = args[++base];
                            continue;
                        }
                        if (args[base].equals("-PrH")) {
                            if ((parts = (proxyHost = args[++base]).split(":")).length != 2) continue;
                            proxyHost = parts[0];
                            proxyPort = Integer.parseInt(parts[1]);
                            continue;
                        }
                        if (args[base].equals("-PrU")) {
                            proxyUser = args[++base];
                            continue;
                        }
                        if (args[base].equals("-PrP")) {
                            proxyPassword = args[++base];
                            continue;
                        }
                        if (!args[base].equals("-#")) break;
                        printHash = true;
                    }
                    remain = args.length - base;
                    if (username != null) {
                        minParams -= 2;
                    }
                    if (remain < minParams) {
                        if (args.length > 0) {
                            System.err.println("Actual Parameters: " + Arrays.toString(args));
                        }
                        System.err.println("Expected Parameters: [options] <hostname> <username> <password> [<remote file> [<local file>]]\n\nDefault behavior is to download a file and use ASCII transfer mode.\n\t-a - use local active mode (default is local passive)\n\t-A - anonymous login (omit username and password parameters)\n\t-b - use binary transfer mode\n\t-c cmd - issue arbitrary command (remote is used as a parameter if provided) \n\t-d - list directory details using MLSD (remote is used as the pathname if provided)\n\t-e - use EPSV with IPv4 (default false)\n\t-E - encoding to use for control channel\n\t-f - issue FEAT command (remote and local files are ignored)\n\t-h - list hidden files (applies to -l and -n only)\n\t-k secs - use keep-alive timer (setControlKeepAliveTimeout)\n\t-l - list files using LIST (remote is used as the pathname if provided)\n\t     Files are listed twice: first in raw mode, then as the formatted parsed data.\n\t     N.B. if the wrong server-type is used, output may be lost. Use -U or -S as necessary.\n\t-L - use lenient future dates (server dates may be up to 1 day into future)\n\t-m - list file details using MDTM (remote is used as the pathname if provided)\n\t-n - list file names using NLST (remote is used as the pathname if provided)\n\t-p true|false|protocol[,true|false] - use FTPSClient with the specified protocol and/or isImplicit setting\n\t-s - store file on server (upload)\n\t-S - systemType set server system type (e.g. UNIX VMS WINDOWS)\n\t-t - list file details using MLST (remote is used as the pathname if provided)\n\t-U - save unparseable responses\n\t-w msec - wait time for keep-alive reply (setControlKeepAliveReplyTimeout)\n\t-T  all|valid|none - use one of the built-in TrustManager implementations (none = JVM default)\n\t-y format - set default date format string\n\t-Y format - set recent date format string\n\t-Z timezone - set the server timezone for parsing LIST responses\n\t-z timezone - set the timezone for displaying MDTM, LIST, MLSD, MLST responses\n\t-PrH server[:port] - HTTP Proxy host and optional port[80] \n\t-PrU user - HTTP Proxy server username\n\t-PrP password - HTTP Proxy server password\n\t-# - add hash display during transfers\n");
                        System.exit(1);
                    }
                    server = args[base++];
                    port = 0;
                    parts = server.split(":");
                    if (parts.length == 2) {
                        server = parts[0];
                        port = Integer.parseInt(parts[1]);
                    }
                    if (username == null) {
                        username = args[base++];
                        password = args[base++];
                    }
                    remote = null;
                    if (args.length - base > 0) {
                        remote = args[base++];
                    }
                    local = null;
                    if (args.length - base > 0) {
                        local = args[base++];
                    }
                    if (protocol == null) {
                        if (proxyHost != null) {
                            System.out.println("Using HTTP proxy server: " + proxyHost);
                            ftp = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
                        } else {
                            ftp = new FTPClient();
                        }
                    } else {
                        ftps = protocol.equals("true") != false ? new FTPSClient(true) : (protocol.equals("false") != false ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
                        ftp = ftps;
                        if ("all".equals(trustmgr)) {
                            ftps.setTrustManager(TrustManagerUtils.getAcceptAllTrustManager());
                        } else if ("valid".equals(trustmgr)) {
                            ftps.setTrustManager(TrustManagerUtils.getValidateServerCertificateTrustManager());
                        } else if ("none".equals(trustmgr)) {
                            ftps.setTrustManager(null);
                        }
                    }
                    if (printHash) {
                        ftp.setCopyStreamListener(FTPClientExample.createListener());
                    }
                    if (keepAliveTimeout >= 0L) {
                        ftp.setControlKeepAliveTimeout(keepAliveTimeout);
                    }
                    if (controlKeepAliveReplyTimeout >= 0) {
                        ftp.setControlKeepAliveReplyTimeout(controlKeepAliveReplyTimeout);
                    }
                    if (encoding != null) {
                        ftp.setControlEncoding(encoding);
                    }
                    ftp.setListHiddenFiles(hidden);
                    ftp.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out), true));
                    config = serverType != null ? new FTPClientConfig(serverType) : new FTPClientConfig();
                    config.setUnparseableEntries(saveUnparseable);
                    if (defaultDateFormat != null) {
                        config.setDefaultDateFormatStr(defaultDateFormat);
                    }
                    if (recentDateFormat != null) {
                        config.setRecentDateFormatStr(recentDateFormat);
                    }
                    ftp.configure(config);
                    try {
                        if (port > 0) {
                            ftp.connect(server, port);
                        } else {
                            ftp.connect(server);
                        }
                        System.out.println("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort()));
                        reply = ftp.getReplyCode();
                        if (!FTPReply.isPositiveCompletion(reply)) {
                            ftp.disconnect();
                            System.err.println("FTP server refused connection.");
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        if (ftp.isConnected()) {
                            try {
                                ftp.disconnect();
                            }
                            catch (IOException f) {
                                // empty catch block
                            }
                        }
                        System.err.println("Could not connect to server.");
                        e.printStackTrace();
                        System.exit(1);
                    }
                    try {
                        try {
                            block104: {
                                block109: {
                                    block110: {
                                        block108: {
                                            block107: {
                                                if (!ftp.login(username, password)) {
                                                    ftp.logout();
                                                    error = true;
                                                    var50_62 = null;
                                                    break block103;
                                                }
                                                System.out.println("Remote system is " + ftp.getSystemType());
                                                if (binaryTransfer) {
                                                    ftp.setFileType(2);
                                                } else {
                                                    ftp.setFileType(0);
                                                }
                                                if (localActive) {
                                                    ftp.enterLocalActiveMode();
                                                } else {
                                                    ftp.enterLocalPassiveMode();
                                                }
                                                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                                                if (!storeFile) break block107;
                                                input = new FileInputStream(local);
                                                ftp.storeFile(remote, input);
                                                input.close();
                                                break block104;
                                            }
                                            if (!listFiles && !mlsd && !mdtm && !mlst && !listNames) break block108;
                                            if (mlsd) {
                                                arr$ = ftp.mlistDir(remote);
                                                len$ = arr$.length;
                                                for (i$ = 0; i$ < len$; ++i$) {
                                                    f = arr$[i$];
                                                    System.out.println(f.getRawListing());
                                                    System.out.println(f.toFormattedString(displayTimeZoneId));
                                                }
                                            }
                                            if (mdtm) {
                                                f = ftp.mdtmFile(remote);
                                                System.out.println(f.getRawListing());
                                                System.out.println(f.toFormattedString(displayTimeZoneId));
                                            }
                                            if (mlst && (f = ftp.mlistFile(remote)) != null) {
                                                System.out.println(f.toFormattedString(displayTimeZoneId));
                                            }
                                            if (listNames) {
                                                arr$ = ftp.listNames(remote);
                                                len$ = arr$.length;
                                                for (i$ = 0; i$ < len$; ++i$) {
                                                    s = arr$[i$];
                                                    System.out.println(s);
                                                }
                                            }
                                            if (listFiles) {
                                                if (lenient || serverTimeZoneId != null) {
                                                    config.setLenientFutureDates(lenient);
                                                    if (serverTimeZoneId != null) {
                                                        config.setServerTimeZoneId(serverTimeZoneId);
                                                    }
                                                    ftp.configure(config);
                                                }
                                                for (FTPFile f : ftp.listFiles(remote)) {
                                                    System.out.println(f.getRawListing());
                                                    System.out.println(f.toFormattedString(displayTimeZoneId));
                                                }
                                            }
                                            break block104;
                                        }
                                        if (!feat) break block109;
                                        if (remote == null) break block110;
                                        if (ftp.hasFeature(remote)) {
                                            System.out.println("Has feature: " + remote);
                                        } else if (FTPReply.isPositiveCompletion(ftp.getReplyCode())) {
                                            System.out.println("FEAT " + remote + " was not detected");
                                        } else {
                                            System.out.println("Command failed: " + ftp.getReplyString());
                                        }
                                        features = ftp.featureValues(remote);
                                        if (features != null) {
                                            for (String f : features) {
                                                System.out.println("FEAT " + remote + "=" + f + ".");
                                            }
                                            break block104;
                                        } else if (FTPReply.isPositiveCompletion(ftp.getReplyCode())) {
                                            System.out.println("FEAT " + remote + " is not present");
                                            break block104;
                                        } else {
                                            System.out.println("Command failed: " + ftp.getReplyString());
                                        }
                                        break block104;
                                    }
                                    if (!ftp.features()) {
                                        System.out.println("Failed: " + ftp.getReplyString());
                                    }
                                    break block104;
                                }
                                if (doCommand != null) {
                                    if (!ftp.doCommand(doCommand, remote)) {
                                        System.out.println("Failed: " + ftp.getReplyString());
                                    }
                                } else {
                                    output = new FileOutputStream(local);
                                    ftp.retrieveFile(remote, output);
                                    output.close();
                                }
                            }
                            ftp.noop();
                            ftp.logout();
                            break block105;
                        }
                        catch (FTPConnectionClosedException e) {
                            error = true;
                            System.err.println("Server closed connection.");
                            e.printStackTrace();
                            var50_64 = null;
                            if (ftp.isConnected()) {
                                try {
                                    ftp.disconnect();
                                }
                                catch (IOException f) {}
                            }
                            break block106;
                        }
                        catch (IOException e) {
                            error = true;
                            e.printStackTrace();
                            var50_65 = null;
                            if (ftp.isConnected()) {
                                try {}
                                catch (IOException f) {}
                                ftp.disconnect();
                            }
                            break block106;
                        }
                    }
                    catch (Throwable var49_77) {
                        var50_66 = null;
                        if (ftp.isConnected() == false) throw var49_77;
                        ** try [egrp 4[TRYBLOCK] [11 : 2438->2446)] { 
lbl342:
                        // 1 sources

                        ftp.disconnect();
                        throw var49_77;
lbl344:
                        // 1 sources

                        catch (IOException f) {
                            // empty catch block
                        }
                        throw var49_77;
                    }
                }
                if (ftp.isConnected()) {
                    try {}
                    catch (IOException f) {}
                    ftp.disconnect();
                }
                break block106;
            }
            var50_63 = null;
            if (ftp.isConnected()) {
                try {}
                catch (IOException f) {}
                ftp.disconnect();
            }
        }
        System.exit(error != false ? 1 : 0);
    }

    private static CopyStreamListener createListener() {
        return new CopyStreamListener(){
            private long megsTotal = 0L;

            public void bytesTransferred(CopyStreamEvent event) {
                this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
            }

            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                long megs = totalBytesTransferred / 1000000L;
                for (long l = this.megsTotal; l < megs; ++l) {
                    System.err.print("#");
                }
                this.megsTotal = megs;
            }
        };
    }
}

