/*
 * Decompiled with CFR 0.152.
 */
package examples.ntp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.commons.net.ntp.NtpUtils;
import org.apache.commons.net.ntp.NtpV3Impl;
import org.apache.commons.net.ntp.TimeStamp;

public class SimpleNTPServer
implements Runnable {
    private int port;
    private volatile boolean running;
    private boolean started;
    private DatagramSocket socket;

    public SimpleNTPServer() {
        this(123);
    }

    public SimpleNTPServer(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void connect() throws IOException {
        if (this.socket == null) {
            this.socket = new DatagramSocket(this.port);
            if (this.port == 0) {
                this.port = this.socket.getLocalPort();
            }
            System.out.println("Running NTP service on port " + this.port + "/UDP");
        }
    }

    public void start() throws IOException {
        if (this.socket == null) {
            this.connect();
        }
        if (!this.started) {
            this.started = true;
            new Thread(this).start();
        }
    }

    public void run() {
        this.running = true;
        byte[] buffer = new byte[48];
        DatagramPacket request = new DatagramPacket(buffer, buffer.length);
        do {
            try {
                this.socket.receive(request);
                long rcvTime = System.currentTimeMillis();
                this.handlePacket(request, rcvTime);
            }
            catch (IOException e) {
                if (!this.running) continue;
                e.printStackTrace();
            }
        } while (this.running);
    }

    protected void handlePacket(DatagramPacket request, long rcvTime) throws IOException {
        NtpV3Impl message = new NtpV3Impl();
        message.setDatagramPacket(request);
        System.out.printf("NTP packet from %s mode=%s%n", request.getAddress().getHostAddress(), NtpUtils.getModeName(message.getMode()));
        if (message.getMode() == 3) {
            NtpV3Impl response = new NtpV3Impl();
            response.setStratum(1);
            response.setMode(4);
            response.setVersion(3);
            response.setPrecision(-20);
            response.setPoll(0);
            response.setRootDelay(62);
            response.setRootDispersion(1081);
            response.setOriginateTimeStamp(message.getTransmitTimeStamp());
            response.setReceiveTimeStamp(TimeStamp.getNtpTime(rcvTime));
            response.setReferenceTime(response.getReceiveTimeStamp());
            response.setReferenceId(1279478784);
            response.setTransmitTime(TimeStamp.getNtpTime(System.currentTimeMillis()));
            DatagramPacket dp = response.getDatagramPacket();
            dp.setPort(request.getPort());
            dp.setAddress(request.getAddress());
            this.socket.send(dp);
        }
    }

    public void stop() {
        this.running = false;
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.started = false;
    }

    public static void main(String[] args) {
        int port = 123;
        if (args.length != 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        SimpleNTPServer timeServer = new SimpleNTPServer(port);
        try {
            timeServer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

