/*
 * Decompiled with CFR 0.152.
 */
package examples.mail;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Locale;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.commons.net.imap.IMAPSClient;

class IMAPUtils {
    IMAPUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IMAPClient imapLogin(URI uri, int defaultTimeout, ProtocolCommandListener listener) throws IOException {
        IMAPClient imap;
        String tmp;
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            throw new IllegalArgumentException("Missing userInfo details");
        }
        String[] userpass = userInfo.split(":");
        if (userpass.length != 2) {
            throw new IllegalArgumentException("Invalid userInfo details: '" + userInfo + "'");
        }
        String username = userpass[0];
        String password = userpass[1];
        if ("-".equals(password)) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            password = in.readLine();
        } else if ("*".equals(password)) {
            Console con = System.console();
            if (con == null) throw new IOException("Cannot access Console");
            char[] pwd = con.readPassword("Password for " + username + ": ", new Object[0]);
            password = new String(pwd);
        } else if (password.equals(password.toUpperCase(Locale.ROOT)) && (tmp = System.getenv(password)) != null) {
            password = tmp;
        }
        String scheme = uri.getScheme();
        if ("imaps".equalsIgnoreCase(scheme)) {
            System.out.println("Using secure protocol");
            imap = new IMAPSClient(true);
        } else {
            if (!"imap".equalsIgnoreCase(scheme)) throw new IllegalArgumentException("Invalid protocol: " + scheme);
            imap = new IMAPClient();
        }
        int port = uri.getPort();
        if (port != -1) {
            imap.setDefaultPort(port);
        }
        imap.setDefaultTimeout(defaultTimeout);
        if (listener != null) {
            imap.addProtocolCommandListener(listener);
        }
        String server = uri.getHost();
        System.out.println("Connecting to server " + server + " on " + imap.getDefaultPort());
        try {
            imap.connect(server);
            System.out.println("Successfully connected");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not connect to server.", e);
        }
        if (imap.login(username, password)) return imap;
        imap.disconnect();
        throw new RuntimeException("Could not login to server. Check login details.");
    }
}

