/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.unix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.commons.net.echo.EchoTCPClient;
import org.apache.commons.net.echo.EchoUDPClient;

public final class echo {
    public static void echoTCP(String host) throws IOException {
        String line;
        EchoTCPClient client = new EchoTCPClient();
        client.setDefaultTimeout(60000);
        client.connect(host);
        System.out.println("Connected to " + host + ".");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter echoOutput = new PrintWriter((Writer)new OutputStreamWriter(client.getOutputStream()), true);
        BufferedReader echoInput = new BufferedReader(new InputStreamReader(client.getInputStream()));
        while ((line = input.readLine()) != null) {
            echoOutput.println(line);
            System.out.println(echoInput.readLine());
        }
        echoOutput.close();
        echoInput.close();
        echoInput.close();
        client.disconnect();
    }

    public static void echoUDP(String host) throws IOException {
        String line;
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        InetAddress address = InetAddress.getByName(host);
        EchoUDPClient client = new EchoUDPClient();
        client.open();
        client.setSoTimeout(5000);
        System.out.println("Ready to echo to " + host + ".");
        while ((line = input.readLine()) != null) {
            int length;
            byte[] data = line.getBytes();
            client.send(data, address);
            int count = 0;
            do {
                try {
                    length = client.receive(data);
                }
                catch (SocketException e) {
                    System.err.println("SocketException: Timed out and dropped packet");
                    break;
                }
                catch (InterruptedIOException e) {
                    System.err.println("InterruptedIOException: Timed out and dropped packet");
                    break;
                }
                System.out.print(new String(data, 0, length));
            } while ((count += length) < data.length);
            System.out.println();
        }
        client.close();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                echo.echoTCP(args[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-udp")) {
            try {
                echo.echoUDP(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.err.println("Usage: echo [-udp] <hostname>");
            System.exit(1);
        }
    }
}

