/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.angle;

public final class PlaneAngle {
    public static final PlaneAngle ZERO = new PlaneAngle(0.0);
    public static final PlaneAngle PI = new PlaneAngle(0.5);
    private static final double HALF_TURN = 0.5;
    private static final double TO_RADIANS = Math.PI * 2;
    private static final double FROM_RADIANS = 0.15915494309189535;
    private static final double TO_DEGREES = 360.0;
    private static final double FROM_DEGREES = 0.002777777777777778;
    private final double value;

    private PlaneAngle(double value) {
        this.value = value;
    }

    public static PlaneAngle ofTurns(double angle) {
        return new PlaneAngle(angle);
    }

    public static PlaneAngle ofRadians(double angle) {
        return new PlaneAngle(angle * 0.15915494309189535);
    }

    public static PlaneAngle ofDegrees(double angle) {
        return new PlaneAngle(angle * 0.002777777777777778);
    }

    public double toTurns() {
        return this.value;
    }

    public double toRadians() {
        return this.value * (Math.PI * 2);
    }

    public double toDegrees() {
        return this.value * 360.0;
    }

    public PlaneAngle normalize(PlaneAngle center) {
        double lowerBound = center.value - 0.5;
        double upperBound = center.value + 0.5;
        double normalized = this.value - Math.floor(this.value - lowerBound);
        return normalized < upperBound ? new PlaneAngle(normalized) : new PlaneAngle(normalized - 1.0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PlaneAngle) {
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((PlaneAngle)other).value);
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }
}

