/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.primes;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.numbers.primes.SmallPrimes;

public final class Primes {
    static final String NUMBER_TOO_SMALL = "{0} is smaller than the minimum ({1})";

    private Primes() {
    }

    public static boolean isPrime(int n) {
        if (n < 2) {
            return false;
        }
        for (int p : SmallPrimes.PRIMES) {
            if (0 != n % p) continue;
            return n == p;
        }
        return SmallPrimes.millerRabinPrimeTest(n);
    }

    public static int nextPrime(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format(NUMBER_TOO_SMALL, n, 0));
        }
        if (n == 2) {
            return 2;
        }
        if ((n |= 1) == 1) {
            return 2;
        }
        if (Primes.isPrime(n)) {
            return n;
        }
        int rem = n % 3;
        if (0 == rem) {
            n += 2;
        } else if (1 == rem) {
            n += 4;
        }
        while (!Primes.isPrime(n)) {
            if (Primes.isPrime(n += 2)) {
                return n;
            }
            n += 4;
        }
        return n;
    }

    public static List<Integer> primeFactors(int n) {
        if (n < 2) {
            throw new IllegalArgumentException(MessageFormat.format(NUMBER_TOO_SMALL, n, 2));
        }
        return SmallPrimes.trialDivision(n);
    }
}

