/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.BinomialCoefficient;

public final class BinomialCoefficientDouble {
    private BinomialCoefficientDouble() {
    }

    public static double value(int n, int k) {
        BinomialCoefficient.checkBinomial(n, k);
        if (n == k || k == 0) {
            return 1.0;
        }
        if (k == 1 || k == n - 1) {
            return n;
        }
        if (k > n / 2) {
            return BinomialCoefficientDouble.value(n, n - k);
        }
        if (n < 67) {
            return BinomialCoefficient.value(n, k);
        }
        double result = 1.0;
        for (int i = 1; i <= k; ++i) {
            result *= (double)(n - k + i);
            result /= (double)i;
        }
        return Math.floor(result + 0.5);
    }
}

