/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;

public final class Factorial {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    private Factorial() {
    }

    public static long value(int n) {
        if (n < 0 || n > 20) {
            throw new CombinatoricsException("Number {0} is out of range [{1}, {2}]", n, 0, 20);
        }
        return FACTORIALS[n];
    }
}

