/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.combinatorics.Factorial;

public final class FactorialDouble {
    private static final int FACTORIALS_LONG_CACHE_SIZE = 21;
    private final double[] factorialsDouble;

    private FactorialDouble(int numValues, double[] cache) {
        int i;
        if (numValues < 0) {
            throw new CombinatoricsException("Number {0} is negative", numValues);
        }
        this.factorialsDouble = new double[numValues];
        int max = numValues < 2 ? numValues : 2;
        for (int i2 = 0; i2 < max; ++i2) {
            this.factorialsDouble[i2] = 1.0;
        }
        int beginCopy = 2;
        int endCopy = cache == null || cache.length <= 2 ? 2 : (cache.length <= numValues ? cache.length : numValues);
        for (i = 2; i < endCopy; ++i) {
            this.factorialsDouble[i] = cache[i];
        }
        for (i = endCopy; i < numValues; ++i) {
            this.factorialsDouble[i] = (double)i * this.factorialsDouble[i - 1];
        }
    }

    public static FactorialDouble create() {
        return new FactorialDouble(0, null);
    }

    public FactorialDouble withCache(int cacheSize) {
        return new FactorialDouble(cacheSize, this.factorialsDouble);
    }

    public double value(int n) {
        if (n < 21) {
            return Factorial.value(n);
        }
        if (n < this.factorialsDouble.length) {
            return this.factorialsDouble[n];
        }
        return this.compute(n);
    }

    private double compute(int n) {
        int start = 2;
        double result = 1.0;
        if (this.factorialsDouble.length > 2) {
            result = this.factorialsDouble[this.factorialsDouble.length - 1];
            start = this.factorialsDouble.length;
        }
        for (int i = start; i <= n; ++i) {
            result *= (double)i;
        }
        return result;
    }
}

