/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.examples.jmh.complex;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.commons.numbers.complex.Complex;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class ComplexPerformance {
    private static final double[] EDGE_NUMBERS = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, -1.7976931348623157E308, Double.MIN_VALUE, -4.9E-324, 0.0, -0.0, Double.NaN};
    private static final double RANGE = 3.456789;

    private static double createLogUniformNumber(UniformRandomProvider rng) {
        long mask = -9218868437227405313L;
        long bits = rng.nextLong() & 0x800FFFFFFFFFFFFFL;
        long exp = rng.nextInt(129) - 64 + 1023;
        return Double.longBitsToDouble(bits | exp << 52);
    }

    private static double createUniformNumber(UniformRandomProvider rng) {
        return (rng.nextDouble() - (double)rng.nextInt(1)) * 3.456789;
    }

    private static double createEdgeNumber(UniformRandomProvider rng) {
        return EDGE_NUMBERS[rng.nextInt(EDGE_NUMBERS.length)];
    }

    private static boolean[] apply(Complex[] numbers, Predicate<Complex> fun) {
        boolean[] result = new boolean[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = fun.test(numbers[i]);
        }
        return result;
    }

    private static double[] apply(Complex[] numbers, ToDoubleFunction<Complex> fun) {
        double[] result = new double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = fun.applyAsDouble(numbers[i]);
        }
        return result;
    }

    private static Complex[] apply(Complex[] numbers, UnaryOperator<Complex> fun) {
        Complex[] result = new Complex[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = (Complex)fun.apply(numbers[i]);
        }
        return result;
    }

    private static Complex[] apply(Complex[] numbers, Complex[] numbers2, BiFunction<Complex, Complex, Complex> fun) {
        Complex[] result = new Complex[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = fun.apply(numbers[i], numbers2[i]);
        }
        return result;
    }

    private static Complex[] apply(Complex[] numbers, double[] numbers2, ComplexRealFunction fun) {
        Complex[] result = new Complex[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = fun.apply(numbers[i], numbers2[i]);
        }
        return result;
    }

    private static Complex identity(Complex z) {
        return z;
    }

    private static Complex copy(Complex z) {
        return Complex.ofCartesian((double)z.real(), (double)z.imag());
    }

    public double[] real2(ComplexNumbers numbers) {
        Complex[] z = numbers.getNumbers();
        double[] result = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            result[i] = z[i].real();
        }
        return result;
    }

    public Complex[] conj2(ComplexNumbers numbers) {
        Complex[] z = numbers.getNumbers();
        Complex[] result = new Complex[z.length];
        for (int i = 0; i < z.length; ++i) {
            result[i] = z[i].conj();
        }
        return result;
    }

    @Benchmark
    public Complex[] baselineNewArray(ComplexNumberSize numberSize) {
        return new Complex[numberSize.getSize()];
    }

    public Complex[] baselineCopyArray(ComplexNumbers numbers) {
        return Arrays.copyOf(numbers.getNumbers(), numbers.getNumbers().length);
    }

    @Benchmark
    public Complex[] baselineIdentity(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), ComplexPerformance::identity);
    }

    @Benchmark
    public Complex[] baselineCopy(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), ComplexPerformance::copy);
    }

    @Benchmark
    public boolean[] isNaN(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::isNaN);
    }

    @Benchmark
    public boolean[] isInfinite(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::isInfinite);
    }

    @Benchmark
    public boolean[] isFinite(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::isFinite);
    }

    @Benchmark
    public double[] real(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::real);
    }

    @Benchmark
    public double[] imag(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::imag);
    }

    @Benchmark
    public double[] abs(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::abs);
    }

    @Benchmark
    public double[] arg(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::arg);
    }

    @Benchmark
    public double[] norm(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::norm);
    }

    @Benchmark
    public double[] sqrtNorm(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), (Complex z) -> Math.sqrt(z.norm()));
    }

    @Benchmark
    public double[] absMathHypot(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), (Complex z) -> Math.hypot(z.real(), z.imag()));
    }

    @Benchmark
    public Complex[] conj(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::conj);
    }

    @Benchmark
    public Complex[] negate(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::negate);
    }

    @Benchmark
    public Complex[] proj(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::proj);
    }

    @Benchmark
    public Complex[] cos(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::cos);
    }

    @Benchmark
    public Complex[] cosh(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::cosh);
    }

    @Benchmark
    public Complex[] exp(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::exp);
    }

    @Benchmark
    public Complex[] log(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::log);
    }

    @Benchmark
    public Complex[] log10(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::log10);
    }

    @Benchmark
    public Complex[] sin(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::sin);
    }

    @Benchmark
    public Complex[] sinh(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::sinh);
    }

    @Benchmark
    public Complex[] sqrt(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::sqrt);
    }

    @Benchmark
    public Complex[] tan(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::tan);
    }

    @Benchmark
    public Complex[] tanh(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::tanh);
    }

    @Benchmark
    public Complex[] acos(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::acos);
    }

    @Benchmark
    public Complex[] acosh(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::acosh);
    }

    @Benchmark
    public Complex[] asin(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::asin);
    }

    @Benchmark
    public Complex[] asinh(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::asinh);
    }

    @Benchmark
    public Complex[] atan(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::atan);
    }

    @Benchmark
    public Complex[] atanh(ComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), Complex::atanh);
    }

    @Benchmark
    public Complex[] pow(TwoComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::pow);
    }

    @Benchmark
    public Complex[] multiply(TwoComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::multiply);
    }

    @Benchmark
    public Complex[] divide(TwoComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::divide);
    }

    @Benchmark
    public Complex[] add(TwoComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::add);
    }

    @Benchmark
    public Complex[] subtract(TwoComplexNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::subtract);
    }

    @Benchmark
    public Complex[] powReal(ComplexAndRealNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::pow);
    }

    @Benchmark
    public Complex[] multiplyReal(ComplexAndRealNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::multiply);
    }

    @Benchmark
    public Complex[] divideReal(ComplexAndRealNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::divide);
    }

    @Benchmark
    public Complex[] addReal(ComplexAndRealNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::add);
    }

    @Benchmark
    public Complex[] subtractReal(ComplexAndRealNumbers numbers) {
        return ComplexPerformance.apply(numbers.getNumbers(), numbers.getNumbers2(), Complex::subtract);
    }

    private static interface ComplexRealFunction {
        public Complex apply(Complex var1, double var2);
    }

    @State(value=Scope.Benchmark)
    public static class ComplexAndRealNumbers
    extends ComplexNumbers {
        private double[] numbers2;

        public double[] getNumbers2() {
            return this.numbers2;
        }

        @Override
        @Setup
        public void setup() {
            RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP);
            this.numbers = this.createNumbers((UniformRandomProvider)rng);
            this.numbers2 = Arrays.stream(this.createNumbers((UniformRandomProvider)rng)).mapToDouble(Complex::real).toArray();
        }
    }

    @State(value=Scope.Benchmark)
    public static class TwoComplexNumbers
    extends ComplexNumbers {
        private Complex[] numbers2;

        public Complex[] getNumbers2() {
            return this.numbers2;
        }

        @Override
        @Setup
        public void setup() {
            RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP);
            this.numbers = this.createNumbers((UniformRandomProvider)rng);
            this.numbers2 = this.createNumbers((UniformRandomProvider)rng);
        }
    }

    @State(value=Scope.Benchmark)
    public static class ComplexNumbers
    extends ComplexNumberSize {
        protected Complex[] numbers;
        @Param(value={"cis", "vector", "log-uniform", "uniform", "edge"})
        private String type;

        public Complex[] getNumbers() {
            return this.numbers;
        }

        @Setup
        public void setup() {
            this.numbers = this.createNumbers((UniformRandomProvider)RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP));
        }

        Complex[] createNumbers(UniformRandomProvider rng) {
            Supplier<Complex> generator;
            if ("cis".equals(this.type)) {
                generator = () -> Complex.ofCis((double)(rng.nextDouble() * 2.0 * Math.PI));
            } else if ("vector".equals(this.type)) {
                ZigguratNormalizedGaussianSampler s = (ZigguratNormalizedGaussianSampler)ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng);
                generator = () -> Complex.ofCartesian((double)s.sample(), (double)s.sample());
            } else if ("log-uniform".equals(this.type)) {
                generator = () -> Complex.ofCartesian((double)ComplexPerformance.createLogUniformNumber(rng), (double)ComplexPerformance.createLogUniformNumber(rng));
            } else if ("uniform".equals(this.type)) {
                generator = () -> Complex.ofCartesian((double)ComplexPerformance.createUniformNumber(rng), (double)ComplexPerformance.createUniformNumber(rng));
            } else if ("edge".equals(this.type)) {
                generator = () -> Complex.ofCartesian((double)ComplexPerformance.createEdgeNumber(rng), (double)ComplexPerformance.createEdgeNumber(rng));
            } else {
                throw new IllegalStateException("Unknown number type: " + this.type);
            }
            return (Complex[])Stream.generate(generator).limit(this.getSize()).toArray(Complex[]::new);
        }
    }

    @State(value=Scope.Benchmark)
    public static class ComplexNumberSize {
        @Param(value={"10000"})
        private int size;

        public int getSize() {
            return this.size;
        }
    }
}

