/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.examples.jmh.complex;

import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.numbers.core.Precision;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class SinCosPerformance {
    private static final double[] EDGE_NUMBERS = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, -0.0, Double.NaN};

    private static double createRandomNumber(SplittableRandom rng) {
        long mask = -9218868437227405313L;
        long bits = rng.nextLong() & 0x800FFFFFFFFFFFFFL;
        long exp = rng.nextInt(129) - 64 + 1023;
        return Double.longBitsToDouble(bits | exp << 52);
    }

    private static double createEdgeNumber(SplittableRandom rng) {
        return EDGE_NUMBERS[rng.nextInt(EDGE_NUMBERS.length)];
    }

    private static double[] apply(double[] numbers, DoubleUnaryOperator fun) {
        double[] result = new double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = fun.applyAsDouble(numbers[i]);
        }
        return result;
    }

    private static double identity(double z) {
        return z;
    }

    public double[] mathSin2(Numbers numbers) {
        double[] x = numbers.getNumbers();
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = Math.sin(x[i]);
        }
        return result;
    }

    @Benchmark
    public double[] baselineIdentity(Numbers numbers) {
        return SinCosPerformance.apply(numbers.getNumbers(), SinCosPerformance::identity);
    }

    @Benchmark
    public double[] mathSin(Numbers numbers) {
        return SinCosPerformance.apply(numbers.getNumbers(), Math::sin);
    }

    @Benchmark
    public double[] mathCos(Numbers numbers) {
        return SinCosPerformance.apply(numbers.getNumbers(), Math::cos);
    }

    @Benchmark
    public double[] fastMathSin(Numbers numbers) {
        return SinCosPerformance.apply(numbers.getNumbers(), FastMath::sin);
    }

    @Benchmark
    public double[] fastMathCos(Numbers numbers) {
        return SinCosPerformance.apply(numbers.getNumbers(), FastMath::cos);
    }

    @State(value=Scope.Benchmark)
    public static class Numbers
    extends NumberSize {
        protected double[] numbers;
        @Param(value={"pi", "pi/2", "random", "edge"})
        private String type;

        public double[] getNumbers() {
            return this.numbers;
        }

        @Setup
        public void setup() {
            for (double x : this.numbers = this.createNumbers(new SplittableRandom())) {
                double sin = Math.sin(x);
                Numbers.assertEquals(sin, FastMath.sin((double)x), 1, () -> "sin " + x);
                double cos = Math.cos(x);
                Numbers.assertEquals(cos, FastMath.cos((double)x), 1, () -> "cos " + x);
            }
        }

        private double[] createNumbers(SplittableRandom rng) {
            DoubleSupplier generator;
            if ("pi".equals(this.type)) {
                generator = () -> rng.nextDouble() * 2.0 * Math.PI - Math.PI;
            } else if ("pi/2".equals(this.type)) {
                generator = () -> rng.nextDouble() * Math.PI - 1.5707963267948966;
            } else if ("random".equals(this.type)) {
                generator = () -> SinCosPerformance.createRandomNumber(rng);
            } else if ("edge".equals(this.type)) {
                generator = () -> SinCosPerformance.createEdgeNumber(rng);
            } else {
                throw new IllegalStateException("Unknown number type: " + this.type);
            }
            return DoubleStream.generate(generator).limit(this.getSize()).toArray();
        }

        private static void assertEquals(double x, double y, int maxUlps, Supplier<String> msg) {
            if (!Precision.equalsIncludingNaN((double)x, (double)y, (int)maxUlps)) {
                throw new AssertionError((Object)(msg.get() + ": " + x + " != " + y));
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class NumberSize {
        @Param(value={"1000"})
        private int size;

        public int getSize() {
            return this.size;
        }
    }
}

