/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.LanczosApproximation;
import org.apache.commons.numbers.gamma.LogGamma1p;

public final class LogGamma {
    private static final double LANCZOS_G = 4.7421875;
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);

    private LogGamma() {
    }

    public static double value(double x) {
        if (Double.isNaN(x) || x <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.5) {
            return LogGamma1p.value(x) - Math.log(x);
        }
        if (x <= 2.5) {
            return LogGamma1p.value(x - 0.5 - 0.5);
        }
        if (x <= 8.0) {
            int n = (int)Math.floor(x - 1.5);
            double prod = 1.0;
            for (int i = 1; i <= n; ++i) {
                prod *= x - (double)i;
            }
            return LogGamma1p.value(x - (double)(n + 1)) + Math.log(prod);
        }
        double sum = LanczosApproximation.value(x);
        double tmp = x + 4.7421875 + 0.5;
        return (x + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log(sum / x);
    }
}

