/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.fraction.ContinuedFraction;
import org.apache.commons.numbers.gamma.LogBeta;

public final class RegularizedBeta {
    private static final double DEFAULT_EPSILON = 1.0E-14;

    private RegularizedBeta() {
    }

    public static double value(double x, double a, double b) {
        return RegularizedBeta.value(x, a, b, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double value(double x, final double a, final double b, double epsilon, int maxIterations) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || x < 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x > (a + 1.0) / (2.0 + b + a) && 1.0 - x <= (b + 1.0) / (2.0 + b + a)) {
            return 1.0 - RegularizedBeta.value(1.0 - x, b, a, epsilon, maxIterations);
        }
        ContinuedFraction fraction = new ContinuedFraction(){

            protected double getB(int n, double x) {
                if (n % 2 == 0) {
                    double m = (double)n / 2.0;
                    return m * (b - m) * x / ((a + 2.0 * m - 1.0) * (a + 2.0 * m));
                }
                double m = ((double)n - 1.0) / 2.0;
                return -((a + m) * (a + b + m) * x) / ((a + 2.0 * m) * (a + 2.0 * m + 1.0));
            }

            protected double getA(int n, double x) {
                return 1.0;
            }
        };
        return Math.exp(a * Math.log(x) + b * Math.log1p(-x) - Math.log(a) - LogBeta.value(a, b)) / fraction.evaluate(x, epsilon, maxIterations);
    }
}

