/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.io.Serializable;
import org.apache.commons.numbers.core.ArithmeticUtils;
import org.apache.commons.numbers.core.NativeOperators;
import org.apache.commons.numbers.fraction.FractionException;

public final class Fraction
extends Number
implements Comparable<Fraction>,
NativeOperators<Fraction>,
Serializable {
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ZERO = new Fraction(0, 1);
    private static final long serialVersionUID = 20190701L;
    private static final double DEFAULT_EPSILON = 1.0E-5;
    private final int denominator;
    private final int numerator;

    private Fraction(double value, double epsilon, int maxDenominator, int maxIterations) {
        long overflow = Integer.MAX_VALUE;
        double r0 = value;
        long a0 = (long)Math.floor(r0);
        if (Math.abs(a0) > Integer.MAX_VALUE) {
            throw new FractionException("Unable to convert {0} to fraction after {1} iterations", value, a0, 1L);
        }
        if (Math.abs((double)a0 - value) < epsilon) {
            this.numerator = (int)a0;
            this.denominator = 1;
            return;
        }
        long p0 = 1L;
        long q0 = 0L;
        long p1 = a0;
        long q1 = 1L;
        long p2 = 0L;
        long q2 = 1L;
        int n = 0;
        boolean stop = false;
        do {
            ++n;
            double r1 = 1.0 / (r0 - (double)a0);
            long a1 = (long)Math.floor(r1);
            p2 = a1 * p1 + p0;
            q2 = a1 * q1 + q0;
            if (Math.abs(p2) > Integer.MAX_VALUE || Math.abs(q2) > Integer.MAX_VALUE) {
                if (epsilon == 0.0 && Math.abs(q1) < (long)maxDenominator) break;
                throw new FractionException("Unable to convert {0} to fraction after {1} iterations", value, p2, q2);
            }
            double convergent = (double)p2 / (double)q2;
            if (n < maxIterations && Math.abs(convergent - value) > epsilon && q2 < (long)maxDenominator) {
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                a0 = a1;
                r0 = r1;
                continue;
            }
            stop = true;
        } while (!stop);
        if (n >= maxIterations) {
            throw new FractionException("Unable to convert {0} to fraction after {1} iterations", value, maxIterations);
        }
        if (q2 < (long)maxDenominator) {
            this.numerator = (int)p2;
            this.denominator = (int)q2;
        } else {
            this.numerator = (int)p1;
            this.denominator = (int)q1;
        }
    }

    private Fraction(int num, int den) {
        if (den == 0) {
            throw new ArithmeticException("division by zero");
        }
        if (num == den) {
            this.numerator = 1;
            this.denominator = 1;
        } else {
            int d;
            if (((num | den) & 1) == 0) {
                num >>= 1;
                den >>= 1;
            }
            if ((d = ArithmeticUtils.gcd((int)num, (int)den)) > 1) {
                num /= d;
                den /= d;
            }
            this.numerator = num;
            this.denominator = den;
        }
    }

    public static Fraction from(double value) {
        return Fraction.from(value, 1.0E-5, 100);
    }

    public static Fraction from(double value, double epsilon, int maxIterations) {
        return new Fraction(value, epsilon, Integer.MAX_VALUE, maxIterations);
    }

    public static Fraction from(double value, int maxDenominator) {
        return new Fraction(value, 0.0, maxDenominator, 100);
    }

    public static Fraction of(int num) {
        return Fraction.of(num, 1);
    }

    public static Fraction of(int num, int den) {
        return new Fraction(num, den);
    }

    public Fraction abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    @Override
    public int compareTo(Fraction other) {
        return Long.compare((long)this.numerator * (long)other.denominator, (long)this.denominator * (long)other.numerator);
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Fraction) {
            Fraction rhs = (Fraction)other;
            if (this.signum() == rhs.signum()) {
                return Math.abs(this.numerator) == Math.abs(rhs.numerator) && Math.abs(this.denominator) == Math.abs(rhs.denominator);
            }
            return false;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return 37 * (629 + this.numerator) + this.denominator;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public int signum() {
        if (this.numerator > 0 && this.denominator > 0 || this.numerator < 0 && this.denominator < 0) {
            return 1;
        }
        if (this.numerator == 0) {
            return 0;
        }
        return -1;
    }

    public Fraction negate() {
        return this.numerator == Integer.MIN_VALUE ? new Fraction(this.numerator, -this.denominator) : new Fraction(-this.numerator, this.denominator);
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    public Fraction add(int i) {
        return new Fraction(this.numerator + i * this.denominator, this.denominator);
    }

    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    public Fraction subtract(int i) {
        return new Fraction(this.numerator - i * this.denominator, this.denominator);
    }

    private Fraction addSub(Fraction fraction, boolean isAdd) {
        if (this.numerator == 0) {
            return isAdd ? fraction : fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int d1 = ArithmeticUtils.gcd((int)this.denominator, (int)fraction.denominator);
        long uvp = (long)this.numerator * (long)(fraction.denominator / d1);
        long upv = (long)fraction.numerator * (long)(this.denominator / d1);
        long t = isAdd ? uvp + upv : uvp - upv;
        long d2 = ArithmeticUtils.gcd((long)t, (long)d1);
        return Fraction.of(Math.toIntExact(t / d2), Math.multiplyExact(this.denominator / d1, fraction.denominator / (int)d2));
    }

    public Fraction multiply(Fraction fraction) {
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int d1 = ArithmeticUtils.gcd((int)this.numerator, (int)fraction.denominator);
        int d2 = ArithmeticUtils.gcd((int)fraction.numerator, (int)this.denominator);
        return Fraction.of(Math.multiplyExact(this.numerator / d1, fraction.numerator / d2), Math.multiplyExact(this.denominator / d2, fraction.denominator / d1));
    }

    public Fraction multiply(int i) {
        return this.multiply(Fraction.of(i));
    }

    public Fraction divide(Fraction fraction) {
        if (fraction.numerator == 0) {
            throw new FractionException("the fraction to divide by must not be zero: {0}/{1}", fraction.numerator, fraction.denominator);
        }
        return this.multiply(fraction.reciprocal());
    }

    public Fraction divide(int i) {
        return this.divide(Fraction.of(i));
    }

    public Fraction pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (this.numerator == 0) {
            return this;
        }
        return n < 0 ? new Fraction(ArithmeticUtils.pow((int)this.denominator, (int)(-n)), ArithmeticUtils.pow((int)this.numerator, (int)(-n))) : new Fraction(ArithmeticUtils.pow((int)this.numerator, (int)n), ArithmeticUtils.pow((int)this.denominator, (int)n));
    }

    public String toString() {
        String str = this.denominator == 1 ? Integer.toString(this.numerator) : (this.numerator == 0 ? "0" : this.numerator + " / " + this.denominator);
        return str;
    }

    public Fraction zero() {
        return ZERO;
    }

    public Fraction one() {
        return ONE;
    }

    public static Fraction parse(String s) {
        int slashLoc = s.indexOf(47);
        if (slashLoc == -1) {
            return Fraction.of(Integer.parseInt(s.trim()));
        }
        int num = Integer.parseInt(s.substring(0, slashLoc).trim());
        int denom = Integer.parseInt(s.substring(slashLoc + 1).trim());
        return Fraction.of(num, denom);
    }
}

