/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.MethodCall;
import org.apache.commons.pool2.MethodCallPoolableObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PrivateException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestObjectPool {
    private final Integer ZERO = new Integer(0);
    private final Integer ONE = new Integer(1);

    protected abstract ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> var1) throws UnsupportedOperationException;

    @Test
    public void testClosedPoolBehavior() throws Exception {
        ObjectPool<Object> pool;
        try {
            pool = this.makeEmptyPool(new MethodCallPoolableObjectFactory());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object o1 = pool.borrowObject();
        Object o2 = pool.borrowObject();
        pool.close();
        try {
            pool.addObject();
            Assert.fail((String)"A closed pool must throw an IllegalStateException when addObject is called.");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            pool.borrowObject();
            Assert.fail((String)"A closed pool must throw an IllegalStateException when borrowObject is called.");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        if (pool.getNumIdle() >= 0) {
            Assert.assertEquals((String)"A closed pool shouldn't have any idle objects.", (long)0L, (long)pool.getNumIdle());
        }
        if (pool.getNumActive() >= 0) {
            Assert.assertEquals((String)"A closed pool should still keep count of active objects.", (long)2L, (long)pool.getNumActive());
        }
        pool.returnObject(o1);
        if (pool.getNumIdle() >= 0) {
            Assert.assertEquals((String)"returnObject should not add items back into the idle object pool for a closed pool.", (long)0L, (long)pool.getNumIdle());
        }
        if (pool.getNumActive() >= 0) {
            Assert.assertEquals((String)"A closed pool should still keep count of active objects.", (long)1L, (long)pool.getNumActive());
        }
        pool.invalidateObject(o2);
        if (pool.getNumIdle() >= 0) {
            Assert.assertEquals((String)"invalidateObject must not add items back into the idle object pool.", (long)0L, (long)pool.getNumIdle());
        }
        if (pool.getNumActive() >= 0) {
            Assert.assertEquals((String)"A closed pool should still keep count of active objects.", (long)0L, (long)pool.getNumActive());
        }
        pool.clear();
        pool.close();
    }

    @Test
    public void testPOFAddObjectUsage() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        pool.addObject();
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        Assert.assertEquals((long)1L, (long)pool.getNumIdle());
        expectedMethods.add(new MethodCall("makeObject").returned(this.ZERO));
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", this.ZERO).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", this.ZERO));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        TestObjectPool.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        try {
            pool.addObject();
            Assert.fail((String)"Expected addObject to propagate makeObject exception.");
        }
        catch (PrivateException pe) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject"));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        TestObjectPool.clear(factory, expectedMethods);
        factory.setMakeObjectFail(false);
        factory.setPassivateObjectFail(true);
        try {
            pool.addObject();
            Assert.fail((String)"Expected addObject to propagate passivateObject exception.");
        }
        catch (PrivateException pe) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject").returned(this.ONE));
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", this.ONE).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", this.ONE));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testPOFBorrowObjectUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        if (pool instanceof GenericObjectPool) {
            ((GenericObjectPool)pool).setTestOnBorrow(true);
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObject();
        TestObjectPool.clear(factory, expectedMethods);
        Object obj = pool.borrowObject();
        expectedMethods.add(new MethodCall("activateObject", this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", this.ZERO).returned(Boolean.TRUE));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.returnObject(obj);
        TestObjectPool.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        try {
            obj = pool.borrowObject();
            Assert.fail((String)"Expected borrowObject to propagate makeObject exception.");
        }
        catch (PrivateException pe) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject"));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        TestObjectPool.reset(pool, factory, expectedMethods);
        pool.addObject();
        TestObjectPool.clear(factory, expectedMethods);
        factory.setActivateObjectFail(true);
        expectedMethods.add(new MethodCall("activateObject", obj));
        try {
            pool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject").returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", this.ONE));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        TestObjectPool.reset(pool, factory, expectedMethods);
        pool.addObject();
        TestObjectPool.clear(factory, expectedMethods);
        factory.setValidateObjectFail(true);
        expectedMethods.add(new MethodCall("activateObject", this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", this.ZERO));
        try {
            pool.borrowObject();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject").returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", this.ONE));
        expectedMethods.add(new MethodCall("validateObject", this.ONE));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertTrue((boolean)factory.getMethodCalls().containsAll(expectedMethods));
        pool.close();
    }

    @Test
    public void testPOFReturnObjectUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject();
        TestObjectPool.clear(factory, expectedMethods);
        pool.returnObject(obj);
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", obj).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", obj));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        TestObjectPool.reset(pool, factory, expectedMethods);
        pool.addObject();
        pool.addObject();
        pool.addObject();
        Assert.assertEquals((long)3L, (long)pool.getNumIdle());
        obj = pool.borrowObject();
        pool.borrowObject();
        Assert.assertEquals((long)1L, (long)pool.getNumIdle());
        Assert.assertEquals((long)2L, (long)pool.getNumActive());
        TestObjectPool.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        pool.returnObject(obj);
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", obj).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", obj));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        Assert.assertEquals((long)1L, (long)pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)pool.getNumActive());
        TestObjectPool.reset(pool, factory, expectedMethods);
        obj = pool.borrowObject();
        TestObjectPool.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        factory.setDestroyObjectFail(true);
        pool.returnObject(obj);
        pool.close();
    }

    @Test
    public void testPOFInvalidateObjectUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject();
        TestObjectPool.clear(factory, expectedMethods);
        pool.invalidateObject(obj);
        expectedMethods.add(new MethodCall("destroyObject", obj));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        TestObjectPool.reset(pool, factory, expectedMethods);
        obj = pool.borrowObject();
        TestObjectPool.clear(factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        try {
            pool.invalidateObject(obj);
            Assert.fail((String)"Expecting destroy exception to propagate");
        }
        catch (PrivateException ex) {
            // empty catch block
        }
        Thread.sleep(250L);
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testPOFClearUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        PoolUtils.prefill(pool, (int)5);
        pool.clear();
        TestObjectPool.reset(pool, factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        PoolUtils.prefill(pool, (int)5);
        pool.clear();
        pool.close();
    }

    @Test
    public void testPOFCloseUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        PoolUtils.prefill(pool, (int)5);
        pool.close();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        TestObjectPool.reset(pool, factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        PoolUtils.prefill(pool, (int)5);
        pool.close();
    }

    @Test
    public void testToString() throws Exception {
        ObjectPool<Object> pool;
        try {
            pool = this.makeEmptyPool(new MethodCallPoolableObjectFactory());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        pool.toString();
        pool.close();
    }

    static void removeDestroyObjectCall(List<MethodCall> calls) {
        Iterator<MethodCall> iter = calls.iterator();
        while (iter.hasNext()) {
            MethodCall call = iter.next();
            if (!"destroyObject".equals(call.getName())) continue;
            iter.remove();
        }
    }

    private static void reset(ObjectPool<Object> pool, MethodCallPoolableObjectFactory factory, List<MethodCall> expectedMethods) throws Exception {
        pool.clear();
        TestObjectPool.clear(factory, expectedMethods);
        factory.reset();
    }

    private static void clear(MethodCallPoolableObjectFactory factory, List<MethodCall> expectedMethods) {
        factory.getMethodCalls().clear();
        expectedMethods.clear();
    }
}

