/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import junit.framework.AssertionFailedError;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestPoolUtils {
    private static final int CHECK_PERIOD = 300;
    private static final int CHECK_COUNT = 4;
    private static final int CHECK_SLEEP_PERIOD = 1050;

    @Test
    public void testJavaBeanInstantiation() {
        Assert.assertNotNull((Object)new PoolUtils());
    }

    @Test
    public void testCheckMinIdleObjectPool() throws Exception {
        try {
            PoolUtils.checkMinIdle(null, (int)1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(ObjectPool,,) must not allow null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, (List<String>)null);
            PoolUtils.checkMinIdle((ObjectPool)pool, (int)-1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(ObjectPool,,) must not accept negative min idle values.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        PooledObjectFactory pof = TestPoolUtils.createProxy(PooledObjectFactory.class, calledMethods);
        GenericObjectPool op = new GenericObjectPool(pof);
        PoolUtils.checkMinIdle((ObjectPool)op, (int)2, (long)100L);
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)op.getNumIdle());
        op.close();
        int makeObjectCount = 0;
        for (String methodName : calledMethods) {
            if (!"makeObject".equals(methodName)) continue;
            ++makeObjectCount;
        }
        Assert.assertEquals((String)"makeObject should have been called two time", (long)2L, (long)makeObjectCount);
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                calledMethods.clear();
                ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);
                TimerTask task = PoolUtils.checkMinIdle((ObjectPool)pool, (int)1, (long)300L);
                Thread.sleep(1050L);
                task.cancel();
                task.toString();
                ArrayList<String> expectedMethods = new ArrayList<String>();
                for (int i = 0; i < 4; ++i) {
                    expectedMethods.add("getNumIdle");
                    expectedMethods.add("addObject");
                }
                expectedMethods.add("toString");
                Assert.assertEquals(expectedMethods, calledMethods);
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    public void testCheckMinIdleKeyedObjectPool() throws Exception {
        KeyedObjectPool pool;
        try {
            PoolUtils.checkMinIdle(null, (Object)new Object(), (int)1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not allow null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            PoolUtils.checkMinIdle((KeyedObjectPool)pool, (Object)null, (int)1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not accept null keys.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            PoolUtils.checkMinIdle((KeyedObjectPool)pool, (Object)new Object(), (int)-1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not accept negative min idle values.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        Object key = new Object();
        KeyedPooledObjectFactory kpof = TestPoolUtils.createProxy(KeyedPooledObjectFactory.class, calledMethods);
        GenericKeyedObjectPool kop = new GenericKeyedObjectPool(kpof);
        PoolUtils.checkMinIdle((KeyedObjectPool)kop, (Object)key, (int)2, (long)100L);
        Thread.sleep(400L);
        Assert.assertEquals((long)2L, (long)kop.getNumIdle(key));
        Assert.assertEquals((long)2L, (long)kop.getNumIdle());
        kop.close();
        int makeObjectCount = 0;
        for (String methodName : calledMethods) {
            if (!"makeObject".equals(methodName)) continue;
            ++makeObjectCount;
        }
        Assert.assertEquals((String)"makeObject should have been called two time", (long)2L, (long)makeObjectCount);
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                calledMethods.clear();
                KeyedObjectPool pool2 = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
                TimerTask task = PoolUtils.checkMinIdle((KeyedObjectPool)pool2, (Object)key, (int)1, (long)300L);
                Thread.sleep(1050L);
                task.cancel();
                task.toString();
                ArrayList<String> expectedMethods = new ArrayList<String>();
                for (int i = 0; i < 4; ++i) {
                    expectedMethods.add("getNumIdle");
                    expectedMethods.add("addObject");
                }
                expectedMethods.add("toString");
                Assert.assertEquals(expectedMethods, calledMethods);
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    public void testCheckMinIdleKeyedObjectPoolKeys() throws Exception {
        try {
            KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            PoolUtils.checkMinIdle((KeyedObjectPool)pool, (Object)null, (int)1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Collection,int,long) must not accept null keys.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                ArrayList<String> calledMethods = new ArrayList<String>();
                KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
                ArrayList<String> keys = new ArrayList<String>(2);
                keys.add("one");
                keys.add("two");
                Map tasks = PoolUtils.checkMinIdle((KeyedObjectPool)pool, keys, (int)1, (long)300L);
                Thread.sleep(1050L);
                for (TimerTask task : tasks.values()) {
                    task.cancel();
                }
                ArrayList<String> expectedMethods = new ArrayList<String>();
                for (int i = 0; i < 4 * keys.size(); ++i) {
                    expectedMethods.add("getNumIdle");
                    expectedMethods.add("addObject");
                }
                Assert.assertEquals(expectedMethods, calledMethods);
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    public void testPrefillObjectPool() throws Exception {
        try {
            PoolUtils.prefill(null, (int)1);
            Assert.fail((String)"PoolUtils.prefill(ObjectPool,int) must not allow null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);
        PoolUtils.prefill((ObjectPool)pool, (int)0);
        ArrayList<String> expectedMethods = new ArrayList<String>();
        Assert.assertEquals(expectedMethods, calledMethods);
        calledMethods.clear();
        PoolUtils.prefill((ObjectPool)pool, (int)3);
        for (int i = 0; i < 3; ++i) {
            expectedMethods.add("addObject");
        }
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testPrefillKeyedObjectPool() throws Exception {
        try {
            PoolUtils.prefill(null, (Object)new Object(), (int)1);
            Assert.fail((String)"PoolUtils.prefill(KeyedObjectPool,Object,int) must not accept null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            PoolUtils.prefill((KeyedObjectPool)pool, (Object)null, (int)1);
            Assert.fail((String)"PoolUtils.prefill(KeyedObjectPool,Object,int) must not accept null key.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
        PoolUtils.prefill((KeyedObjectPool)pool, (Object)new Object(), (int)0);
        ArrayList<String> expectedMethods = new ArrayList<String>();
        Assert.assertEquals(expectedMethods, calledMethods);
        calledMethods.clear();
        PoolUtils.prefill((KeyedObjectPool)pool, (Object)new Object(), (int)3);
        for (int i = 0; i < 3; ++i) {
            expectedMethods.add("addObject");
        }
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testPrefillKeyedObjectPoolCollection() throws Exception {
        try {
            KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            PoolUtils.prefill((KeyedObjectPool)pool, (Collection)null, (int)1);
            Assert.fail((String)"PoolUtils.prefill(KeyedObjectPool,Collection,int) must not accept null keys.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
        HashSet<String> keys = new HashSet<String>();
        PoolUtils.prefill((KeyedObjectPool)pool, keys, (int)0);
        ArrayList<String> expectedMethods = new ArrayList<String>();
        Assert.assertEquals(expectedMethods, calledMethods);
        calledMethods.clear();
        keys.add("one");
        keys.add("two");
        keys.add("three");
        PoolUtils.prefill((KeyedObjectPool)pool, keys, (int)3);
        for (int i = 0; i < keys.size() * 3; ++i) {
            expectedMethods.add("addObject");
        }
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testSynchronizedPoolObjectPool() throws Exception {
        try {
            PoolUtils.synchronizedPool((ObjectPool)null);
            Assert.fail((String)"PoolUtils.synchronizedPool(ObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        ObjectPool op = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);
        ObjectPool sop = PoolUtils.synchronizedPool((ObjectPool)op);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod((ObjectPool<Object>)sop);
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testSynchronizedPoolKeyedObjectPool() throws Exception {
        try {
            PoolUtils.synchronizedPool((KeyedObjectPool)null);
            Assert.fail((String)"PoolUtils.synchronizedPool(KeyedObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        KeyedObjectPool kop = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
        KeyedObjectPool skop = PoolUtils.synchronizedPool((KeyedObjectPool)kop);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod((KeyedObjectPool<Object, Object>)skop);
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testSynchronizedPoolableFactoryPoolableObjectFactory() throws Exception {
        try {
            PoolUtils.synchronizedPooledFactory((PooledObjectFactory)null);
            Assert.fail((String)"PoolUtils.synchronizedPoolableFactory(PoolableObjectFactory) must not allow a null factory.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        PooledObjectFactory pof = TestPoolUtils.createProxy(PooledObjectFactory.class, calledMethods);
        PooledObjectFactory spof = PoolUtils.synchronizedPooledFactory((PooledObjectFactory)pof);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod(spof);
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testSynchronizedPoolableFactoryKeyedPoolableObjectFactory() throws Exception {
        try {
            PoolUtils.synchronizedKeyedPooledFactory((KeyedPooledObjectFactory)null);
            Assert.fail((String)"PoolUtils.synchronizedPoolableFactory(KeyedPoolableObjectFactory) must not allow a null factory.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        KeyedPooledObjectFactory kpof = TestPoolUtils.createProxy(KeyedPooledObjectFactory.class, calledMethods);
        KeyedPooledObjectFactory skpof = PoolUtils.synchronizedKeyedPooledFactory((KeyedPooledObjectFactory)kpof);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod(skpof);
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testErodingPoolObjectPool() throws Exception {
        try {
            PoolUtils.erodingPool((ObjectPool)null);
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((ObjectPool)null, (float)1.0f);
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((ObjectPool)null, (float)0.0f);
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        float factor = 0.01f;
        ObjectPool pool = PoolUtils.erodingPool((ObjectPool)TestPoolUtils.createProxy(ObjectPool.class, handler), (float)factor);
        ArrayList<String> expectedMethods = new ArrayList<String>();
        Assert.assertEquals(expectedMethods, calledMethods);
        Object o = pool.borrowObject();
        expectedMethods.add("borrowObject");
        Assert.assertEquals(expectedMethods, calledMethods);
        pool.returnObject(o);
        expectedMethods.add("returnObject");
        Assert.assertEquals(expectedMethods, calledMethods);
        for (int i = 0; i < 5; ++i) {
            o = pool.borrowObject();
            expectedMethods.add("borrowObject");
            Thread.sleep(50L);
            pool.returnObject(o);
            expectedMethods.add("returnObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            expectedMethods.clear();
            calledMethods.clear();
        }
        Thread.sleep(10000L);
        o = pool.borrowObject();
        expectedMethods.add("borrowObject");
        pool.returnObject(o);
        expectedMethods.add("getNumIdle");
        expectedMethods.add("invalidateObject");
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testErodingPoolKeyedObjectPool() throws Exception {
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null);
            Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f);
            Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool, float) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)0.0f);
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true);
            Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool, float, boolean) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)0.0f, (boolean)false);
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float, boolean) must not allow a non-positive factor.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        float factor = 0.01f;
        KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)factor);
        ArrayList<String> expectedMethods = new ArrayList<String>();
        Assert.assertEquals(expectedMethods, calledMethods);
        String key = "key";
        Object o = pool.borrowObject((Object)key);
        expectedMethods.add("borrowObject");
        Assert.assertEquals(expectedMethods, calledMethods);
        pool.returnObject((Object)key, o);
        expectedMethods.add("returnObject");
        Assert.assertEquals(expectedMethods, calledMethods);
        for (int i = 0; i < 5; ++i) {
            o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            Thread.sleep(50L);
            pool.returnObject((Object)key, o);
            expectedMethods.add("returnObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            expectedMethods.clear();
            calledMethods.clear();
        }
        Thread.sleep(10000L);
        o = pool.borrowObject((Object)key);
        expectedMethods.add("borrowObject");
        pool.returnObject((Object)key, o);
        expectedMethods.add("getNumIdle");
        expectedMethods.add("invalidateObject");
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testErodingPerKeyKeyedObjectPool() throws Exception {
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true);
            Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)0.0f, (boolean)true);
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true);
            Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool, float, boolean) must not allow a null pool.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        float factor = 0.01f;
        KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)factor, (boolean)true);
        ArrayList<String> expectedMethods = new ArrayList<String>();
        Assert.assertEquals(expectedMethods, calledMethods);
        String key = "key";
        Object o = pool.borrowObject((Object)key);
        expectedMethods.add("borrowObject");
        Assert.assertEquals(expectedMethods, calledMethods);
        pool.returnObject((Object)key, o);
        expectedMethods.add("returnObject");
        Assert.assertEquals(expectedMethods, calledMethods);
        for (int i = 0; i < 5; ++i) {
            o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            Thread.sleep(50L);
            pool.returnObject((Object)key, o);
            expectedMethods.add("returnObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            expectedMethods.clear();
            calledMethods.clear();
        }
        Thread.sleep(10000L);
        o = pool.borrowObject((Object)key);
        expectedMethods.add("borrowObject");
        pool.returnObject((Object)key, o);
        expectedMethods.add("getNumIdle");
        expectedMethods.add("invalidateObject");
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    private static List<String> invokeEveryMethod(ObjectPool<Object> op) throws Exception {
        op.addObject();
        op.borrowObject();
        op.clear();
        op.close();
        op.getNumActive();
        op.getNumIdle();
        op.invalidateObject(new Object());
        op.returnObject(new Object());
        op.toString();
        List<String> expectedMethods = Arrays.asList("addObject", "borrowObject", "clear", "close", "getNumActive", "getNumIdle", "invalidateObject", "returnObject", "toString");
        return expectedMethods;
    }

    private static List<String> invokeEveryMethod(KeyedObjectPool<Object, Object> kop) throws Exception {
        kop.addObject(null);
        kop.borrowObject(null);
        kop.clear();
        kop.clear(null);
        kop.close();
        kop.getNumActive();
        kop.getNumActive(null);
        kop.getNumIdle();
        kop.getNumIdle(null);
        kop.invalidateObject(null, new Object());
        kop.returnObject(null, new Object());
        kop.toString();
        List<String> expectedMethods = Arrays.asList("addObject", "borrowObject", "clear", "clear", "close", "getNumActive", "getNumActive", "getNumIdle", "getNumIdle", "invalidateObject", "returnObject", "toString");
        return expectedMethods;
    }

    private static <T> List<String> invokeEveryMethod(PooledObjectFactory<T> pof) throws Exception {
        pof.activateObject(null);
        pof.destroyObject(null);
        pof.makeObject();
        pof.passivateObject(null);
        pof.validateObject(null);
        pof.toString();
        List<String> expectedMethods = Arrays.asList("activateObject", "destroyObject", "makeObject", "passivateObject", "validateObject", "toString");
        return expectedMethods;
    }

    private static <K, V> List<String> invokeEveryMethod(KeyedPooledObjectFactory<K, V> kpof) throws Exception {
        kpof.activateObject(null, null);
        kpof.destroyObject(null, null);
        kpof.makeObject(null);
        kpof.passivateObject(null, null);
        kpof.validateObject(null, null);
        kpof.toString();
        List<String> expectedMethods = Arrays.asList("activateObject", "destroyObject", "makeObject", "passivateObject", "validateObject", "toString");
        return expectedMethods;
    }

    private static <T> T createProxy(Class<T> clazz, List<String> logger) {
        return TestPoolUtils.createProxy(clazz, new MethodCallLogger(logger));
    }

    private static <T> T createProxy(Class<T> clazz, InvocationHandler handler) {
        Object ret = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
        return (T)ret;
    }

    private static class MethodCallLogger
    implements InvocationHandler {
        private final List<String> calledMethods;

        MethodCallLogger(List<String> calledMethods) {
            this.calledMethods = calledMethods;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.calledMethods.add(method.getName());
            if (Boolean.TYPE.equals(method.getReturnType())) {
                return Boolean.FALSE;
            }
            if (Integer.TYPE.equals(method.getReturnType())) {
                return 0;
            }
            if (Long.TYPE.equals(method.getReturnType())) {
                return 0L;
            }
            if (Object.class.equals(method.getReturnType())) {
                return new Object();
            }
            if (PooledObject.class.equals(method.getReturnType())) {
                return new DefaultPooledObject(new Object());
            }
            return null;
        }
    }
}

