/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.Set;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.TestGenericObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultPooledObjectInfo {
    @Test
    public void testTiming() throws Exception {
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());
        long t1 = System.currentTimeMillis();
        Thread.sleep(50L);
        String s1 = (String)pool.borrowObject();
        Thread.sleep(50L);
        long t2 = System.currentTimeMillis();
        Thread.sleep(50L);
        pool.returnObject((Object)s1);
        Thread.sleep(50L);
        long t3 = System.currentTimeMillis();
        Thread.sleep(50L);
        s1 = (String)pool.borrowObject();
        Thread.sleep(50L);
        long t4 = System.currentTimeMillis();
        Set strings = pool.listAllObjects();
        Assert.assertEquals((long)1L, (long)strings.size());
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        Assert.assertTrue((s1Info.getCreateTime() > t1 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getCreateTime() < t2 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getLastReturnTime() > t2 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getLastReturnTime() < t3 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getLastBorrowTime() > t3 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getLastBorrowTime() < t4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPooledObjectType() throws Exception {
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());
        pool.borrowObject();
        Set strings = pool.listAllObjects();
        Assert.assertEquals((long)1L, (long)strings.size());
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        Assert.assertEquals((Object)String.class.getName(), (Object)s1Info.getPooledObjectType());
    }

    @Test
    public void testGetPooledObjectToString() throws Exception {
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());
        String s1 = (String)pool.borrowObject();
        Set strings = pool.listAllObjects();
        Assert.assertEquals((long)1L, (long)strings.size());
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        Assert.assertEquals((Object)s1, (Object)s1Info.getPooledObjectToString());
    }
}

