/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.apache.commons.pool2.TestBaseObjectPool;
import org.apache.commons.pool2.VisitTracker;
import org.apache.commons.pool2.VisitTrackerFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenericObjectPool
extends TestBaseObjectPool {
    protected GenericObjectPool<String> pool = null;
    private SimpleFactory factory = null;
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.valueOf(System.getProperty("TestGenericObjectPool.display.thread.details", "false"));

    @Override
    protected ObjectPool<String> makeEmptyPool(int mincap) {
        GenericObjectPool mtPool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory());
        mtPool.setMaxTotal(mincap);
        mtPool.setMaxIdle(mincap);
        return mtPool;
    }

    @Override
    protected ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> fac) {
        return new GenericObjectPool(fac);
    }

    @Override
    protected Object getNthObject(int n) {
        return String.valueOf(n);
    }

    @Before
    public void setUp() throws Exception {
        this.factory = new SimpleFactory();
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory);
    }

    @After
    public void tearDown() throws Exception {
        String poolName = this.pool.getJmxName().toString();
        this.pool.clear();
        this.pool.close();
        this.pool = null;
        this.factory = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assert.assertEquals((String)msg.toString(), (long)0L, (long)registeredPoolCount);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorNullFactory() {
        Assert.assertNotNull((Object)new GenericObjectPool(null));
    }

    @Test(timeout=60000L)
    public void testConstructors() throws Exception {
        int minIdle = 2;
        long maxWait = 3L;
        int maxIdle = 4;
        int maxTotal = 5;
        long minEvictableIdleTimeMillis = 6L;
        int numTestsPerEvictionRun = 7;
        boolean testOnBorrow = true;
        boolean testOnReturn = true;
        boolean testWhileIdle = true;
        long timeBetweenEvictionRunsMillis = 8L;
        boolean blockWhenExhausted = false;
        boolean lifo = false;
        DummyFactory dummyFactory = new DummyFactory();
        GenericObjectPool dummyPool = new GenericObjectPool((PooledObjectFactory)dummyFactory);
        Assert.assertEquals((long)8L, (long)dummyPool.getMaxIdle());
        Assert.assertEquals((long)-1L, (long)dummyPool.getMaxWaitMillis());
        Assert.assertEquals((long)0L, (long)dummyPool.getMinIdle());
        Assert.assertEquals((long)8L, (long)dummyPool.getMaxTotal());
        Assert.assertEquals((long)1800000L, (long)dummyPool.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3L, (long)dummyPool.getNumTestsPerEvictionRun());
        Assert.assertEquals((Object)false, (Object)dummyPool.getTestOnBorrow());
        Assert.assertEquals((Object)false, (Object)dummyPool.getTestOnReturn());
        Assert.assertEquals((Object)false, (Object)dummyPool.getTestWhileIdle());
        Assert.assertEquals((long)-1L, (long)dummyPool.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((Object)true, (Object)dummyPool.getBlockWhenExhausted());
        Assert.assertEquals((Object)true, (Object)dummyPool.getLifo());
        dummyPool.close();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setLifo(lifo);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxTotal(maxTotal);
        config.setMaxWaitMillis(maxWait);
        config.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnReturn(testOnReturn);
        config.setTestWhileIdle(testWhileIdle);
        config.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        config.setBlockWhenExhausted(blockWhenExhausted);
        dummyPool = new GenericObjectPool((PooledObjectFactory)dummyFactory, config);
        Assert.assertEquals((long)maxIdle, (long)dummyPool.getMaxIdle());
        Assert.assertEquals((long)maxWait, (long)dummyPool.getMaxWaitMillis());
        Assert.assertEquals((long)minIdle, (long)dummyPool.getMinIdle());
        Assert.assertEquals((long)maxTotal, (long)dummyPool.getMaxTotal());
        Assert.assertEquals((long)minEvictableIdleTimeMillis, (long)dummyPool.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)numTestsPerEvictionRun, (long)dummyPool.getNumTestsPerEvictionRun());
        Assert.assertEquals((Object)testOnBorrow, (Object)dummyPool.getTestOnBorrow());
        Assert.assertEquals((Object)testOnReturn, (Object)dummyPool.getTestOnReturn());
        Assert.assertEquals((Object)testWhileIdle, (Object)dummyPool.getTestWhileIdle());
        Assert.assertEquals((long)timeBetweenEvictionRunsMillis, (long)dummyPool.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((Object)blockWhenExhausted, (Object)dummyPool.getBlockWhenExhausted());
        Assert.assertEquals((Object)lifo, (Object)dummyPool.getLifo());
        dummyPool.close();
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedFail() throws Exception {
        this.pool.setMaxTotal(1);
        this.pool.setBlockWhenExhausted(false);
        String obj1 = (String)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.pool.returnObject((Object)obj1);
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle());
        this.pool.close();
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlock() throws Exception {
        this.pool.setMaxTotal(1);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(10L);
        String obj1 = (String)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.pool.returnObject((Object)obj1);
        this.pool.close();
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlockInterupt() throws Exception {
        this.pool.setMaxTotal(1);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(-1L);
        String obj1 = (String)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread(this.pool, 200000L);
        wtt.start();
        Thread.sleep(200L);
        wtt.interrupt();
        Thread.sleep(200L);
        Assert.assertTrue((boolean)(wtt._thrown instanceof InterruptedException));
        this.pool.returnObject((Object)obj1);
        this.pool.setMaxWaitMillis(10L);
        String obj2 = null;
        try {
            obj2 = (String)this.pool.borrowObject();
            Assert.assertNotNull((Object)obj2);
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)"NoSuchElementException not expected");
        }
        this.pool.returnObject((Object)obj2);
        this.pool.close();
    }

    @Test(timeout=60000L)
    public void testEvictWhileEmpty() throws Exception {
        this.pool.evict();
        this.pool.evict();
        this.pool.close();
    }

    @Test(timeout=60000L)
    public void testEvictAddObjects() throws Exception {
        this.factory.setMakeLatency(300L);
        this.factory.setMaxTotal(2);
        this.pool.setMaxTotal(2);
        this.pool.setMinIdle(1);
        this.pool.borrowObject();
        TestThread borrower = new TestThread((ObjectPool<String>)this.pool, 1, 150, false);
        Thread borrowerThread = new Thread(borrower);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        borrowerThread.start();
        borrowerThread.join();
        Assert.assertTrue((!borrower.failed() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testEvictLIFO() throws Exception {
        this.checkEvict(true);
    }

    @Test(timeout=60000L)
    public void testEvictFIFO() throws Exception {
        this.checkEvict(false);
    }

    private void checkEvict(boolean lifo) throws Exception {
        this.pool.setSoftMinEvictableIdleTimeMillis(10L);
        this.pool.setMinIdle(2);
        this.pool.setTestWhileIdle(true);
        this.pool.setLifo(lifo);
        PoolUtils.prefill(this.pool, (int)5);
        this.pool.evict();
        this.factory.setEvenValid(false);
        this.factory.setOddValid(false);
        this.factory.setThrowExceptionOnActivate(true);
        this.pool.evict();
        PoolUtils.prefill(this.pool, (int)5);
        this.factory.setThrowExceptionOnActivate(false);
        this.factory.setThrowExceptionOnPassivate(true);
        this.pool.evict();
        this.factory.setThrowExceptionOnPassivate(false);
        this.factory.setEvenValid(true);
        this.factory.setOddValid(true);
        Thread.sleep(125L);
        this.pool.evict();
        Assert.assertEquals((long)2L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEvictionOrder() throws Exception {
        this.checkEvictionOrder(false);
        this.tearDown();
        this.setUp();
        this.checkEvictionOrder(true);
    }

    private void checkEvictionOrder(boolean lifo) throws Exception {
        this.checkEvictionOrderPart1(lifo);
        this.tearDown();
        this.setUp();
        this.checkEvictionOrderPart2(lifo);
    }

    private void checkEvictionOrderPart1(boolean lifo) throws Exception {
        this.pool.setNumTestsPerEvictionRun(2);
        this.pool.setMinEvictableIdleTimeMillis(100L);
        this.pool.setLifo(lifo);
        for (int i = 0; i < 5; ++i) {
            this.pool.addObject();
            Thread.sleep(100L);
        }
        this.pool.evict();
        Object obj = this.pool.borrowObject();
        Assert.assertTrue((String)"oldest not evicted", (!obj.equals("0") ? 1 : 0) != 0);
        Assert.assertTrue((String)"second oldest not evicted", (!obj.equals("1") ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong instance returned", (Object)(lifo ? "4" : "2"), (Object)obj);
    }

    private void checkEvictionOrderPart2(boolean lifo) throws Exception {
        this.pool.setNumTestsPerEvictionRun(2);
        this.pool.setMinEvictableIdleTimeMillis(100L);
        this.pool.setLifo(lifo);
        for (int i = 0; i < 5; ++i) {
            this.pool.addObject();
            Thread.sleep(100L);
        }
        this.pool.evict();
        this.pool.evict();
        Object obj = this.pool.borrowObject();
        Assert.assertEquals((String)"Wrong instance remaining in pool", (Object)"4", (Object)obj);
    }

    @Test
    public void testEvictorVisiting() throws Exception {
        this.checkEvictorVisiting(true);
        this.checkEvictorVisiting(false);
    }

    private void checkEvictorVisiting(boolean lifo) throws Exception {
        VisitTracker tracker;
        int i;
        VisitTrackerFactory trackerFactory = new VisitTrackerFactory();
        GenericObjectPool trackerPool = new GenericObjectPool(trackerFactory);
        trackerPool.setNumTestsPerEvictionRun(2);
        trackerPool.setMinEvictableIdleTimeMillis(-1L);
        trackerPool.setTestWhileIdle(true);
        trackerPool.setLifo(lifo);
        trackerPool.setTestOnReturn(false);
        trackerPool.setTestOnBorrow(false);
        for (int i2 = 0; i2 < 8; ++i2) {
            trackerPool.addObject();
        }
        trackerPool.evict();
        VisitTracker obj = (VisitTracker)trackerPool.borrowObject();
        trackerPool.returnObject((Object)obj);
        obj = (VisitTracker)trackerPool.borrowObject();
        trackerPool.returnObject((Object)obj);
        trackerPool.evict();
        for (i = 0; i < 8; ++i) {
            tracker = (VisitTracker)trackerPool.borrowObject();
            if (tracker.getId() >= 4) {
                Assert.assertEquals((String)("Unexpected instance visited " + tracker.getId()), (long)0L, (long)tracker.getValidateCount());
                continue;
            }
            Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)1L, (long)tracker.getValidateCount());
        }
        trackerPool.close();
        trackerFactory = new VisitTrackerFactory();
        trackerPool = new GenericObjectPool(trackerFactory);
        trackerPool.setNumTestsPerEvictionRun(3);
        trackerPool.setMinEvictableIdleTimeMillis(-1L);
        trackerPool.setTestWhileIdle(true);
        trackerPool.setLifo(lifo);
        trackerPool.setTestOnReturn(false);
        trackerPool.setTestOnBorrow(false);
        for (i = 0; i < 8; ++i) {
            trackerPool.addObject();
        }
        trackerPool.evict();
        trackerPool.evict();
        obj = (VisitTracker)trackerPool.borrowObject();
        trackerPool.returnObject((Object)obj);
        obj = (VisitTracker)trackerPool.borrowObject();
        trackerPool.returnObject((Object)obj);
        obj = (VisitTracker)trackerPool.borrowObject();
        trackerPool.returnObject((Object)obj);
        trackerPool.evict();
        for (i = 0; i < 8; ++i) {
            tracker = (VisitTracker)trackerPool.borrowObject();
            if (tracker.getId() != 0) {
                Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)1L, (long)tracker.getValidateCount());
                continue;
            }
            Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)2L, (long)tracker.getValidateCount());
        }
        trackerPool.close();
        int[] smallPrimes = new int[]{2, 3, 5, 7};
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                trackerPool = new GenericObjectPool(trackerFactory);
                trackerPool.setNumTestsPerEvictionRun(smallPrimes[i3]);
                trackerPool.setMinEvictableIdleTimeMillis(-1L);
                trackerPool.setTestWhileIdle(true);
                trackerPool.setLifo(lifo);
                trackerPool.setTestOnReturn(false);
                trackerPool.setTestOnBorrow(false);
                trackerPool.setMaxIdle(-1);
                int instanceCount = 10 + random.nextInt(20);
                trackerPool.setMaxTotal(instanceCount);
                for (int k = 0; k < instanceCount; ++k) {
                    trackerPool.addObject();
                }
                int runs = 10 + random.nextInt(50);
                for (int k = 0; k < runs; ++k) {
                    trackerPool.evict();
                }
                int cycleCount = runs * trackerPool.getNumTestsPerEvictionRun() / instanceCount;
                VisitTracker tracker2 = null;
                int visitCount = 0;
                for (int k = 0; k < instanceCount; ++k) {
                    tracker2 = (VisitTracker)trackerPool.borrowObject();
                    Assert.assertTrue((trackerPool.getNumActive() <= trackerPool.getMaxTotal() ? 1 : 0) != 0);
                    visitCount = tracker2.getValidateCount();
                    Assert.assertTrue((visitCount >= cycleCount && visitCount <= cycleCount + 1 ? 1 : 0) != 0);
                }
                trackerPool.close();
            }
        }
    }

    @Test(timeout=60000L)
    public void testExceptionOnPassivateDuringReturn() throws Exception {
        String obj = (String)this.pool.borrowObject();
        this.factory.setThrowExceptionOnPassivate(true);
        this.pool.returnObject((Object)obj);
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnDestroyDuringBorrow() throws Exception {
        this.factory.setThrowExceptionOnDestroy(true);
        this.pool.setTestOnBorrow(true);
        this.pool.borrowObject();
        this.factory.setValid(false);
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnDestroyDuringReturn() throws Exception {
        this.factory.setThrowExceptionOnDestroy(true);
        this.pool.setTestOnReturn(true);
        String obj1 = (String)this.pool.borrowObject();
        this.pool.borrowObject();
        this.factory.setValid(false);
        this.pool.returnObject((Object)obj1);
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnActivateDuringBorrow() throws Exception {
        String obj1 = (String)this.pool.borrowObject();
        String obj2 = (String)this.pool.borrowObject();
        this.pool.returnObject((Object)obj1);
        this.pool.returnObject((Object)obj2);
        this.factory.setThrowExceptionOnActivate(true);
        this.factory.setEvenValid(false);
        String obj = (String)this.pool.borrowObject();
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.returnObject((Object)obj);
        this.factory.setValid(false);
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testNegativeMaxTotal() throws Exception {
        this.pool.setMaxTotal(-1);
        this.pool.setBlockWhenExhausted(false);
        String obj = (String)this.pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(0), (Object)obj);
        this.pool.returnObject((Object)obj);
    }

    @Test(timeout=60000L)
    public void testMaxIdle() throws Exception {
        int i;
        this.pool.setMaxTotal(100);
        this.pool.setMaxIdle(8);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        Assert.assertEquals((long)100L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        for (i = 0; i < 100; ++i) {
            this.pool.returnObject((Object)active[i]);
            Assert.assertEquals((long)(99 - i), (long)this.pool.getNumActive());
            Assert.assertEquals((long)(i < 8 ? i + 1 : 8), (long)this.pool.getNumIdle());
        }
    }

    @Test(timeout=60000L)
    public void testMaxIdleZero() throws Exception {
        int i;
        this.pool.setMaxTotal(100);
        this.pool.setMaxIdle(0);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        Assert.assertEquals((long)100L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        for (i = 0; i < 100; ++i) {
            this.pool.returnObject((Object)active[i]);
            Assert.assertEquals((long)(99 - i), (long)this.pool.getNumActive());
            Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        }
    }

    @Test(timeout=60000L)
    public void testMaxTotal() throws Exception {
        this.pool.setMaxTotal(3);
        this.pool.setBlockWhenExhausted(false);
        this.pool.borrowObject();
        this.pool.borrowObject();
        this.pool.borrowObject();
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testTimeoutNoLeak() throws Exception {
        this.pool.setMaxTotal(2);
        this.pool.setMaxWaitMillis(10L);
        this.pool.setBlockWhenExhausted(true);
        String obj = (String)this.pool.borrowObject();
        String obj2 = (String)this.pool.borrowObject();
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.pool.returnObject((Object)obj2);
        this.pool.returnObject((Object)obj);
        this.pool.borrowObject();
        this.pool.borrowObject();
    }

    @Test(timeout=60000L)
    public void testMaxTotalZero() throws Exception {
        this.pool.setMaxTotal(0);
        this.pool.setBlockWhenExhausted(false);
        try {
            this.pool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMaxTotalUnderLoad() {
        int i;
        int numThreads = 199;
        int numIter = 20;
        int delay = 25;
        int maxTotal = 10;
        this.factory.setMaxTotal(maxTotal);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setTimeBetweenEvictionRunsMillis(-1L);
        TestThread[] threads = new TestThread[numThreads];
        for (int i2 = 0; i2 < numThreads; ++i2) {
            threads[i2] = new TestThread((ObjectPool<String>)this.pool, numIter * 2, delay * 2);
            Thread t = new Thread(threads[i2]);
            t.start();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (i = 0; i < numIter; ++i) {
            String obj = null;
            try {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                obj = (String)this.pool.borrowObject();
                if (this.pool.getNumActive() > this.pool.getMaxTotal()) {
                    throw new IllegalStateException("Too many active objects");
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Exception on borrow");
                continue;
            }
            finally {
                if (obj != null) {
                    try {
                        this.pool.returnObject((Object)obj);
                    }
                    catch (Exception e) {}
                }
            }
        }
        for (i = 0; i < numThreads; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            if (!threads[i].failed()) continue;
            Assert.fail((String)("Thread " + i + " failed: " + threads[i]._error.toString()));
        }
    }

    @Test(timeout=60000L)
    public void testSettersAndGetters() throws Exception {
        Assert.assertTrue((false == "".equals(this.pool.getCreationStackTrace()) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.pool.getBorrowedCount());
        Assert.assertEquals((long)0L, (long)this.pool.getReturnedCount());
        Assert.assertEquals((long)0L, (long)this.pool.getCreatedCount());
        Assert.assertEquals((long)0L, (long)this.pool.getDestroyedCount());
        Assert.assertEquals((long)0L, (long)this.pool.getDestroyedByEvictorCount());
        Assert.assertEquals((long)0L, (long)this.pool.getDestroyedByBorrowValidationCount());
        Assert.assertEquals((long)0L, (long)this.pool.getMeanActiveTimeMillis());
        Assert.assertEquals((long)0L, (long)this.pool.getMeanIdleTimeMillis());
        Assert.assertEquals((long)0L, (long)this.pool.getMeanBorrowWaitTimeMillis());
        Assert.assertEquals((long)0L, (long)this.pool.getMaxBorrowWaitTimeMillis());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.setMaxTotal(123);
        Assert.assertEquals((long)123L, (long)this.pool.getMaxTotal());
        this.pool.setMaxIdle(12);
        Assert.assertEquals((long)12L, (long)this.pool.getMaxIdle());
        this.pool.setMaxWaitMillis(1234L);
        Assert.assertEquals((long)1234L, (long)this.pool.getMaxWaitMillis());
        this.pool.setMinEvictableIdleTimeMillis(12345L);
        Assert.assertEquals((long)12345L, (long)this.pool.getMinEvictableIdleTimeMillis());
        this.pool.setNumTestsPerEvictionRun(11);
        Assert.assertEquals((long)11L, (long)this.pool.getNumTestsPerEvictionRun());
        this.pool.setTestOnBorrow(true);
        Assert.assertTrue((boolean)this.pool.getTestOnBorrow());
        this.pool.setTestOnBorrow(false);
        Assert.assertTrue((!this.pool.getTestOnBorrow() ? 1 : 0) != 0);
        this.pool.setTestOnReturn(true);
        Assert.assertTrue((boolean)this.pool.getTestOnReturn());
        this.pool.setTestOnReturn(false);
        Assert.assertTrue((!this.pool.getTestOnReturn() ? 1 : 0) != 0);
        this.pool.setTestWhileIdle(true);
        Assert.assertTrue((boolean)this.pool.getTestWhileIdle());
        this.pool.setTestWhileIdle(false);
        Assert.assertTrue((!this.pool.getTestWhileIdle() ? 1 : 0) != 0);
        this.pool.setTimeBetweenEvictionRunsMillis(11235L);
        Assert.assertEquals((long)11235L, (long)this.pool.getTimeBetweenEvictionRunsMillis());
        this.pool.setSoftMinEvictableIdleTimeMillis(12135L);
        Assert.assertEquals((long)12135L, (long)this.pool.getSoftMinEvictableIdleTimeMillis());
        this.pool.setBlockWhenExhausted(true);
        Assert.assertTrue((boolean)this.pool.getBlockWhenExhausted());
        this.pool.setBlockWhenExhausted(false);
        Assert.assertFalse((boolean)this.pool.getBlockWhenExhausted());
    }

    @Test(timeout=60000L)
    public void testDefaultConfiguration() throws Exception {
        this.assertConfiguration(new GenericObjectPoolConfig(), this.pool);
    }

    @Test(timeout=60000L)
    public void testSetConfig() throws Exception {
        GenericObjectPoolConfig expected = new GenericObjectPoolConfig();
        this.assertConfiguration(expected, this.pool);
        expected.setMaxTotal(2);
        expected.setMaxIdle(3);
        expected.setMaxWaitMillis(5L);
        expected.setMinEvictableIdleTimeMillis(7L);
        expected.setNumTestsPerEvictionRun(9);
        expected.setTestOnBorrow(true);
        expected.setTestOnReturn(true);
        expected.setTestWhileIdle(true);
        expected.setTimeBetweenEvictionRunsMillis(11L);
        expected.setBlockWhenExhausted(false);
        this.pool.setConfig(expected);
        this.assertConfiguration(expected, this.pool);
    }

    @Test(timeout=60000L)
    public void testStartAndStopEvictor() throws Exception {
        this.pool.setMaxIdle(6);
        this.pool.setMaxTotal(6);
        this.pool.setNumTestsPerEvictionRun(6);
        this.pool.setMinEvictableIdleTimeMillis(100L);
        for (int j = 0; j < 2; ++j) {
            int i;
            String[] active = new String[6];
            for (i = 0; i < 6; ++i) {
                active[i] = (String)this.pool.borrowObject();
            }
            for (i = 0; i < 6; ++i) {
                this.pool.returnObject((Object)active[i]);
            }
            Assert.assertEquals((String)"Should have 6 idle", (long)6L, (long)this.pool.getNumIdle());
            this.pool.setTimeBetweenEvictionRunsMillis(50L);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((String)"Should have 0 idle", (long)0L, (long)this.pool.getNumIdle());
            this.pool.startEvictor(0L);
        }
    }

    @Test(timeout=60000L)
    public void testEvictionWithNegativeNumTests() throws Exception {
        int i;
        this.pool.setMaxIdle(6);
        this.pool.setMaxTotal(6);
        this.pool.setNumTestsPerEvictionRun(-2);
        this.pool.setMinEvictableIdleTimeMillis(50L);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        String[] active = new String[6];
        for (i = 0; i < 6; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        for (i = 0; i < 6; ++i) {
            this.pool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should at most 6 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() <= 6 ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should at most 3 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() <= 3 ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be at most 2 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() <= 2 ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.pool.getNumIdle()), (long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEviction() throws Exception {
        int i;
        int i2;
        this.pool.setMaxIdle(500);
        this.pool.setMaxTotal(500);
        this.pool.setNumTestsPerEvictionRun(100);
        this.pool.setMinEvictableIdleTimeMillis(250L);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        this.pool.setTestWhileIdle(true);
        String[] active = new String[500];
        for (i2 = 0; i2 < 500; ++i2) {
            active[i2] = (String)this.pool.borrowObject();
        }
        for (i2 = 0; i2 < 500; ++i2) {
            this.pool.returnObject((Object)active[i2]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.pool.getNumIdle()), (long)0L, (long)this.pool.getNumIdle());
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.pool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.pool.getNumIdle()), (long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEvictionPolicy() throws Exception {
        int i;
        this.pool.setMaxIdle(500);
        this.pool.setMaxTotal(500);
        this.pool.setNumTestsPerEvictionRun(500);
        this.pool.setMinEvictableIdleTimeMillis(250L);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        this.pool.setTestWhileIdle(true);
        try {
            this.pool.setEvictionPolicyClassName(Long.toString(System.currentTimeMillis()));
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.pool.setEvictionPolicyClassName(Serializable.class.getName());
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.pool.setEvictionPolicyClassName(Collections.class.getName());
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.pool.setEvictionPolicyClassName(TestEvictionPolicy.class.getName());
        Assert.assertEquals((Object)TestEvictionPolicy.class.getName(), (Object)this.pool.getEvictionPolicyClassName());
        String[] active = new String[500];
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.pool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should be 500 idle", (long)500L, (long)this.pool.getNumIdle());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should be 0 idle", (long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEvictionSoftMinIdle() throws Exception {
        int i;
        class TimeTest
        extends BasePooledObjectFactory<TimeTest> {
            private final long createTime = System.currentTimeMillis();

            public TimeTest create() throws Exception {
                return new TimeTest();
            }

            public PooledObject<TimeTest> wrap(TimeTest value) {
                return new DefaultPooledObject((Object)value);
            }

            public long getCreateTime() {
                return this.createTime;
            }
        }
        GenericObjectPool timePool = new GenericObjectPool((PooledObjectFactory)new TimeTest());
        timePool.setMaxIdle(5);
        timePool.setMaxTotal(5);
        timePool.setNumTestsPerEvictionRun(5);
        timePool.setMinEvictableIdleTimeMillis(3000L);
        timePool.setSoftMinEvictableIdleTimeMillis(1000L);
        timePool.setMinIdle(2);
        TimeTest[] active = new TimeTest[5];
        Long[] creationTime = new Long[5];
        for (i = 0; i < 5; ++i) {
            active[i] = (TimeTest)((Object)timePool.borrowObject());
            creationTime[i] = active[i].getCreateTime();
        }
        for (i = 0; i < 5; ++i) {
            timePool.returnObject((Object)active[i]);
        }
        Thread.sleep(1500L);
        timePool.evict();
        Assert.assertEquals((String)"Idle count different than expected.", (long)2L, (long)timePool.getNumIdle());
        Thread.sleep(2000L);
        timePool.evict();
        Assert.assertEquals((String)"Idle count different than expected.", (long)0L, (long)timePool.getNumIdle());
        timePool.close();
    }

    @Test(timeout=60000L)
    public void testEvictionInvalid() throws Exception {
        GenericObjectPool invalidFactoryPool = new GenericObjectPool((PooledObjectFactory)new InvalidFactory());
        invalidFactoryPool.setMaxIdle(1);
        invalidFactoryPool.setMaxTotal(1);
        invalidFactoryPool.setTestOnBorrow(false);
        invalidFactoryPool.setTestOnReturn(false);
        invalidFactoryPool.setTestWhileIdle(true);
        invalidFactoryPool.setMinEvictableIdleTimeMillis(100000L);
        invalidFactoryPool.setNumTestsPerEvictionRun(1);
        Object p = invalidFactoryPool.borrowObject();
        invalidFactoryPool.returnObject(p);
        EvictionThread t = new EvictionThread(invalidFactoryPool);
        t.start();
        Thread.sleep(300L);
        try {
            invalidFactoryPool.borrowObject(1L);
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Idle count different than expected.", (long)0L, (long)invalidFactoryPool.getNumIdle());
        Assert.assertEquals((String)"Total count different than expected.", (long)0L, (long)invalidFactoryPool.getNumActive());
        invalidFactoryPool.close();
    }

    @Test
    public void testConcurrentInvalidate() throws Exception {
        int i;
        int nObjects = 1000;
        this.pool.setMaxTotal(1000);
        this.pool.setMaxIdle(1000);
        String[] obj = new String[1000];
        for (i = 0; i < 1000; ++i) {
            obj[i] = (String)this.pool.borrowObject();
        }
        for (i = 0; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            this.pool.returnObject((Object)obj[i]);
        }
        int nThreads = 20;
        int nIterations = 60;
        InvalidateThread[] threads = new InvalidateThread[20];
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Random random = new Random();
        for (int j = 0; j < 60; ++j) {
            int i2;
            Integer targ = random.nextInt(1000);
            while (targets.contains(targ)) {
                targ = random.nextInt(1000);
            }
            targets.add(targ);
            for (i2 = 0; i2 < 20; ++i2) {
                threads[i2] = new InvalidateThread((ObjectPool<String>)this.pool, obj[targ]);
            }
            for (i2 = 0; i2 < 20; ++i2) {
                new Thread(threads[i2]).start();
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int i3 = 0; i3 < 20; ++i3) {
                    done = done && threads[i3].complete();
                }
                Thread.sleep(100L);
            }
        }
        Assert.assertEquals((long)60L, (long)this.pool.getDestroyedCount());
    }

    @Test(timeout=60000L)
    public void testMinIdle() throws Exception {
        this.pool.setMaxIdle(500);
        this.pool.setMinIdle(5);
        this.pool.setMaxTotal(10);
        this.pool.setNumTestsPerEvictionRun(0);
        this.pool.setMinEvictableIdleTimeMillis(50L);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        this.pool.setTestWhileIdle(true);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        String[] active = new String[5];
        active[0] = (String)this.pool.borrowObject();
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 1; i < 5; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            this.pool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 10 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMinIdleMaxTotal() throws Exception {
        this.pool.setMaxIdle(500);
        this.pool.setMinIdle(5);
        this.pool.setMaxTotal(10);
        this.pool.setNumTestsPerEvictionRun(0);
        this.pool.setMinEvictableIdleTimeMillis(50L);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        this.pool.setTestWhileIdle(true);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        String[] active = new String[10];
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            this.pool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 10 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            active[i] = (String)this.pool.borrowObject();
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 0 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            this.pool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 10 ? 1 : 0) != 0);
    }

    private void runTestThreads(int numThreads, int iterations, int delay) {
        int i;
        TestThread[] threads = new TestThread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new TestThread((ObjectPool<String>)this.pool, iterations, delay);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        for (i = 0; i < numThreads; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            if (!threads[i].failed()) continue;
            Assert.fail((String)("Thread " + i + " failed: " + threads[i]._error.toString()));
        }
    }

    @Test(timeout=60000L)
    public void testThreaded1() throws Exception {
        this.pool.setMaxTotal(15);
        this.pool.setMaxIdle(15);
        this.pool.setMaxWaitMillis(1000L);
        this.runTestThreads(20, 100, 50);
    }

    @Test(timeout=60000L)
    public void testMaxTotalInvariant() throws Exception {
        int maxTotal = 15;
        this.factory.setEvenValid(false);
        this.factory.setDestroyLatency(100L);
        this.factory.setMaxTotal(maxTotal);
        this.factory.setValidationEnabled(true);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setMaxIdle(-1);
        this.pool.setTestOnReturn(true);
        this.pool.setMaxWaitMillis(1000L);
        this.runTestThreads(5, 10, 50);
    }

    @Test(timeout=60000L)
    public void testConcurrentBorrowAndEvict() throws Exception {
        this.pool.setMaxTotal(1);
        this.pool.addObject();
        for (int i = 0; i < 5000; ++i) {
            ConcurrentBorrowAndEvictThread one = new ConcurrentBorrowAndEvictThread(true);
            ConcurrentBorrowAndEvictThread two = new ConcurrentBorrowAndEvictThread(false);
            one.start();
            two.start();
            one.join();
            two.join();
            this.pool.returnObject((Object)one.obj);
        }
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlockClosePool() throws Exception {
        this.pool.setMaxTotal(1);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(-1L);
        Object obj1 = this.pool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread(this.pool, 200L);
        wtt.start();
        Thread.sleep(200L);
        this.pool.close();
        Thread.sleep(200L);
        Assert.assertTrue((boolean)(wtt._thrown instanceof InterruptedException));
    }

    @Test(timeout=60000L)
    public void testFIFO() throws Exception {
        String o = null;
        this.pool.setLifo(false);
        this.pool.addObject();
        this.pool.addObject();
        this.pool.addObject();
        Assert.assertEquals((String)"Oldest", (Object)"0", (Object)this.pool.borrowObject());
        Assert.assertEquals((String)"Middle", (Object)"1", (Object)this.pool.borrowObject());
        Assert.assertEquals((String)"Youngest", (Object)"2", (Object)this.pool.borrowObject());
        o = (String)this.pool.borrowObject();
        Assert.assertEquals((String)"new-3", (Object)"3", (Object)o);
        this.pool.returnObject((Object)o);
        Assert.assertEquals((String)"returned-3", (Object)o, (Object)this.pool.borrowObject());
        Assert.assertEquals((String)"new-4", (Object)"4", (Object)this.pool.borrowObject());
    }

    @Test(timeout=60000L)
    public void testLIFO() throws Exception {
        String o = null;
        this.pool.setLifo(true);
        this.pool.addObject();
        this.pool.addObject();
        this.pool.addObject();
        Assert.assertEquals((String)"Youngest", (Object)"2", (Object)this.pool.borrowObject());
        Assert.assertEquals((String)"Middle", (Object)"1", (Object)this.pool.borrowObject());
        Assert.assertEquals((String)"Oldest", (Object)"0", (Object)this.pool.borrowObject());
        o = (String)this.pool.borrowObject();
        Assert.assertEquals((String)"new-3", (Object)"3", (Object)o);
        this.pool.returnObject((Object)o);
        Assert.assertEquals((String)"returned-3", (Object)o, (Object)this.pool.borrowObject());
        Assert.assertEquals((String)"new-4", (Object)"4", (Object)this.pool.borrowObject());
    }

    @Test(timeout=60000L)
    public void testAddObject() throws Exception {
        Assert.assertEquals((String)"should be zero idle", (long)0L, (long)this.pool.getNumIdle());
        this.pool.addObject();
        Assert.assertEquals((String)"should be one idle", (long)1L, (long)this.pool.getNumIdle());
        Assert.assertEquals((String)"should be zero active", (long)0L, (long)this.pool.getNumActive());
        String obj = (String)this.pool.borrowObject();
        Assert.assertEquals((String)"should be zero idle", (long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((String)"should be one active", (long)1L, (long)this.pool.getNumActive());
        this.pool.returnObject((Object)obj);
        Assert.assertEquals((String)"should be one idle", (long)1L, (long)this.pool.getNumIdle());
        Assert.assertEquals((String)"should be zero active", (long)0L, (long)this.pool.getNumActive());
    }

    private void assertConfiguration(GenericObjectPoolConfig expected, GenericObjectPool<?> actual) throws Exception {
        Assert.assertEquals((String)"testOnBorrow", (Object)expected.getTestOnBorrow(), (Object)actual.getTestOnBorrow());
        Assert.assertEquals((String)"testOnReturn", (Object)expected.getTestOnReturn(), (Object)actual.getTestOnReturn());
        Assert.assertEquals((String)"testWhileIdle", (Object)expected.getTestWhileIdle(), (Object)actual.getTestWhileIdle());
        Assert.assertEquals((String)"whenExhaustedAction", (Object)expected.getBlockWhenExhausted(), (Object)actual.getBlockWhenExhausted());
        Assert.assertEquals((String)"maxTotal", (long)expected.getMaxTotal(), (long)actual.getMaxTotal());
        Assert.assertEquals((String)"maxIdle", (long)expected.getMaxIdle(), (long)actual.getMaxIdle());
        Assert.assertEquals((String)"maxWait", (long)expected.getMaxWaitMillis(), (long)actual.getMaxWaitMillis());
        Assert.assertEquals((String)"minEvictableIdleTimeMillis", (long)expected.getMinEvictableIdleTimeMillis(), (long)actual.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((String)"numTestsPerEvictionRun", (long)expected.getNumTestsPerEvictionRun(), (long)actual.getNumTestsPerEvictionRun());
        Assert.assertEquals((String)"timeBetweenEvictionRunsMillis", (long)expected.getTimeBetweenEvictionRunsMillis(), (long)actual.getTimeBetweenEvictionRunsMillis());
    }

    @Override
    protected boolean isLifo() {
        return true;
    }

    @Override
    protected boolean isFifo() {
        return false;
    }

    @Test(timeout=60000L)
    public void testBorrowObjectFairness() {
        int i;
        int numThreads = 30;
        int maxTotal = 10;
        this.pool.setMaxTotal(maxTotal);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setTimeBetweenEvictionRunsMillis(-1L);
        TestThread[] threads = new TestThread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new TestThread((ObjectPool<String>)this.pool, 1, 2000, false, String.valueOf(i % maxTotal));
            Thread t = new Thread(threads[i]);
            t.start();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.toString());
            }
        }
        for (i = 0; i < numThreads; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            if (!threads[i].failed()) continue;
            Assert.fail((String)("Thread " + i + " failed: " + threads[i]._error.toString()));
        }
    }

    @Test(timeout=60000L)
    public void testBrokenFactoryShouldNotBlockPool() {
        int maxTotal = 1;
        this.factory.setMaxTotal(maxTotal);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setTestOnBorrow(true);
        String obj = null;
        Exception ex = null;
        this.factory.setValid(false);
        try {
            obj = (String)this.pool.borrowObject();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        Assert.assertNull((Object)obj);
        this.factory.setValid(true);
        try {
            obj = (String)this.pool.borrowObject();
        }
        catch (Exception e1) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)obj);
        try {
            this.pool.returnObject((Object)obj);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(timeout=60000L)
    public void testMaxWaitMultiThreaded() throws Exception {
        int i;
        long maxWait = 500L;
        long holdTime = 1000L;
        int threads = 10;
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(500L);
        this.pool.setMaxTotal(10);
        WaitingTestThread[] wtt = new WaitingTestThread[20];
        for (int i2 = 0; i2 < wtt.length; ++i2) {
            wtt[i2] = new WaitingTestThread(this.pool, 1000L);
        }
        long origin = System.currentTimeMillis() - 1000L;
        for (int i3 = 0; i3 < wtt.length; ++i3) {
            wtt[i3].start();
        }
        int failed = 0;
        for (i = 0; i < wtt.length; ++i) {
            wtt[i].join();
            if (wtt[i]._thrown == null) continue;
            ++failed;
        }
        if (DISPLAY_THREAD_DETAILS || wtt.length / 2 != failed) {
            System.out.println("MaxWait: 500 HoldTime: 1000 MaxTotal: 10 Threads: " + wtt.length + " Failed: " + failed);
            for (i = 0; i < wtt.length; ++i) {
                WaitingTestThread wt = wtt[i];
                System.out.println("Preborrow: " + (wt.preborrow - origin) + " Postborrow: " + (wt.postborrow != 0L ? wt.postborrow - origin : -1L) + " BorrowTime: " + (wt.postborrow != 0L ? wt.postborrow - wt.preborrow : -1L) + " PostReturn: " + (wt.postreturn != 0L ? wt.postreturn - origin : -1L) + " Ended: " + (wt.ended - origin) + " ObjId: " + wt.objectId);
            }
        }
        Assert.assertEquals((String)"Expected half the threads to fail", (long)(wtt.length / 2), (long)failed);
    }

    @Test(timeout=60000L)
    public void testMakeConcurrentWithReturn() throws Exception {
        this.pool.setTestOnBorrow(true);
        this.factory.setValid(true);
        WaitingTestThread thread1 = new WaitingTestThread(this.pool, 200L);
        thread1.start();
        Thread.sleep(50L);
        this.factory.setValidateLatency(400L);
        String instance = (String)this.pool.borrowObject();
        Assert.assertEquals((long)this.factory.getMakeCounter(), (long)(this.pool.getNumIdle() + 1));
        this.pool.returnObject((Object)instance);
        Assert.assertEquals((long)this.factory.getMakeCounter(), (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testJmxRegistration() {
        ObjectName oname = this.pool.getJmxName();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(oname, null);
        Assert.assertEquals((long)1L, (long)result.size());
        this.pool.jmxUnregister();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        GenericObjectPool poolWithoutJmx = new GenericObjectPool((PooledObjectFactory)this.factory, config);
        Assert.assertNull((Object)poolWithoutJmx.getJmxName());
        config.setJmxEnabled(true);
        poolWithoutJmx.jmxUnregister();
        config.setJmxNameBase(null);
        GenericObjectPool poolWithDefaultJmxNameBase = new GenericObjectPool((PooledObjectFactory)this.factory, config);
        Assert.assertNotNull((Object)poolWithDefaultJmxNameBase.getJmxName());
    }

    @Test
    public void testInvalidateFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);
        pool.setMaxTotal(2);
        pool.setMaxWaitMillis(500L);
        WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)pool, 5000L);
        thread1.start();
        String obj = (String)pool.borrowObject();
        WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)pool, 100L);
        thread2.start();
        Thread.sleep(20L);
        pool.invalidateObject((Object)obj);
        Thread.sleep(600L);
        if (thread2._thrown != null) {
            Assert.fail((String)thread2._thrown.toString());
        }
    }

    @Test
    public void testValidationFailureOnReturnFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setValid(false);
        factory.setValidationEnabled(true);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);
        pool.setMaxTotal(2);
        pool.setMaxWaitMillis(1500L);
        pool.setTestOnReturn(true);
        pool.setTestOnBorrow(false);
        WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)pool, 5000L);
        thread1.start();
        WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)pool, 500L);
        thread2.start();
        Thread.sleep(50L);
        String obj = (String)pool.borrowObject();
        pool.returnObject((Object)obj);
    }

    @Test
    public void testSwallowedExceptionListener() {
        this.pool.setSwallowedExceptionListener(null);
        final ArrayList swallowedExceptions = new ArrayList();
        SwallowedExceptionListener listener = new SwallowedExceptionListener(){

            public void onSwallowException(Exception e) {
                if (swallowedExceptions.size() == 2) {
                    throw new OutOfMemoryError();
                }
                swallowedExceptions.add(e);
            }
        };
        this.pool.setSwallowedExceptionListener(listener);
        Exception e1 = new Exception();
        ArrayIndexOutOfBoundsException e2 = new ArrayIndexOutOfBoundsException();
        this.pool.swallowException(e1);
        this.pool.swallowException((Exception)e2);
        try {
            this.pool.swallowException(e1);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (OutOfMemoryError oom) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)swallowedExceptions.size());
    }

    private static class EvictionThread<T>
    extends Thread {
        private final GenericObjectPool<T> pool;

        public EvictionThread(GenericObjectPool<T> pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.evict();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class InvalidFactory
    extends BasePooledObjectFactory<Object> {
        private InvalidFactory() {
        }

        public Object create() throws Exception {
            return new Object();
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }

        public boolean validateObject(PooledObject<Object> obj) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    private static final class DummyFactory
    extends BasePooledObjectFactory<Object> {
        private DummyFactory() {
        }

        public Object create() throws Exception {
            return null;
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    static class WaitingTestThread
    extends Thread {
        private final GenericObjectPool<String> _pool;
        private final long _pause;
        private Throwable _thrown;
        private long preborrow;
        private long postborrow;
        private long postreturn;
        private long ended;
        private String objectId;

        public WaitingTestThread(GenericObjectPool<String> pool, long pause) {
            this._pool = pool;
            this._pause = pause;
            this._thrown = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String obj;
                this.preborrow = System.currentTimeMillis();
                this.objectId = obj = (String)this._pool.borrowObject();
                this.postborrow = System.currentTimeMillis();
                Thread.sleep(this._pause);
                this._pool.returnObject((Object)obj);
                this.postreturn = System.currentTimeMillis();
            }
            catch (Exception e) {
                this._thrown = e;
            }
            finally {
                this.ended = System.currentTimeMillis();
            }
        }
    }

    public static class SimpleFactory
    implements PooledObjectFactory<String> {
        int makeCounter = 0;
        int validateCounter = 0;
        int activeCount = 0;
        boolean evenValid = true;
        boolean oddValid = true;
        boolean exceptionOnPassivate = false;
        boolean exceptionOnActivate = false;
        boolean exceptionOnDestroy = false;
        boolean enableValidation = true;
        long destroyLatency = 0L;
        long makeLatency = 0L;
        long validateLatency = 0L;
        int maxTotal = Integer.MAX_VALUE;

        public SimpleFactory() {
            this(true);
        }

        public SimpleFactory(boolean valid) {
            this(valid, valid);
        }

        public SimpleFactory(boolean evalid, boolean ovalid) {
            this.evenValid = evalid;
            this.oddValid = ovalid;
        }

        public synchronized void setValid(boolean valid) {
            this.setEvenValid(valid);
            this.setOddValid(valid);
        }

        public synchronized void setEvenValid(boolean valid) {
            this.evenValid = valid;
        }

        public synchronized void setOddValid(boolean valid) {
            this.oddValid = valid;
        }

        public synchronized void setThrowExceptionOnPassivate(boolean bool) {
            this.exceptionOnPassivate = bool;
        }

        public synchronized void setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
        }

        public synchronized void setDestroyLatency(long destroyLatency) {
            this.destroyLatency = destroyLatency;
        }

        public synchronized void setMakeLatency(long makeLatency) {
            this.makeLatency = makeLatency;
        }

        public synchronized void setValidateLatency(long validateLatency) {
            this.validateLatency = validateLatency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PooledObject<String> makeObject() {
            int counter;
            long waitLatency;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                ++this.activeCount;
                if (this.activeCount > this.maxTotal) {
                    throw new IllegalStateException("Too many active instances: " + this.activeCount);
                }
                waitLatency = this.makeLatency;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            SimpleFactory simpleFactory2 = this;
            synchronized (simpleFactory2) {
                counter = this.makeCounter++;
            }
            return new DefaultPooledObject((Object)String.valueOf(counter));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(PooledObject<String> obj) throws Exception {
            boolean hurl;
            long waitLatency;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                waitLatency = this.destroyLatency;
                hurl = this.exceptionOnDestroy;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            simpleFactory = this;
            synchronized (simpleFactory) {
                --this.activeCount;
            }
            if (hurl) {
                throw new Exception();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(PooledObject<String> obj) {
            long waitLatency;
            int counter;
            boolean oddTest;
            boolean evenTest;
            boolean validate;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                validate = this.enableValidation;
                evenTest = this.evenValid;
                oddTest = this.oddValid;
                counter = this.validateCounter++;
                waitLatency = this.validateLatency;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            if (validate) {
                return counter % 2 == 0 ? evenTest : oddTest;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateObject(PooledObject<String> obj) throws Exception {
            int counter;
            boolean oddTest;
            boolean evenTest;
            boolean hurl;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                hurl = this.exceptionOnActivate;
                evenTest = this.evenValid;
                oddTest = this.oddValid;
                counter = this.validateCounter++;
            }
            if (hurl && !(counter % 2 != 0 ? oddTest : evenTest)) {
                throw new Exception();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void passivateObject(PooledObject<String> obj) throws Exception {
            boolean hurl;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                hurl = this.exceptionOnPassivate;
            }
            if (hurl) {
                throw new Exception();
            }
        }

        public synchronized boolean isThrowExceptionOnActivate() {
            return this.exceptionOnActivate;
        }

        public synchronized void setThrowExceptionOnActivate(boolean b) {
            this.exceptionOnActivate = b;
        }

        public synchronized void setThrowExceptionOnDestroy(boolean b) {
            this.exceptionOnDestroy = b;
        }

        public synchronized boolean isValidationEnabled() {
            return this.enableValidation;
        }

        public synchronized void setValidationEnabled(boolean b) {
            this.enableValidation = b;
        }

        public synchronized int getMakeCounter() {
            return this.makeCounter;
        }

        private void doWait(long latency) {
            try {
                Thread.sleep(latency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class TestThread
    implements Runnable {
        private final Random _random = new Random();
        private final ObjectPool<String> _pool;
        private final int _iter;
        private final int _delay;
        private final boolean _randomDelay;
        private final Object _expectedObject;
        private volatile boolean _complete = false;
        private volatile boolean _failed = false;
        private volatile Throwable _error;

        public TestThread(ObjectPool<String> pool) {
            this(pool, 100, 50, true, null);
        }

        public TestThread(ObjectPool<String> pool, int iter) {
            this(pool, iter, 50, true, null);
        }

        public TestThread(ObjectPool<String> pool, int iter, int delay) {
            this(pool, iter, delay, true, null);
        }

        public TestThread(ObjectPool<String> pool, int iter, int delay, boolean randomDelay) {
            this(pool, iter, delay, randomDelay, null);
        }

        public TestThread(ObjectPool<String> pool, int iter, int delay, boolean randomDelay, Object obj) {
            this._pool = pool;
            this._iter = iter;
            this._delay = delay;
            this._randomDelay = randomDelay;
            this._expectedObject = obj;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this._iter; ++i) {
                long delay = this._randomDelay ? (long)this._random.nextInt(this._delay) : (long)this._delay;
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String obj = null;
                try {
                    obj = (String)this._pool.borrowObject();
                }
                catch (Exception e) {
                    this._error = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                if (this._expectedObject != null && !this._expectedObject.equals(obj)) {
                    this._error = new Throwable("Expected: " + this._expectedObject + " found: " + obj);
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this._pool.returnObject((Object)obj);
                    continue;
                }
                catch (Exception e) {
                    this._error = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
            }
            this._complete = true;
        }
    }

    private class ConcurrentBorrowAndEvictThread
    extends Thread {
        private boolean borrow;
        public String obj;

        public ConcurrentBorrowAndEvictThread(boolean borrow) {
            this.borrow = borrow;
        }

        @Override
        public void run() {
            try {
                if (this.borrow) {
                    this.obj = (String)TestGenericObjectPool.this.pool.borrowObject();
                } else {
                    TestGenericObjectPool.this.pool.evict();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class InvalidateThread
    implements Runnable {
        private final String obj;
        private final ObjectPool<String> pool;
        private boolean done = false;

        public InvalidateThread(ObjectPool<String> pool, String obj) {
            this.obj = obj;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.pool.invalidateObject((Object)this.obj);
            }
            catch (IllegalStateException ex) {
            }
            catch (Exception ex) {
                Assert.fail((String)("Unexpected exception " + ex.toString()));
            }
            finally {
                this.done = true;
            }
        }

        public boolean complete() {
            return this.done;
        }
    }

    public static class TestEvictionPolicy<T>
    implements EvictionPolicy<T> {
        private AtomicInteger callCount = new AtomicInteger(0);

        public boolean evict(EvictionConfig config, PooledObject<T> underTest, int idleCount) {
            return this.callCount.incrementAndGet() > 1500;
        }
    }
}

