/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.TrackedUse;

class PooledTestObject
implements TrackedUse {
    private static final AtomicInteger hash = new AtomicInteger();
    private boolean active = false;
    private boolean destroyed = false;
    private int _hash = hash.incrementAndGet();
    private boolean _abandoned = false;
    private boolean detached = false;

    public void destroy(DestroyMode mode) {
        this.destroyed = true;
        if (mode.equals((Object)DestroyMode.ABANDONED)) {
            this.detached = true;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PooledTestObject)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public long getLastUsed() {
        if (this._abandoned) {
            return 1L;
        }
        return 0L;
    }

    public int hashCode() {
        return this._hash;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setAbandoned(boolean b) {
        this._abandoned = b;
    }

    public synchronized void setActive(boolean b) {
        this.active = b;
    }
}

