/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.commons.pool2.impl.PooledTestObject;
import org.apache.commons.pool2.impl.TestConstants;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAbandonedKeyedObjectPool {
    private GenericKeyedObjectPool<Integer, PooledTestObject> pool = null;
    private AbandonedConfig abandonedConfig = null;

    @BeforeEach
    public void setUp() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        Assertions.assertEquals((Object)TestConstants.ONE_SECOND, (Object)this.abandonedConfig.getRemoveAbandonedTimeoutDuration());
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        Assertions.assertEquals((int)1, (int)this.abandonedConfig.getRemoveAbandonedTimeout());
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
    }

    @AfterEach
    public void tearDown() throws Exception {
        ObjectName jmxName = this.pool.getJmxName();
        String poolName = Objects.toString(jmxName, null);
        this.pool.clear();
        this.pool.close();
        this.pool = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericKeyedObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assertions.assertEquals((int)0, (int)registeredPoolCount, (String)msg.toString());
    }

    @Test
    public void testAbandonedInvalidate() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(200L, 0L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        PooledTestObject obj = null;
        for (int i = 0; i < 5; ++i) {
            obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        }
        Thread.sleep(1000L);
        this.pool.invalidateObject((Object)0, (Object)obj);
        Thread.sleep(2000L);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((long)5L, (long)this.pool.getDestroyedCount());
    }

    @Test
    public void testAbandonedReturn() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(200L, 0L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        PooledTestObject obj = null;
        for (int i = 0; i < 8; ++i) {
            obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        }
        Objects.requireNonNull(obj, "Unable to borrow object from pool");
        int deadMansHash = obj.hashCode();
        ConcurrentReturner returner = new ConcurrentReturner(obj);
        Thread.sleep(2000L);
        returner.start();
        Assertions.assertTrue((((PooledTestObject)this.pool.borrowObject((Object)0)).hashCode() != deadMansHash ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
    }

    @Test
    public void testConcurrentInvalidation() throws Exception {
        int i;
        int POOL_SIZE = 30;
        this.pool.setMaxTotalPerKey(30);
        this.pool.setMaxIdlePerKey(30);
        this.pool.setBlockWhenExhausted(false);
        ArrayList<PooledTestObject> vec = new ArrayList<PooledTestObject>();
        for (int i2 = 0; i2 < 30; ++i2) {
            vec.add((PooledTestObject)this.pool.borrowObject((Object)0));
        }
        for (PooledTestObject element : vec) {
            element.setAbandoned(true);
        }
        int CONCURRENT_BORROWS = 5;
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new ConcurrentBorrower(vec);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
        for (PooledTestObject pto : vec) {
            if (!pto.isActive()) continue;
            this.pool.returnObject((Object)0, (Object)pto);
        }
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(), (String)("numActive should have been 0, was " + this.pool.getNumActive()));
    }

    public void testDestroyModeAbandoned() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(0L, 0L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(50L));
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)obj.isDetached());
    }

    public void testDestroyModeNormal() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(0L, 0L));
        this.pool.setMaxIdlePerKey(0);
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        this.pool.returnObject((Object)0, (Object)obj);
        Assertions.assertTrue((boolean)obj.isDestroyed());
        Assertions.assertFalse((boolean)obj.isDetached());
    }

    @Test
    public void testRemoveAbandonedWhileReturning() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(0L, 1000L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        this.pool.setTestOnReturn(true);
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        Thread.sleep(50L);
        this.pool.returnObject((Object)0, (Object)obj);
        PooledTestObject obj2 = (PooledTestObject)this.pool.borrowObject((Object)0);
        Assertions.assertEquals((Object)obj, (Object)obj2);
        Assertions.assertFalse((boolean)obj2.isDestroyed());
    }

    @Test
    public void testStackTrace() throws Exception {
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setLogAbandoned(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        PrintWriter pw = new PrintWriter(bos);
        this.abandonedConfig.setLogWriter(pw);
        this.pool.setAbandonedConfig(this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        PooledTestObject o1 = (PooledTestObject)this.pool.borrowObject((Object)0);
        Thread.sleep(2000L);
        Assertions.assertTrue((boolean)o1.isDestroyed());
        bos.flush();
        Assertions.assertTrue((baos.toString().indexOf("Pooled object") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWhenExhaustedBlock() throws Exception {
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.pool.setAbandonedConfig(this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        this.pool.setMaxTotal(1);
        PooledTestObject o1 = (PooledTestObject)this.pool.borrowObject((Object)0);
        long startMillis = System.currentTimeMillis();
        PooledTestObject o2 = (PooledTestObject)this.pool.borrowObject((Object)0, 5000L);
        long endMillis = System.currentTimeMillis();
        this.pool.returnObject((Object)0, (Object)o2);
        Assertions.assertTrue((endMillis - startMillis < 5000L ? 1 : 0) != 0);
    }

    private static class SimpleFactory
    implements KeyedPooledObjectFactory<Integer, PooledTestObject> {
        private final long destroyLatency;
        private final long validateLatency;

        public SimpleFactory() {
            this.destroyLatency = 0L;
            this.validateLatency = 0L;
        }

        public SimpleFactory(long destroyLatency, long validateLatency) {
            this.destroyLatency = destroyLatency;
            this.validateLatency = validateLatency;
        }

        public void activateObject(Integer key, PooledObject<PooledTestObject> obj) {
            ((PooledTestObject)obj.getObject()).setActive(true);
        }

        public void destroyObject(Integer key, PooledObject<PooledTestObject> obj) throws Exception {
            this.destroyObject(key, obj, DestroyMode.NORMAL);
        }

        public void destroyObject(Integer key, PooledObject<PooledTestObject> obj, DestroyMode mode) throws Exception {
            ((PooledTestObject)obj.getObject()).setActive(false);
            Thread.yield();
            if (this.destroyLatency != 0L) {
                Thread.sleep(this.destroyLatency);
            }
            ((PooledTestObject)obj.getObject()).destroy(mode);
        }

        public PooledObject<PooledTestObject> makeObject(Integer key) {
            return new DefaultPooledObject((Object)new PooledTestObject());
        }

        public void passivateObject(Integer key, PooledObject<PooledTestObject> obj) {
            ((PooledTestObject)obj.getObject()).setActive(false);
        }

        public boolean validateObject(Integer key, PooledObject<PooledTestObject> obj) {
            try {
                Thread.sleep(this.validateLatency);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }

    class ConcurrentReturner
    extends Thread {
        private final PooledTestObject returned;

        public ConcurrentReturner(PooledTestObject obj) {
            this.returned = obj;
        }

        @Override
        public void run() {
            try {
                ConcurrentReturner.sleep(20L);
                TestAbandonedKeyedObjectPool.this.pool.returnObject((Object)0, (Object)this.returned);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ConcurrentBorrower
    extends Thread {
        private final ArrayList<PooledTestObject> _borrowed;

        public ConcurrentBorrower(ArrayList<PooledTestObject> borrowed) {
            this._borrowed = borrowed;
        }

        @Override
        public void run() {
            try {
                this._borrowed.add((PooledTestObject)TestAbandonedKeyedObjectPool.this.pool.borrowObject((Object)0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

