/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvictionConfig {
    @Test
    public void testConstructor1s() {
        EvictionConfig config = new EvictionConfig(Duration.ofMillis(1L), Duration.ofMillis(1L), 1);
        Assertions.assertEquals((long)1L, (long)config.getIdleEvictTime());
        Assertions.assertEquals((long)1L, (long)config.getIdleEvictTimeDuration().toMillis());
        Assertions.assertEquals((long)1L, (long)config.getIdleSoftEvictTime());
        Assertions.assertEquals((long)1L, (long)config.getIdleSoftEvictTimeDuration().toMillis());
        Assertions.assertEquals((int)1, (int)config.getMinIdle());
    }

    @Test
    public void testConstructorZerosDurations() {
        EvictionConfig config = new EvictionConfig(Duration.ZERO, Duration.ZERO, 0);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleEvictTime());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleEvictTimeDuration().toMillis());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleSoftEvictTime());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleSoftEvictTimeDuration().toMillis());
        Assertions.assertEquals((int)0, (int)config.getMinIdle());
    }

    @Test
    public void testConstructorZerosMillis() {
        EvictionConfig config = new EvictionConfig(0L, 0L, 0);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleEvictTime());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleEvictTimeDuration().toMillis());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleSoftEvictTime());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.getIdleSoftEvictTimeDuration().toMillis());
        Assertions.assertEquals((int)0, (int)config.getMinIdle());
    }
}

