/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSoftRefOutOfMemory {
    private SoftReferenceObjectPool<String> pool;

    @AfterEach
    public void tearDown() throws Exception {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
        System.gc();
    }

    @Test
    public void testOutOfMemory() throws Exception {
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new SmallPoolableObjectFactory());
        String obj = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)"1", (Object)obj);
        this.pool.returnObject((Object)obj);
        obj = null;
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
        LinkedList<byte[]> garbage = new LinkedList<byte[]>();
        Runtime runtime = Runtime.getRuntime();
        while (this.pool.getNumIdle() > 0) {
            try {
                long freeMemory = runtime.freeMemory();
                if (freeMemory > Integer.MAX_VALUE) {
                    freeMemory = Integer.MAX_VALUE;
                }
                garbage.add(new byte[Math.min(0x100000, (int)freeMemory / 2)]);
            }
            catch (OutOfMemoryError oome) {
                System.gc();
            }
            System.gc();
        }
        garbage.clear();
        System.gc();
        obj = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)"2", (Object)obj);
        this.pool.returnObject((Object)obj);
        obj = null;
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
    }

    @Test
    public void testOutOfMemory1000() throws Exception {
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new SmallPoolableObjectFactory());
        for (int i = 0; i < 1000; ++i) {
            this.pool.addObject();
        }
        String obj = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)"1000", (Object)obj);
        this.pool.returnObject((Object)obj);
        obj = null;
        Assertions.assertEquals((int)1000, (int)this.pool.getNumIdle());
        LinkedList<byte[]> garbage = new LinkedList<byte[]>();
        Runtime runtime = Runtime.getRuntime();
        while (this.pool.getNumIdle() > 0) {
            try {
                long freeMemory = runtime.freeMemory();
                if (freeMemory > Integer.MAX_VALUE) {
                    freeMemory = Integer.MAX_VALUE;
                }
                garbage.add(new byte[Math.min(0x100000, (int)freeMemory / 2)]);
            }
            catch (OutOfMemoryError oome) {
                System.gc();
            }
            System.gc();
        }
        garbage.clear();
        System.gc();
        obj = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)"1001", (Object)obj);
        this.pool.returnObject((Object)obj);
        obj = null;
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
    }

    @Test
    public void testOutOfMemoryError() throws Exception {
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new OomeFactory(OomeTrigger.CREATE));
        try {
            this.pool.borrowObject();
            Assertions.fail((String)"Expected out of memory.");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        this.pool.close();
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new OomeFactory(OomeTrigger.VALIDATE));
        try {
            this.pool.borrowObject();
            Assertions.fail((String)"Expected out of memory.");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        this.pool.close();
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new OomeFactory(OomeTrigger.DESTROY));
        try {
            this.pool.borrowObject();
            Assertions.fail((String)"Expected out of memory.");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        this.pool.close();
    }

    @Test
    public void testOutOfMemoryLarge() throws Exception {
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new LargePoolableObjectFactory(1000000));
        String obj = (String)this.pool.borrowObject();
        Assertions.assertTrue((boolean)obj.startsWith("1."));
        this.pool.returnObject((Object)obj);
        obj = null;
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
        LinkedList<byte[]> garbage = new LinkedList<byte[]>();
        Runtime runtime = Runtime.getRuntime();
        while (this.pool.getNumIdle() > 0) {
            try {
                long freeMemory = runtime.freeMemory();
                if (freeMemory > Integer.MAX_VALUE) {
                    freeMemory = Integer.MAX_VALUE;
                }
                garbage.add(new byte[Math.min(0x100000, (int)freeMemory / 2)]);
            }
            catch (OutOfMemoryError oome) {
                System.gc();
            }
            System.gc();
        }
        garbage.clear();
        System.gc();
        obj = (String)this.pool.borrowObject();
        Assertions.assertTrue((boolean)obj.startsWith("2."));
        this.pool.returnObject((Object)obj);
        obj = null;
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
    }

    public static class SmallPoolableObjectFactory
    extends BasePooledObjectFactory<String> {
        private int counter = 0;

        public String create() {
            ++this.counter;
            return new String(String.valueOf(this.counter));
        }

        public PooledObject<String> wrap(String value) {
            return new DefaultPooledObject((Object)value);
        }
    }

    private static enum OomeTrigger {
        CREATE,
        VALIDATE,
        DESTROY;

    }

    private static class OomeFactory
    extends BasePooledObjectFactory<String> {
        private final OomeTrigger trigger;

        public OomeFactory(OomeTrigger trigger) {
            this.trigger = trigger;
        }

        public String create() throws Exception {
            if (this.trigger.equals((Object)OomeTrigger.CREATE)) {
                throw new OutOfMemoryError();
            }
            return new String();
        }

        public void destroyObject(PooledObject<String> p) throws Exception {
            if (this.trigger.equals((Object)OomeTrigger.DESTROY)) {
                throw new OutOfMemoryError();
            }
            super.destroyObject(p);
        }

        public boolean validateObject(PooledObject<String> p) {
            if (this.trigger.equals((Object)OomeTrigger.VALIDATE)) {
                throw new OutOfMemoryError();
            }
            return !this.trigger.equals((Object)OomeTrigger.DESTROY);
        }

        public PooledObject<String> wrap(String value) {
            return new DefaultPooledObject((Object)value);
        }
    }

    public static class LargePoolableObjectFactory
    extends BasePooledObjectFactory<String> {
        private final String buffer;
        private int counter = 0;

        public LargePoolableObjectFactory(int size) {
            char[] data = new char[size];
            Arrays.fill(data, '.');
            this.buffer = new String(data);
        }

        public String create() {
            ++this.counter;
            return String.valueOf(this.counter) + this.buffer;
        }

        public PooledObject<String> wrap(String value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

