/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public final class ObjectPoolIssue326 {
    public static void main(String[] args) {
        try {
            new ObjectPoolIssue326().run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Task> createTasks(GenericKeyedObjectPool<Integer, Object> pool) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < 250; ++i) {
            tasks.add(new Task(pool, i));
        }
        return tasks;
    }

    private void run() throws Exception {
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxTotal(10);
        poolConfig.setMaxTotalPerKey(5);
        poolConfig.setMinIdlePerKey(-1);
        poolConfig.setMaxIdlePerKey(-1);
        poolConfig.setLifo(true);
        poolConfig.setFairness(true);
        poolConfig.setMaxWait(Duration.ofSeconds(30L));
        poolConfig.setMinEvictableIdleTime(Duration.ofMillis(-1L));
        poolConfig.setSoftMinEvictableIdleTime(Duration.ofMillis(-1L));
        poolConfig.setNumTestsPerEvictionRun(1);
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestOnBorrow(false);
        poolConfig.setTestOnReturn(false);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofSeconds(5L));
        poolConfig.setEvictionPolicyClassName(BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME);
        poolConfig.setBlockWhenExhausted(false);
        poolConfig.setJmxEnabled(false);
        poolConfig.setJmxNameBase(null);
        poolConfig.setJmxNamePrefix(null);
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ObjectFactory(), poolConfig);
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        long startTimeMillis = System.currentTimeMillis();
        long testIter = 0L;
        try {
            block2: while (true) {
                if (++testIter % 1000L == 0L) {
                    System.out.println(testIter);
                }
                List<Task> tasks = this.createTasks((GenericKeyedObjectPool<Integer, Object>)pool);
                List futures = service.invokeAll(tasks);
                Iterator iterator = futures.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Future future = iterator.next();
                    future.get();
                }
                break;
            }
        }
        catch (Throwable throwable) {
            System.out.println("Time: " + (double)(System.currentTimeMillis() - startTimeMillis) / 1000.0);
            service.shutdown();
            throw throwable;
        }
    }

    private class TestObject {
        private TestObject() {
        }
    }

    private class Task
    implements Callable<Object> {
        private final GenericKeyedObjectPool<Integer, Object> m_pool;
        private final int m_key;

        Task(GenericKeyedObjectPool<Integer, Object> pool, int count) {
            this.m_pool = pool;
            this.m_key = count % 20;
        }

        private void busyWait(long timeMillis) {
            long endTimeMillis = System.currentTimeMillis() + timeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
            }
        }

        @Override
        public Object call() throws Exception {
            try {
                Object value = this.m_pool.borrowObject((Object)this.m_key);
                this.busyWait(System.currentTimeMillis() % 4L);
                this.m_pool.returnObject((Object)this.m_key, value);
                return "success";
            }
            catch (NoSuchElementException e) {
                this.busyWait(System.currentTimeMillis() % 20L);
                return "exhausted";
            }
        }
    }

    private class ObjectFactory
    extends BaseKeyedPooledObjectFactory<Integer, Object> {
        private ObjectFactory() {
        }

        public Object create(Integer s) throws Exception {
            return new TestObject();
        }

        public PooledObject<Object> wrap(Object o) {
            return new DefaultPooledObject(o);
        }
    }
}

