/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBaseObjectPool
extends org.apache.commons.pool2.TestObjectPool {
    private ObjectPool<String> _pool;

    protected Object getNthObject(int n) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    protected boolean isFifo() {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        return false;
    }

    protected boolean isLifo() {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        return false;
    }

    protected ObjectPool<String> makeEmptyPool(int minCapacity) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    @Override
    protected ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> factory) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    @Test
    public void testBaseAddObject() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
            this._pool.addObject();
            Assertions.assertEquals((int)1, (int)this._pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
            String obj = (String)this._pool.borrowObject();
            Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj);
            Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
            Assertions.assertEquals((int)1, (int)this._pool.getNumActive());
            this._pool.returnObject((Object)obj);
            Assertions.assertEquals((int)1, (int)this._pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        finally {
            this._pool.close();
        }
    }

    @Test
    public void testBaseBorrow() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((Object)this.getNthObject(0), (Object)this._pool.borrowObject());
        Assertions.assertEquals((Object)this.getNthObject(1), (Object)this._pool.borrowObject());
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)this._pool.borrowObject());
        this._pool.close();
    }

    @Test
    public void testBaseBorrowReturn() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String obj0 = (String)this._pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj0);
        String obj1 = (String)this._pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(1), (Object)obj1);
        String obj2 = (String)this._pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this._pool.returnObject((Object)obj2);
        obj2 = (String)this._pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this._pool.returnObject((Object)obj1);
        obj1 = (String)this._pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(1), (Object)obj1);
        this._pool.returnObject((Object)obj0);
        this._pool.returnObject((Object)obj2);
        obj2 = (String)this._pool.borrowObject();
        if (this.isLifo()) {
            Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        }
        if (this.isFifo()) {
            Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj2);
        }
        obj0 = (String)this._pool.borrowObject();
        if (this.isLifo()) {
            Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj0);
        }
        if (this.isFifo()) {
            Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj0);
        }
        this._pool.close();
    }

    @Test
    public void testBaseClear() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        String obj0 = (String)this._pool.borrowObject();
        String obj1 = (String)this._pool.borrowObject();
        Assertions.assertEquals((int)2, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        this._pool.returnObject((Object)obj1);
        this._pool.returnObject((Object)obj0);
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)2, (int)this._pool.getNumIdle());
        this._pool.clear();
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        Object obj2 = this._pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this._pool.close();
    }

    @Test
    public void testBaseClosePool() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String obj = (String)this._pool.borrowObject();
        this._pool.returnObject((Object)obj);
        this._pool.close();
        try {
            this._pool.borrowObject();
            Assertions.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testBaseInvalidateObject() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        String obj0 = (String)this._pool.borrowObject();
        String obj1 = (String)this._pool.borrowObject();
        Assertions.assertEquals((int)2, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        this._pool.invalidateObject((Object)obj0);
        Assertions.assertEquals((int)1, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        this._pool.invalidateObject((Object)obj1);
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        this._pool.close();
    }

    @Test
    public void testBaseNumActiveNumIdle() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        String obj0 = (String)this._pool.borrowObject();
        Assertions.assertEquals((int)1, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        String obj1 = (String)this._pool.borrowObject();
        Assertions.assertEquals((int)2, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this._pool.getNumIdle());
        this._pool.returnObject((Object)obj1);
        Assertions.assertEquals((int)1, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)1, (int)this._pool.getNumIdle());
        this._pool.returnObject((Object)obj0);
        Assertions.assertEquals((int)0, (int)this._pool.getNumActive());
        Assertions.assertEquals((int)2, (int)this._pool.getNumIdle());
        this._pool.close();
    }

    @Test
    public void testClose() {
        TestObjectPool pool = new TestObjectPool();
        pool.close();
        pool.close();
    }

    @Test
    public void testUnsupportedOperations() throws Exception {
        if (!this.getClass().equals(TestBaseObjectPool.class)) {
            return;
        }
        try (TestObjectPool pool = new TestObjectPool();){
            Assertions.assertTrue((pool.getNumIdle() < 0 ? 1 : 0) != 0, (String)"Negative expected.");
            Assertions.assertTrue((pool.getNumActive() < 0 ? 1 : 0) != 0, (String)"Negative expected.");
            try {
                pool.clear();
                Assertions.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                pool.addObject();
                Assertions.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static class TestObjectPool
    extends BaseObjectPool<Object> {
        private TestObjectPool() {
        }

        public Object borrowObject() {
            return null;
        }

        public void invalidateObject(Object obj) {
        }

        public void returnObject(Object obj) {
        }
    }
}

