/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.proxy.ProxiedObjectPool;
import org.apache.commons.pool2.proxy.ProxySource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class BaseTestProxiedObjectPool {
    private static final String DATA1 = "data1";
    private static final Duration ABANDONED_TIMEOUT_SECS = Duration.ofSeconds(3L);
    private ObjectPool<TestObject> pool;
    private StringWriter log;

    protected abstract ProxySource<TestObject> getproxySource();

    @BeforeEach
    public void setUp() {
        this.log = new StringWriter();
        PrintWriter pw = new PrintWriter(this.log);
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setLogAbandoned(true);
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        abandonedConfig.setUseUsageTracking(true);
        abandonedConfig.setRemoveAbandonedTimeout(ABANDONED_TIMEOUT_SECS);
        abandonedConfig.setLogWriter(pw);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(3);
        TestObjectFactory factory = new TestObjectFactory();
        GenericObjectPool innerPool = new GenericObjectPool((PooledObjectFactory)factory, config, abandonedConfig);
        this.pool = new ProxiedObjectPool((ObjectPool)innerPool, this.getproxySource());
    }

    @Test
    public void testAccessAfterInvalidate() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assertions.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assertions.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.invalidateObject((Object)obj);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertThrows(IllegalStateException.class, obj::getData);
    }

    @Test
    public void testAccessAfterReturn() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assertions.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assertions.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.returnObject((Object)obj);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertThrows(IllegalStateException.class, obj::getData);
    }

    @Test
    public void testBorrowObject() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assertions.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assertions.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.returnObject((Object)obj);
    }

    @Test
    public void testPassThroughMethods01() throws Exception {
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        this.pool.addObject();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
        this.pool.clear();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
    }

    @Test
    public void testPassThroughMethods02() {
        this.pool.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.pool.addObject());
    }

    @Test
    public void testUsageTracking() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assertions.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Thread.sleep(ABANDONED_TIMEOUT_SECS.plusSeconds(2L).toMillis());
        this.pool.borrowObject();
        String logOutput = this.log.getBuffer().toString();
        Assertions.assertTrue((boolean)logOutput.contains("Pooled object created"));
        Assertions.assertTrue((boolean)logOutput.contains("The last code to use this object was"));
    }

    private static class TestObjectImpl
    implements TestObject {
        private String data;

        private TestObjectImpl() {
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public void setData(String data) {
            this.data = data;
        }
    }

    private static class TestObjectFactory
    extends BasePooledObjectFactory<TestObject> {
        private TestObjectFactory() {
        }

        public TestObject create() throws Exception {
            return new TestObjectImpl();
        }

        public PooledObject<TestObject> wrap(TestObject value) {
            return new DefaultPooledObject((Object)value);
        }
    }

    protected static interface TestObject {
        public String getData();

        public void setData(String var1);
    }
}

