/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultPooledObject {
    @Test
    public void testInitialStateActiveDuration() throws InterruptedException {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Thread.sleep(200L);
        Assertions.assertFalse((boolean)dpo.getActiveDuration().isNegative());
        Assertions.assertFalse((boolean)dpo.getActiveDuration().isZero());
        MatcherAssert.assertThat((Object)1L, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(2L)));
        MatcherAssert.assertThat((Object)Duration.ZERO, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Duration.ZERO.plusNanos(1L)));
        MatcherAssert.assertThat((Object)dpo.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)dpo.getIdleDuration()));
        MatcherAssert.assertThat((Object)dpo.getActiveDuration().toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(dpo.getActiveTimeMillis())));
        MatcherAssert.assertThat((Object)dpo.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)dpo.getActiveTime()));
        MatcherAssert.assertThat((Object)dpo.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)dpo.getIdleTime()));
        MatcherAssert.assertThat((Object)dpo.getActiveDuration().toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(dpo.getIdleTimeMillis())));
    }

    @Test
    public void testInitialStateIdleDuration() throws InterruptedException {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Thread.sleep(200L);
        Assertions.assertFalse((boolean)dpo.getIdleDuration().isNegative());
        Assertions.assertFalse((boolean)dpo.getIdleDuration().isZero());
        MatcherAssert.assertThat((Object)dpo.getIdleDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)dpo.getActiveDuration()));
        MatcherAssert.assertThat((Object)dpo.getIdleDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)dpo.getActiveTime()));
        MatcherAssert.assertThat((Object)dpo.getIdleDuration().toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(dpo.getActiveTimeMillis())));
    }

    @Test
    public void testInitialStateCreateInstant() throws InterruptedException {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Assertions.assertEquals((Object)dpo.getCreateInstant(), (Object)dpo.getLastBorrowInstant());
        Assertions.assertEquals((Object)dpo.getCreateInstant(), (Object)dpo.getLastReturnInstant());
        Assertions.assertEquals((Object)dpo.getCreateInstant(), (Object)dpo.getLastUsedInstant());
        Assertions.assertEquals((long)dpo.getCreateInstant().toEpochMilli(), (long)dpo.getCreateTime());
        Assertions.assertEquals((long)dpo.getCreateTime(), (long)dpo.getLastBorrowTime());
        Assertions.assertEquals((long)dpo.getCreateTime(), (long)dpo.getLastReturnTime());
        Assertions.assertEquals((long)dpo.getCreateTime(), (long)dpo.getLastUsedTime());
    }

    @Test
    public void testGetIdleTimeMillis() throws Exception {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        AtomicBoolean negativeIdleTimeReturned = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 3);
        Runnable allocateAndDeallocateTask = () -> {
            for (int i1 = 0; i1 < 10000; ++i1) {
                if (dpo.getIdleDuration().isNegative() || dpo.getIdleTime().isNegative()) {
                    negativeIdleTimeReturned.set(true);
                    break;
                }
                if (!dpo.getIdleDuration().isNegative() && !dpo.getIdleTime().isNegative()) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
            dpo.allocate();
            for (int i2 = 0; i2 < 10000; ++i2) {
                if (!dpo.getIdleDuration().isNegative() && !dpo.getIdleTime().isNegative()) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
            dpo.deallocate();
        };
        Runnable getIdleTimeTask = () -> {
            for (int i = 0; i < 10000; ++i) {
                if (!dpo.getIdleDuration().isNegative() && !dpo.getIdleTime().isNegative()) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
        };
        double probabilityOfAllocationTask = 0.7;
        ArrayList futures = new ArrayList();
        for (int i = 1; i <= 10000; ++i) {
            Runnable runnable = Math.random() < 0.7 ? allocateAndDeallocateTask : getIdleTimeTask;
            futures.add(executor.submit(runnable));
        }
        for (Future future : futures) {
            future.get();
        }
        Assertions.assertFalse((boolean)negativeIdleTimeReturned.get(), (String)"DefaultPooledObject.getIdleTimeMillis() returned a negative value");
    }
}

