/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.TestBaseObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;

public class TestSoftReferenceObjectPool
extends TestBaseObjectPool {
    @Override
    protected Object getNthObject(int n) {
        return String.valueOf(n);
    }

    @Override
    protected boolean isFifo() {
        return false;
    }

    @Override
    protected boolean isLifo() {
        return false;
    }

    @Override
    protected <E extends Exception> ObjectPool<String> makeEmptyPool(int cap) {
        return new SoftReferenceObjectPool((PooledObjectFactory)new SimpleFactory());
    }

    @Override
    protected <E extends Exception> ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> factory) {
        return new SoftReferenceObjectPool(factory);
    }

    private static class SimpleFactory
    extends BasePooledObjectFactory<String> {
        int counter;

        private SimpleFactory() {
        }

        public String create() {
            return String.valueOf(this.counter++);
        }

        public PooledObject<String> wrap(String value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

