/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.stream.Stream;
import org.apache.commons.pool2.impl.CallStack;
import org.apache.commons.pool2.impl.SecurityManagerCallStack;
import org.apache.commons.pool2.impl.ThrowableCallStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CallStackTest {
    private final StringWriter writer = new StringWriter();

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new ThrowableCallStack("Test", false)}), Arguments.arguments((Object[])new Object[]{new ThrowableCallStack("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", true)}), Arguments.arguments((Object[])new Object[]{new SecurityManagerCallStack("Test", false)}), Arguments.arguments((Object[])new Object[]{new SecurityManagerCallStack("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", true)}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testPrintClearedStackTraceIsNoOp(CallStack stack) {
        stack.fillInStackTrace();
        stack.clear();
        stack.printStackTrace(new PrintWriter(this.writer));
        String stackTrace = this.writer.toString();
        Assertions.assertEquals((Object)"", (Object)stackTrace);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testPrintFilledStackTrace(CallStack stack) {
        stack.fillInStackTrace();
        stack.printStackTrace(new PrintWriter(this.writer));
        String stackTrace = this.writer.toString();
        Assertions.assertTrue((boolean)stackTrace.contains(this.getClass().getName()));
    }
}

