/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestLinkedBlockingDeque {
    private static final Duration TIMEOUT_50_MILLIS = Duration.ofMillis(50L);
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;
    LinkedBlockingDeque<Integer> deque;

    @BeforeEach
    public void setUp() {
        this.deque = new LinkedBlockingDeque(2);
    }

    @Test
    public void testAdd() {
        Assertions.assertTrue((boolean)this.deque.add((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.add((Object)TWO));
        Assertions.assertThrows(IllegalStateException.class, () -> this.deque.add((Object)THREE));
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.add(null));
    }

    @Test
    public void testAddFirst() {
        this.deque.addFirst((Object)ONE);
        this.deque.addFirst((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertThrows(IllegalStateException.class, () -> this.deque.add((Object)THREE));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testAddLast() {
        this.deque.addLast((Object)ONE);
        this.deque.addLast((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertThrows(IllegalStateException.class, () -> this.deque.add((Object)THREE));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testClear() {
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        this.deque.clear();
        this.deque.add((Object)ONE);
        Assertions.assertEquals((int)1, (int)this.deque.size());
    }

    @Test
    public void testConstructors() {
        LinkedBlockingDeque deque = new LinkedBlockingDeque();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)deque.remainingCapacity());
        deque = new LinkedBlockingDeque(2);
        Assertions.assertEquals((int)2, (int)deque.remainingCapacity());
        deque = new LinkedBlockingDeque(Arrays.asList(ONE, TWO));
        Assertions.assertEquals((int)2, (int)deque.size());
        Assertions.assertThrows(NullPointerException.class, () -> new LinkedBlockingDeque(Arrays.asList(ONE, null)));
    }

    @Test
    public void testContains() {
        this.deque.add((Object)ONE);
        Assertions.assertTrue((boolean)this.deque.contains((Object)ONE));
        Assertions.assertFalse((boolean)this.deque.contains((Object)TWO));
        Assertions.assertFalse((boolean)this.deque.contains(null));
        this.deque.add((Object)TWO);
        Assertions.assertTrue((boolean)this.deque.contains((Object)TWO));
        Assertions.assertFalse((boolean)this.deque.contains((Object)THREE));
    }

    @Test
    public void testDescendingIterator() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.descendingIterator().next());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Iterator iter = this.deque.descendingIterator();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)iter.next()));
        iter.remove();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
    }

    @Test
    public void testDrainTo() {
        ArrayList c = new ArrayList();
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.drainTo(c));
        Assertions.assertEquals((int)2, (int)c.size());
        c = new ArrayList();
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((int)1, (int)this.deque.drainTo(c, 1));
        Assertions.assertEquals((int)1, (int)this.deque.size());
        Assertions.assertEquals((int)1, (int)c.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)c.iterator().next()));
    }

    @Test
    public void testElement() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.element());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.element()));
    }

    @Test
    public void testGetFirst() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.getFirst());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.getFirst()));
    }

    @Test
    public void testGetLast() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.getLast());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.getLast()));
    }

    @Test
    public void testIterator() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.iterator().next());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Iterator iter = this.deque.iterator();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        iter.remove();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)iter.next()));
    }

    @Test
    public void testOffer() {
        Assertions.assertTrue((boolean)this.deque.offer((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.offer((Object)TWO));
        Assertions.assertFalse((boolean)this.deque.offer((Object)THREE));
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.offer(null));
    }

    @Test
    public void testOfferFirst() {
        this.deque.offerFirst((Object)ONE);
        this.deque.offerFirst((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.offerFirst(null));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testOfferFirstWithTimeout() throws InterruptedException {
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.offerFirst(null, TIMEOUT_50_MILLIS));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)ONE, TIMEOUT_50_MILLIS));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)TWO, TIMEOUT_50_MILLIS));
        Assertions.assertFalse((boolean)this.deque.offerFirst((Object)THREE, TIMEOUT_50_MILLIS));
    }

    @Test
    public void testOfferLast() {
        this.deque.offerLast((Object)ONE);
        this.deque.offerLast((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.offerLast(null));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testOfferLastWithTimeout() throws InterruptedException {
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.offerLast(null, TIMEOUT_50_MILLIS));
        Assertions.assertTrue((boolean)this.deque.offerLast((Object)ONE, TIMEOUT_50_MILLIS));
        Assertions.assertTrue((boolean)this.deque.offerLast((Object)TWO, TIMEOUT_50_MILLIS));
        Assertions.assertFalse((boolean)this.deque.offerLast((Object)THREE, TIMEOUT_50_MILLIS));
    }

    @Test
    public void testOfferWithTimeout() throws InterruptedException {
        Assertions.assertTrue((boolean)this.deque.offer((Object)ONE, TIMEOUT_50_MILLIS));
        Assertions.assertTrue((boolean)this.deque.offer((Object)TWO, TIMEOUT_50_MILLIS));
        Assertions.assertFalse((boolean)this.deque.offer((Object)THREE, TIMEOUT_50_MILLIS));
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.offer(null, TIMEOUT_50_MILLIS));
    }

    @Test
    public void testPeek() {
        Assertions.assertNull((Object)this.deque.peek());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.peek()));
    }

    @Test
    public void testPeekFirst() {
        Assertions.assertNull((Object)this.deque.peekFirst());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.peekFirst()));
    }

    @Test
    public void testPeekLast() {
        Assertions.assertNull((Object)this.deque.peekLast());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.peekLast()));
    }

    @Test
    public void testPollFirst() {
        Assertions.assertNull((Object)this.deque.pollFirst());
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.pollFirst()));
    }

    @Test
    public void testPollFirstWithTimeout() throws InterruptedException {
        Assertions.assertNull((Object)this.deque.pollFirst());
        Assertions.assertNull((Object)this.deque.pollFirst(TIMEOUT_50_MILLIS));
    }

    @Test
    public void testPollLast() {
        Assertions.assertNull((Object)this.deque.pollLast());
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.pollLast()));
    }

    @Test
    public void testPollLastWithTimeout() throws InterruptedException {
        Assertions.assertNull((Object)this.deque.pollLast());
        Assertions.assertNull((Object)this.deque.pollLast(TIMEOUT_50_MILLIS));
    }

    @Test
    public void testPollWithTimeout() throws InterruptedException {
        Assertions.assertNull((Object)this.deque.poll(TIMEOUT_50_MILLIS));
        Assertions.assertNull((Object)this.deque.poll(TIMEOUT_50_MILLIS));
    }

    @Test
    public void testPop() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.pop());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.pop()));
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            this.deque.pop();
            this.deque.pop();
        });
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testPossibleBug() {
        this.deque = new LinkedBlockingDeque();
        for (int i = 0; i < 3; ++i) {
            this.deque.add((Object)i);
        }
        Iterator iter = this.deque.iterator();
        iter.next();
        this.deque.remove((Object)1);
        this.deque.remove((Object)0);
        this.deque.remove((Object)2);
        iter.next();
    }

    @Test
    public void testPush() {
        this.deque.push((Object)ONE);
        this.deque.push((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertThrows(IllegalStateException.class, () -> this.deque.push((Object)THREE));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testPut() throws InterruptedException {
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.put(null));
        this.deque.put((Object)ONE);
        this.deque.put((Object)TWO);
    }

    @Test
    public void testPutFirst() throws InterruptedException {
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.putFirst(null));
        this.deque.putFirst((Object)ONE);
        this.deque.putFirst((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testPutLast() throws InterruptedException {
        Assertions.assertThrows(NullPointerException.class, () -> this.deque.putLast(null));
        this.deque.putLast((Object)ONE);
        this.deque.putLast((Object)TWO);
        Assertions.assertEquals((int)2, (int)this.deque.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.pop()));
    }

    @Test
    public void testRemove() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.remove());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.remove()));
    }

    @Test
    public void testRemoveFirst() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.removeFirst());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.removeFirst()));
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            this.deque.removeFirst();
            this.deque.removeFirst();
        });
    }

    @Test
    public void testRemoveLast() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.deque.removeLast());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.removeLast()));
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            this.deque.removeLast();
            this.deque.removeLast();
        });
    }

    @Test
    public void testRemoveLastOccurrence() {
        Assertions.assertFalse((boolean)this.deque.removeLastOccurrence(null));
        Assertions.assertFalse((boolean)this.deque.removeLastOccurrence((Object)ONE));
        this.deque.add((Object)ONE);
        this.deque.add((Object)ONE);
        Assertions.assertTrue((boolean)this.deque.removeLastOccurrence((Object)ONE));
        Assertions.assertEquals((int)1, (int)this.deque.size());
    }

    @Test
    public void testTake() throws InterruptedException {
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.take()));
    }

    @Test
    public void testTakeFirst() throws InterruptedException {
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.deque.takeFirst()));
    }

    @Test
    public void testTakeLast() throws InterruptedException {
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assertions.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.deque.takeLast()));
    }

    @Test
    public void testToArray() {
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Object[] arr = this.deque.toArray();
        Assertions.assertEquals((Object)1, (Object)arr[0]);
        Assertions.assertEquals((Object)2, (Object)arr[1]);
        arr = this.deque.toArray((Object[])new Integer[0]);
        Assertions.assertEquals((Object)1, (Object)arr[0]);
        Assertions.assertEquals((Object)2, (Object)arr[1]);
        arr = this.deque.toArray((Object[])new Integer[0]);
        Assertions.assertEquals((Object)1, (Object)arr[0]);
        Assertions.assertEquals((Object)2, (Object)arr[1]);
    }
}

