/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolMXBean;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;

public class GenericKeyedObjectPool<K, T>
extends BaseGenericObjectPool<T>
implements KeyedObjectPool<K, T>,
GenericKeyedObjectPoolMXBean<K> {
    public static final transient int[] __cobertura_counters;
    private volatile int maxIdlePerKey;
    private volatile int minIdlePerKey;
    private volatile int maxTotalPerKey;
    private final KeyedPooledObjectFactory<K, T> factory;
    private final boolean fairness;
    private final Map<K, ObjectDeque<T>> poolMap;
    private final List<K> poolKeyList;
    private final ReadWriteLock keyLock;
    private final AtomicInteger numTotal;
    private Iterator<K> evictionKeyIterator;
    private K evictionKey;
    private static final String ONAME_BASE = "org.apache.commons.pool2:type=GenericKeyedObjectPool,name=";

    /*
     * WARNING - void declaration
     */
    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> keyedPooledObjectFactory) {
        void factory;
        int n = 0;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        this((KeyedPooledObjectFactory<K, T>)factory, new GenericKeyedObjectPoolConfig());
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> keyedPooledObjectFactory, GenericKeyedObjectPoolConfig genericKeyedObjectPoolConfig) {
        void factory;
        void config;
        int n = 0;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        super((BaseObjectPoolConfig)config, ONAME_BASE, config.getJmxNamePrefix());
        __cobertura_counters[762] = __cobertura_counters[762] + 1;
        this.maxIdlePerKey = 8;
        __cobertura_counters[763] = __cobertura_counters[763] + 1;
        this.minIdlePerKey = 0;
        __cobertura_counters[764] = __cobertura_counters[764] + 1;
        this.maxTotalPerKey = 8;
        __cobertura_counters[765] = __cobertura_counters[765] + 1;
        this.poolMap = new ConcurrentHashMap<K, ObjectDeque<T>>();
        __cobertura_counters[766] = __cobertura_counters[766] + 1;
        this.poolKeyList = new ArrayList<K>();
        __cobertura_counters[767] = __cobertura_counters[767] + 1;
        this.keyLock = new ReentrantReadWriteLock(true);
        __cobertura_counters[768] = __cobertura_counters[768] + 1;
        this.numTotal = new AtomicInteger(0);
        __cobertura_counters[769] = __cobertura_counters[769] + 1;
        this.evictionKeyIterator = null;
        __cobertura_counters[770] = __cobertura_counters[770] + 1;
        this.evictionKey = null;
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        n = 6;
        if (factory == null) {
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.jmxUnregister();
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            throw new IllegalArgumentException("factory may not be null");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
        this.factory = factory;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        this.fairness = config.getFairness();
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        this.setConfig((GenericKeyedObjectPoolConfig)config);
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        this.startEvictor(this.getTimeBetweenEvictionRunsMillis());
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
    }

    @Override
    public int getMaxTotalPerKey() {
        int n = 0;
        __cobertura_counters[14] = __cobertura_counters[14] + 1;
        return this.maxTotalPerKey;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTotalPerKey(int n) {
        void maxTotalPerKey;
        int n2 = 0;
        __cobertura_counters[15] = __cobertura_counters[15] + 1;
        this.maxTotalPerKey = maxTotalPerKey;
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
    }

    @Override
    public int getMaxIdlePerKey() {
        int n = 0;
        __cobertura_counters[17] = __cobertura_counters[17] + 1;
        return this.maxIdlePerKey;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxIdlePerKey(int n) {
        void maxIdlePerKey;
        int n2 = 0;
        __cobertura_counters[18] = __cobertura_counters[18] + 1;
        this.maxIdlePerKey = maxIdlePerKey;
        __cobertura_counters[19] = __cobertura_counters[19] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinIdlePerKey(int n) {
        void minIdlePerKey;
        int n2 = 0;
        __cobertura_counters[20] = __cobertura_counters[20] + 1;
        this.minIdlePerKey = minIdlePerKey;
        __cobertura_counters[21] = __cobertura_counters[21] + 1;
    }

    @Override
    public int getMinIdlePerKey() {
        int n = 0;
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        int maxIdlePerKeySave = this.getMaxIdlePerKey();
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        n = 25;
        if (this.minIdlePerKey > maxIdlePerKeySave) {
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
            n = 0;
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            return maxIdlePerKeySave;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        return this.minIdlePerKey;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfig(GenericKeyedObjectPoolConfig genericKeyedObjectPoolConfig) {
        void conf;
        int n = 0;
        __cobertura_counters[28] = __cobertura_counters[28] + 1;
        this.setLifo(conf.getLifo());
        __cobertura_counters[29] = __cobertura_counters[29] + 1;
        this.setMaxIdlePerKey(conf.getMaxIdlePerKey());
        __cobertura_counters[30] = __cobertura_counters[30] + 1;
        this.setMaxTotalPerKey(conf.getMaxTotalPerKey());
        __cobertura_counters[31] = __cobertura_counters[31] + 1;
        this.setMaxTotal(conf.getMaxTotal());
        __cobertura_counters[32] = __cobertura_counters[32] + 1;
        this.setMinIdlePerKey(conf.getMinIdlePerKey());
        __cobertura_counters[33] = __cobertura_counters[33] + 1;
        this.setMaxWaitMillis(conf.getMaxWaitMillis());
        __cobertura_counters[34] = __cobertura_counters[34] + 1;
        this.setBlockWhenExhausted(conf.getBlockWhenExhausted());
        __cobertura_counters[35] = __cobertura_counters[35] + 1;
        this.setTestOnCreate(conf.getTestOnCreate());
        __cobertura_counters[36] = __cobertura_counters[36] + 1;
        this.setTestOnBorrow(conf.getTestOnBorrow());
        __cobertura_counters[37] = __cobertura_counters[37] + 1;
        this.setTestOnReturn(conf.getTestOnReturn());
        __cobertura_counters[38] = __cobertura_counters[38] + 1;
        this.setTestWhileIdle(conf.getTestWhileIdle());
        __cobertura_counters[39] = __cobertura_counters[39] + 1;
        this.setNumTestsPerEvictionRun(conf.getNumTestsPerEvictionRun());
        __cobertura_counters[40] = __cobertura_counters[40] + 1;
        this.setMinEvictableIdleTimeMillis(conf.getMinEvictableIdleTimeMillis());
        __cobertura_counters[41] = __cobertura_counters[41] + 1;
        __cobertura_counters[43] = __cobertura_counters[43] + 1;
        __cobertura_counters[42] = __cobertura_counters[42] + 1;
        this.setSoftMinEvictableIdleTimeMillis(conf.getSoftMinEvictableIdleTimeMillis());
        __cobertura_counters[44] = __cobertura_counters[44] + 1;
        __cobertura_counters[46] = __cobertura_counters[46] + 1;
        __cobertura_counters[45] = __cobertura_counters[45] + 1;
        this.setTimeBetweenEvictionRunsMillis(conf.getTimeBetweenEvictionRunsMillis());
        __cobertura_counters[47] = __cobertura_counters[47] + 1;
        this.setEvictionPolicyClassName(conf.getEvictionPolicyClassName());
        __cobertura_counters[48] = __cobertura_counters[48] + 1;
    }

    public KeyedPooledObjectFactory<K, T> getFactory() {
        int n = 0;
        __cobertura_counters[49] = __cobertura_counters[49] + 1;
        return this.factory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T borrowObject(K k) throws Exception {
        void key;
        int n = 0;
        __cobertura_counters[50] = __cobertura_counters[50] + 1;
        return this.borrowObject(key, this.getMaxWaitMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public T borrowObject(K k, long l) throws Exception {
        int n;
        void key;
        int n2 = 0;
        __cobertura_counters[51] = __cobertura_counters[51] + 1;
        this.assertOpen();
        __cobertura_counters[52] = __cobertura_counters[52] + 1;
        PooledObject<T> p = null;
        __cobertura_counters[53] = __cobertura_counters[53] + 1;
        boolean blockWhenExhausted = this.getBlockWhenExhausted();
        __cobertura_counters[54] = __cobertura_counters[54] + 1;
        long waitTime = System.currentTimeMillis();
        __cobertura_counters[55] = __cobertura_counters[55] + 1;
        ObjectDeque<T> objectDeque = this.register(key);
        try {
            while (true) {
                block29: {
                    Throwable t;
                    boolean create;
                    block26: {
                        int n3 = n2;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n2 = 0;
                        __cobertura_counters[56] = __cobertura_counters[56] + 1;
                        n2 = 58;
                        if (p != null) break;
                        __cobertura_counters[57] = __cobertura_counters[57] + 1;
                        n2 = 0;
                        __cobertura_counters[59] = __cobertura_counters[59] + 1;
                        create = false;
                        __cobertura_counters[60] = __cobertura_counters[60] + 1;
                        n2 = 62;
                        if (blockWhenExhausted) {
                            __cobertura_counters[61] = __cobertura_counters[61] + 1;
                            n2 = 0;
                            __cobertura_counters[63] = __cobertura_counters[63] + 1;
                            p = objectDeque.getIdleObjects().pollFirst();
                            __cobertura_counters[64] = __cobertura_counters[64] + 1;
                            n2 = 66;
                            if (p == null) {
                                __cobertura_counters[65] = __cobertura_counters[65] + 1;
                                n2 = 0;
                                __cobertura_counters[67] = __cobertura_counters[67] + 1;
                                p = this.create(key);
                                __cobertura_counters[68] = __cobertura_counters[68] + 1;
                                n2 = 70;
                                if (p != null) {
                                    __cobertura_counters[69] = __cobertura_counters[69] + 1;
                                    n2 = 0;
                                    __cobertura_counters[71] = __cobertura_counters[71] + 1;
                                    create = true;
                                }
                            }
                            int n4 = n2;
                            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                            n2 = 0;
                            __cobertura_counters[72] = __cobertura_counters[72] + 1;
                            n2 = 74;
                            if (p == null) {
                                void borrowMaxWaitMillis;
                                __cobertura_counters[73] = __cobertura_counters[73] + 1;
                                n2 = 0;
                                __cobertura_counters[75] = __cobertura_counters[75] + 1;
                                n2 = 77;
                                if (borrowMaxWaitMillis < 0L) {
                                    __cobertura_counters[76] = __cobertura_counters[76] + 1;
                                    n2 = 0;
                                    __cobertura_counters[78] = __cobertura_counters[78] + 1;
                                    p = objectDeque.getIdleObjects().takeFirst();
                                } else {
                                    int n5 = n2;
                                    __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                                    n2 = 0;
                                    __cobertura_counters[79] = __cobertura_counters[79] + 1;
                                    p = objectDeque.getIdleObjects().pollFirst((long)borrowMaxWaitMillis, TimeUnit.MILLISECONDS);
                                }
                            }
                            int n6 = n2;
                            __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                            n2 = 0;
                            __cobertura_counters[80] = __cobertura_counters[80] + 1;
                            n2 = 82;
                            if (p == null) {
                                __cobertura_counters[81] = __cobertura_counters[81] + 1;
                                n2 = 0;
                                __cobertura_counters[83] = __cobertura_counters[83] + 1;
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            int n7 = n2;
                            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                            n2 = 0;
                            __cobertura_counters[84] = __cobertura_counters[84] + 1;
                            n2 = 86;
                            if (!p.allocate()) {
                                __cobertura_counters[85] = __cobertura_counters[85] + 1;
                                n2 = 0;
                                __cobertura_counters[87] = __cobertura_counters[87] + 1;
                                p = null;
                            }
                        } else {
                            int n8 = n2;
                            __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                            n2 = 0;
                            __cobertura_counters[88] = __cobertura_counters[88] + 1;
                            p = objectDeque.getIdleObjects().pollFirst();
                            __cobertura_counters[89] = __cobertura_counters[89] + 1;
                            n2 = 91;
                            if (p == null) {
                                __cobertura_counters[90] = __cobertura_counters[90] + 1;
                                n2 = 0;
                                __cobertura_counters[92] = __cobertura_counters[92] + 1;
                                p = this.create(key);
                                __cobertura_counters[93] = __cobertura_counters[93] + 1;
                                n2 = 95;
                                if (p != null) {
                                    __cobertura_counters[94] = __cobertura_counters[94] + 1;
                                    n2 = 0;
                                    __cobertura_counters[96] = __cobertura_counters[96] + 1;
                                    create = true;
                                }
                            }
                            int n9 = n2;
                            __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                            n2 = 0;
                            __cobertura_counters[97] = __cobertura_counters[97] + 1;
                            n2 = 99;
                            if (p == null) {
                                __cobertura_counters[98] = __cobertura_counters[98] + 1;
                                n2 = 0;
                                __cobertura_counters[100] = __cobertura_counters[100] + 1;
                                throw new NoSuchElementException("Pool exhausted");
                            }
                            int n10 = n2;
                            __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                            n2 = 0;
                            __cobertura_counters[101] = __cobertura_counters[101] + 1;
                            n2 = 103;
                            if (!p.allocate()) {
                                __cobertura_counters[102] = __cobertura_counters[102] + 1;
                                n2 = 0;
                                __cobertura_counters[104] = __cobertura_counters[104] + 1;
                                p = null;
                            }
                        }
                        int n11 = n2;
                        __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                        n2 = 0;
                        __cobertura_counters[105] = __cobertura_counters[105] + 1;
                        n2 = 107;
                        if (p == null) continue;
                        __cobertura_counters[106] = __cobertura_counters[106] + 1;
                        n2 = 0;
                        try {
                            __cobertura_counters[108] = __cobertura_counters[108] + 1;
                            this.factory.activateObject(key, p);
                        }
                        catch (Exception exception) {
                            __cobertura_counters[109] = __cobertura_counters[109] + 1;
                            Exception e = exception;
                            try {
                                __cobertura_counters[110] = __cobertura_counters[110] + 1;
                                this.destroy(key, p, true);
                            }
                            catch (Exception exception2) {
                                __cobertura_counters[111] = __cobertura_counters[111] + 1;
                                Exception exception3 = exception2;
                            }
                            __cobertura_counters[112] = __cobertura_counters[112] + 1;
                            __cobertura_counters[113] = __cobertura_counters[113] + 1;
                            p = null;
                            __cobertura_counters[114] = __cobertura_counters[114] + 1;
                            n2 = 116;
                            if (!create) break block26;
                            __cobertura_counters[115] = __cobertura_counters[115] + 1;
                            n2 = 0;
                            __cobertura_counters[117] = __cobertura_counters[117] + 1;
                            NoSuchElementException nsee = new NoSuchElementException("Unable to activate object");
                            __cobertura_counters[118] = __cobertura_counters[118] + 1;
                            nsee.initCause(e);
                            __cobertura_counters[119] = __cobertura_counters[119] + 1;
                            throw nsee;
                        }
                        __cobertura_counters[120] = __cobertura_counters[120] + 1;
                    }
                    int n12 = n2;
                    __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
                    n2 = 0;
                    __cobertura_counters[121] = __cobertura_counters[121] + 1;
                    n2 = 123;
                    if (p == null) continue;
                    __cobertura_counters[122] = __cobertura_counters[122] + 1;
                    n2 = 0;
                    n2 = 125;
                    if (!this.getTestOnBorrow()) {
                        __cobertura_counters[124] = __cobertura_counters[124] + 1;
                        n2 = 0;
                        n2 = 127;
                        if (!create) continue;
                        __cobertura_counters[126] = __cobertura_counters[126] + 1;
                        n2 = 0;
                        n2 = 129;
                        if (!this.getTestOnCreate()) continue;
                        __cobertura_counters[128] = __cobertura_counters[128] + 1;
                        n2 = 0;
                    }
                    int n13 = n2;
                    __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
                    n2 = 0;
                    __cobertura_counters[130] = __cobertura_counters[130] + 1;
                    boolean validate = false;
                    __cobertura_counters[131] = __cobertura_counters[131] + 1;
                    Throwable validationThrowable = null;
                    try {
                        __cobertura_counters[132] = __cobertura_counters[132] + 1;
                        validate = this.factory.validateObject(key, p);
                    }
                    catch (Throwable throwable) {
                        __cobertura_counters[133] = __cobertura_counters[133] + 1;
                        t = throwable;
                        __cobertura_counters[134] = __cobertura_counters[134] + 1;
                        PoolUtils.checkRethrow(t);
                        __cobertura_counters[135] = __cobertura_counters[135] + 1;
                        validationThrowable = t;
                    }
                    __cobertura_counters[136] = __cobertura_counters[136] + 1;
                    __cobertura_counters[137] = __cobertura_counters[137] + 1;
                    n2 = 139;
                    if (validate) break block29;
                    __cobertura_counters[138] = __cobertura_counters[138] + 1;
                    n2 = 0;
                    try {
                        __cobertura_counters[140] = __cobertura_counters[140] + 1;
                        this.destroy(key, p, true);
                        __cobertura_counters[141] = __cobertura_counters[141] + 1;
                        this.destroyedByBorrowValidationCount.incrementAndGet();
                    }
                    catch (Exception exception) {
                        __cobertura_counters[142] = __cobertura_counters[142] + 1;
                        t = exception;
                    }
                    __cobertura_counters[143] = __cobertura_counters[143] + 1;
                    __cobertura_counters[144] = __cobertura_counters[144] + 1;
                    p = null;
                    __cobertura_counters[145] = __cobertura_counters[145] + 1;
                    n2 = 147;
                    if (create) {
                        __cobertura_counters[146] = __cobertura_counters[146] + 1;
                        n2 = 0;
                        __cobertura_counters[148] = __cobertura_counters[148] + 1;
                        NoSuchElementException nsee = new NoSuchElementException("Unable to validate object");
                        __cobertura_counters[149] = __cobertura_counters[149] + 1;
                        nsee.initCause(validationThrowable);
                        __cobertura_counters[150] = __cobertura_counters[150] + 1;
                        throw nsee;
                    }
                }
                int n14 = n2;
                __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
                n2 = 0;
                __cobertura_counters[151] = __cobertura_counters[151] + 1;
            }
            n = n2;
        }
        catch (Throwable throwable) {
            __cobertura_counters[152] = __cobertura_counters[152] + 1;
            Throwable throwable2 = throwable;
            this.deregister(key);
            throw throwable2;
        }
        __cobertura_counters[n] = __cobertura_counters[n] + 1;
        n2 = 0;
        __cobertura_counters[152] = __cobertura_counters[152] + 1;
        this.deregister(key);
        __cobertura_counters[153] = __cobertura_counters[153] + 1;
        __cobertura_counters[154] = __cobertura_counters[154] + 1;
        this.updateStatsBorrow(p, System.currentTimeMillis() - waitTime);
        __cobertura_counters[155] = __cobertura_counters[155] + 1;
        return p.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void returnObject(K k, T t) {
        long activeTime;
        int n;
        block31: {
            LinkedBlockingDeque<PooledObject<T>> idleObjects;
            PooledObject<T> p;
            void key;
            block30: {
                block29: {
                    ObjectDeque<T> objectDeque;
                    block26: {
                        Exception e;
                        void obj;
                        n = 0;
                        __cobertura_counters[156] = __cobertura_counters[156] + 1;
                        objectDeque = this.poolMap.get(key);
                        __cobertura_counters[157] = __cobertura_counters[157] + 1;
                        p = objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<void>(obj));
                        __cobertura_counters[158] = __cobertura_counters[158] + 1;
                        n = 160;
                        if (p == null) {
                            __cobertura_counters[159] = __cobertura_counters[159] + 1;
                            n = 0;
                            __cobertura_counters[161] = __cobertura_counters[161] + 1;
                            throw new IllegalStateException("Returned object not currently part of this pool");
                        }
                        int n2 = n;
                        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                        n = 0;
                        __cobertura_counters[162] = __cobertura_counters[162] + 1;
                        PooledObject<T> pooledObject = p;
                        synchronized (pooledObject) {
                            __cobertura_counters[163] = __cobertura_counters[163] + 1;
                            PooledObjectState state = p.getState();
                            __cobertura_counters[164] = __cobertura_counters[164] + 1;
                            n = 166;
                            if (state != PooledObjectState.ALLOCATED) {
                                __cobertura_counters[165] = __cobertura_counters[165] + 1;
                                n = 0;
                                __cobertura_counters[167] = __cobertura_counters[167] + 1;
                                throw new IllegalStateException("Object has already been returned to this pool or is invalid");
                            }
                            int n3 = n;
                            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                            n = 0;
                            __cobertura_counters[168] = __cobertura_counters[168] + 1;
                            p.markReturning();
                            __cobertura_counters[169] = __cobertura_counters[169] + 1;
                        }
                        __cobertura_counters[170] = __cobertura_counters[170] + 1;
                        activeTime = p.getActiveTimeMillis();
                        __cobertura_counters[171] = __cobertura_counters[171] + 1;
                        n = 173;
                        if (!this.getTestOnReturn()) break block26;
                        __cobertura_counters[172] = __cobertura_counters[172] + 1;
                        n = 0;
                        __cobertura_counters[174] = __cobertura_counters[174] + 1;
                        n = 176;
                        if (this.factory.validateObject(key, p)) break block26;
                        __cobertura_counters[175] = __cobertura_counters[175] + 1;
                        n = 0;
                        try {
                            __cobertura_counters[177] = __cobertura_counters[177] + 1;
                            this.destroy(key, p, true);
                        }
                        catch (Exception exception) {
                            __cobertura_counters[178] = __cobertura_counters[178] + 1;
                            e = exception;
                            __cobertura_counters[179] = __cobertura_counters[179] + 1;
                            this.swallowException(e);
                        }
                        __cobertura_counters[180] = __cobertura_counters[180] + 1;
                        __cobertura_counters[181] = __cobertura_counters[181] + 1;
                        n = 183;
                        if (ObjectDeque.access$000(objectDeque).hasTakeWaiters()) {
                            __cobertura_counters[182] = __cobertura_counters[182] + 1;
                            n = 0;
                            try {
                                __cobertura_counters[184] = __cobertura_counters[184] + 1;
                                this.addObject(key);
                            }
                            catch (Exception exception) {
                                __cobertura_counters[185] = __cobertura_counters[185] + 1;
                                e = exception;
                                __cobertura_counters[186] = __cobertura_counters[186] + 1;
                                this.swallowException(e);
                            }
                            __cobertura_counters[187] = __cobertura_counters[187] + 1;
                        }
                        int n4 = n;
                        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                        n = 0;
                        __cobertura_counters[188] = __cobertura_counters[188] + 1;
                        this.updateStatsReturn(activeTime);
                        __cobertura_counters[189] = __cobertura_counters[189] + 1;
                        return;
                    }
                    try {
                        int n5 = n;
                        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                        n = 0;
                        __cobertura_counters[190] = __cobertura_counters[190] + 1;
                        this.factory.passivateObject(key, p);
                    }
                    catch (Exception exception) {
                        Exception e;
                        __cobertura_counters[191] = __cobertura_counters[191] + 1;
                        Exception e1 = exception;
                        __cobertura_counters[192] = __cobertura_counters[192] + 1;
                        this.swallowException(e1);
                        try {
                            __cobertura_counters[193] = __cobertura_counters[193] + 1;
                            this.destroy(key, p, true);
                        }
                        catch (Exception exception2) {
                            __cobertura_counters[194] = __cobertura_counters[194] + 1;
                            e = exception2;
                            __cobertura_counters[195] = __cobertura_counters[195] + 1;
                            this.swallowException(e);
                        }
                        __cobertura_counters[196] = __cobertura_counters[196] + 1;
                        __cobertura_counters[197] = __cobertura_counters[197] + 1;
                        n = 199;
                        if (ObjectDeque.access$000(objectDeque).hasTakeWaiters()) {
                            __cobertura_counters[198] = __cobertura_counters[198] + 1;
                            n = 0;
                            try {
                                __cobertura_counters[200] = __cobertura_counters[200] + 1;
                                this.addObject(key);
                            }
                            catch (Exception exception3) {
                                __cobertura_counters[201] = __cobertura_counters[201] + 1;
                                e = exception3;
                                __cobertura_counters[202] = __cobertura_counters[202] + 1;
                                this.swallowException(e);
                            }
                            __cobertura_counters[203] = __cobertura_counters[203] + 1;
                        }
                        int n6 = n;
                        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                        n = 0;
                        __cobertura_counters[204] = __cobertura_counters[204] + 1;
                        this.updateStatsReturn(activeTime);
                        __cobertura_counters[205] = __cobertura_counters[205] + 1;
                        return;
                    }
                    __cobertura_counters[206] = __cobertura_counters[206] + 1;
                    __cobertura_counters[207] = __cobertura_counters[207] + 1;
                    n = 209;
                    if (!p.deallocate()) {
                        __cobertura_counters[208] = __cobertura_counters[208] + 1;
                        n = 0;
                        __cobertura_counters[210] = __cobertura_counters[210] + 1;
                        throw new IllegalStateException("Object has already been returned to this pool");
                    }
                    int n7 = n;
                    __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                    n = 0;
                    __cobertura_counters[211] = __cobertura_counters[211] + 1;
                    int maxIdle = this.getMaxIdlePerKey();
                    __cobertura_counters[212] = __cobertura_counters[212] + 1;
                    __cobertura_counters[213] = __cobertura_counters[213] + 1;
                    idleObjects = objectDeque.getIdleObjects();
                    __cobertura_counters[214] = __cobertura_counters[214] + 1;
                    n = 216;
                    if (this.isClosed()) break block29;
                    __cobertura_counters[215] = __cobertura_counters[215] + 1;
                    n = 0;
                    n = 218;
                    if (maxIdle <= -1) break block30;
                    __cobertura_counters[217] = __cobertura_counters[217] + 1;
                    n = 0;
                    n = 220;
                    if (maxIdle > idleObjects.size()) break block30;
                    __cobertura_counters[219] = __cobertura_counters[219] + 1;
                    n = 0;
                }
                try {
                    int n8 = n;
                    __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                    n = 0;
                    __cobertura_counters[221] = __cobertura_counters[221] + 1;
                    this.destroy(key, p, true);
                }
                catch (Exception exception) {
                    __cobertura_counters[222] = __cobertura_counters[222] + 1;
                    Exception e = exception;
                    __cobertura_counters[223] = __cobertura_counters[223] + 1;
                    this.swallowException(e);
                    __cobertura_counters[225] = __cobertura_counters[225] + 1;
                }
                __cobertura_counters[224] = __cobertura_counters[224] + 1;
                break block31;
                break block31;
            }
            int n9 = n;
            __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
            n = 0;
            __cobertura_counters[226] = __cobertura_counters[226] + 1;
            n = 228;
            if (this.getLifo()) {
                __cobertura_counters[227] = __cobertura_counters[227] + 1;
                n = 0;
                __cobertura_counters[229] = __cobertura_counters[229] + 1;
                idleObjects.addFirst(p);
            } else {
                int n10 = n;
                __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                n = 0;
                __cobertura_counters[230] = __cobertura_counters[230] + 1;
                idleObjects.addLast(p);
            }
            __cobertura_counters[231] = __cobertura_counters[231] + 1;
            n = 233;
            if (this.isClosed()) {
                __cobertura_counters[232] = __cobertura_counters[232] + 1;
                n = 0;
                __cobertura_counters[234] = __cobertura_counters[234] + 1;
                this.clear(key);
            }
        }
        int n11 = n;
        __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
        n = 0;
        __cobertura_counters[235] = __cobertura_counters[235] + 1;
        n = 237;
        if (this.hasBorrowWaiters()) {
            __cobertura_counters[236] = __cobertura_counters[236] + 1;
            n = 0;
            __cobertura_counters[238] = __cobertura_counters[238] + 1;
            this.reuseCapacity();
        }
        int n12 = n;
        __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
        n = 0;
        __cobertura_counters[239] = __cobertura_counters[239] + 1;
        this.updateStatsReturn(activeTime);
        __cobertura_counters[240] = __cobertura_counters[240] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void invalidateObject(K k, T t) throws Exception {
        void obj;
        void key;
        int n = 0;
        __cobertura_counters[241] = __cobertura_counters[241] + 1;
        ObjectDeque<T> objectDeque = this.poolMap.get(key);
        __cobertura_counters[242] = __cobertura_counters[242] + 1;
        PooledObject<T> p = objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<void>(obj));
        __cobertura_counters[243] = __cobertura_counters[243] + 1;
        n = 245;
        if (p == null) {
            __cobertura_counters[244] = __cobertura_counters[244] + 1;
            n = 0;
            __cobertura_counters[246] = __cobertura_counters[246] + 1;
            throw new IllegalStateException("Object not currently part of this pool");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[247] = __cobertura_counters[247] + 1;
        PooledObject<T> pooledObject = p;
        synchronized (pooledObject) {
            __cobertura_counters[248] = __cobertura_counters[248] + 1;
            n = 250;
            if (p.getState() != PooledObjectState.INVALID) {
                __cobertura_counters[249] = __cobertura_counters[249] + 1;
                n = 0;
                __cobertura_counters[251] = __cobertura_counters[251] + 1;
                this.destroy(key, p, true);
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[252] = __cobertura_counters[252] + 1;
        }
        __cobertura_counters[253] = __cobertura_counters[253] + 1;
        n = 255;
        if (ObjectDeque.access$000(objectDeque).hasTakeWaiters()) {
            __cobertura_counters[254] = __cobertura_counters[254] + 1;
            n = 0;
            __cobertura_counters[256] = __cobertura_counters[256] + 1;
            this.addObject(key);
        }
        int n4 = n;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n = 0;
        __cobertura_counters[257] = __cobertura_counters[257] + 1;
    }

    @Override
    public void clear() {
        int n = 0;
        __cobertura_counters[258] = __cobertura_counters[258] + 1;
        Iterator<K> iter = this.poolMap.keySet().iterator();
        while (true) {
            __cobertura_counters[259] = __cobertura_counters[259] + 1;
            n = 261;
            if (!iter.hasNext()) break;
            __cobertura_counters[260] = __cobertura_counters[260] + 1;
            n = 0;
            __cobertura_counters[262] = __cobertura_counters[262] + 1;
            this.clear(iter.next());
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[263] = __cobertura_counters[263] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void clear(K k) {
        int n;
        void key;
        int n2 = 0;
        __cobertura_counters[264] = __cobertura_counters[264] + 1;
        ObjectDeque<T> objectDeque = this.register(key);
        try {
            __cobertura_counters[265] = __cobertura_counters[265] + 1;
            __cobertura_counters[266] = __cobertura_counters[266] + 1;
            LinkedBlockingDeque<PooledObject<T>> idleObjects = objectDeque.getIdleObjects();
            __cobertura_counters[267] = __cobertura_counters[267] + 1;
            PooledObject<T> p = idleObjects.poll();
            while (true) {
                __cobertura_counters[268] = __cobertura_counters[268] + 1;
                n2 = 270;
                if (p == null) break;
                __cobertura_counters[269] = __cobertura_counters[269] + 1;
                n2 = 0;
                try {
                    __cobertura_counters[271] = __cobertura_counters[271] + 1;
                    this.destroy(key, p, true);
                }
                catch (Exception exception) {
                    __cobertura_counters[272] = __cobertura_counters[272] + 1;
                    Exception e = exception;
                    __cobertura_counters[273] = __cobertura_counters[273] + 1;
                    this.swallowException(e);
                }
                __cobertura_counters[274] = __cobertura_counters[274] + 1;
                __cobertura_counters[275] = __cobertura_counters[275] + 1;
                p = idleObjects.poll();
            }
            n = n2;
        }
        catch (Throwable throwable) {
            __cobertura_counters[276] = __cobertura_counters[276] + 1;
            Throwable throwable2 = throwable;
            this.deregister(key);
            throw throwable2;
        }
        __cobertura_counters[n] = __cobertura_counters[n] + 1;
        n2 = 0;
        __cobertura_counters[276] = __cobertura_counters[276] + 1;
        this.deregister(key);
        __cobertura_counters[277] = __cobertura_counters[277] + 1;
        __cobertura_counters[278] = __cobertura_counters[278] + 1;
    }

    @Override
    public int getNumActive() {
        int n = 0;
        __cobertura_counters[279] = __cobertura_counters[279] + 1;
        return this.numTotal.get() - this.getNumIdle();
    }

    @Override
    public int getNumIdle() {
        int n = 0;
        __cobertura_counters[280] = __cobertura_counters[280] + 1;
        Iterator<ObjectDeque<T>> iter = this.poolMap.values().iterator();
        __cobertura_counters[281] = __cobertura_counters[281] + 1;
        int result = 0;
        while (true) {
            __cobertura_counters[282] = __cobertura_counters[282] + 1;
            n = 284;
            if (!iter.hasNext()) break;
            __cobertura_counters[283] = __cobertura_counters[283] + 1;
            n = 0;
            __cobertura_counters[285] = __cobertura_counters[285] + 1;
            result += iter.next().getIdleObjects().size();
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[286] = __cobertura_counters[286] + 1;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNumActive(K k) {
        void key;
        int n = 0;
        __cobertura_counters[287] = __cobertura_counters[287] + 1;
        ObjectDeque<T> objectDeque = this.poolMap.get(key);
        __cobertura_counters[288] = __cobertura_counters[288] + 1;
        n = 290;
        if (objectDeque != null) {
            __cobertura_counters[289] = __cobertura_counters[289] + 1;
            n = 0;
            __cobertura_counters[291] = __cobertura_counters[291] + 1;
            __cobertura_counters[292] = __cobertura_counters[292] + 1;
            return objectDeque.getAllObjects().size() - objectDeque.getIdleObjects().size();
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[293] = __cobertura_counters[293] + 1;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNumIdle(K k) {
        int n;
        void key;
        int n2 = 0;
        __cobertura_counters[294] = __cobertura_counters[294] + 1;
        ObjectDeque<T> objectDeque = this.poolMap.get(key);
        __cobertura_counters[295] = __cobertura_counters[295] + 1;
        n2 = 297;
        if (objectDeque != null) {
            __cobertura_counters[296] = __cobertura_counters[296] + 1;
            n2 = 0;
            n = objectDeque.getIdleObjects().size();
        } else {
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int n = 0;
        __cobertura_counters[298] = __cobertura_counters[298] + 1;
        n = 300;
        if (this.isClosed()) {
            __cobertura_counters[299] = __cobertura_counters[299] + 1;
            n = 0;
            __cobertura_counters[301] = __cobertura_counters[301] + 1;
            return;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[302] = __cobertura_counters[302] + 1;
        Object object = this.closeLock;
        synchronized (object) {
            __cobertura_counters[303] = __cobertura_counters[303] + 1;
            n = 305;
            if (this.isClosed()) {
                __cobertura_counters[304] = __cobertura_counters[304] + 1;
                n = 0;
                __cobertura_counters[306] = __cobertura_counters[306] + 1;
                return;
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[307] = __cobertura_counters[307] + 1;
            this.startEvictor(-1L);
            __cobertura_counters[308] = __cobertura_counters[308] + 1;
            this.closed = true;
            __cobertura_counters[309] = __cobertura_counters[309] + 1;
            this.clear();
            __cobertura_counters[310] = __cobertura_counters[310] + 1;
            this.jmxUnregister();
            __cobertura_counters[311] = __cobertura_counters[311] + 1;
            Iterator<ObjectDeque<T>> iter = this.poolMap.values().iterator();
            while (true) {
                __cobertura_counters[312] = __cobertura_counters[312] + 1;
                n = 314;
                if (!iter.hasNext()) break;
                __cobertura_counters[313] = __cobertura_counters[313] + 1;
                n = 0;
                __cobertura_counters[315] = __cobertura_counters[315] + 1;
                iter.next().getIdleObjects().interuptTakeWaiters();
            }
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[316] = __cobertura_counters[316] + 1;
            this.clear();
            __cobertura_counters[317] = __cobertura_counters[317] + 1;
        }
        __cobertura_counters[318] = __cobertura_counters[318] + 1;
    }

    public void clearOldest() {
        int n = 0;
        __cobertura_counters[319] = __cobertura_counters[319] + 1;
        TreeMap<PooledObject<T>, K> map = new TreeMap<PooledObject<T>, K>();
        __cobertura_counters[320] = __cobertura_counters[320] + 1;
        Iterator<K> iterator = this.poolMap.keySet().iterator();
        while (true) {
            n = 322;
            if (!iterator.hasNext()) break;
            __cobertura_counters[321] = __cobertura_counters[321] + 1;
            n = 0;
            K k = iterator.next();
            __cobertura_counters[323] = __cobertura_counters[323] + 1;
            ObjectDeque<T> queue = this.poolMap.get(k);
            __cobertura_counters[324] = __cobertura_counters[324] + 1;
            n = 326;
            if (queue != null) {
                __cobertura_counters[325] = __cobertura_counters[325] + 1;
                n = 0;
                __cobertura_counters[327] = __cobertura_counters[327] + 1;
                __cobertura_counters[328] = __cobertura_counters[328] + 1;
                LinkedBlockingDeque<PooledObject<T>> idleObjects = queue.getIdleObjects();
                __cobertura_counters[329] = __cobertura_counters[329] + 1;
                Iterator<PooledObject<T>> iterator2 = idleObjects.iterator();
                while (true) {
                    n = 331;
                    if (!iterator2.hasNext()) break;
                    __cobertura_counters[330] = __cobertura_counters[330] + 1;
                    n = 0;
                    PooledObject<T> p = iterator2.next();
                    __cobertura_counters[332] = __cobertura_counters[332] + 1;
                    map.put(p, k);
                    __cobertura_counters[333] = __cobertura_counters[333] + 1;
                }
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[334] = __cobertura_counters[334] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[335] = __cobertura_counters[335] + 1;
        int itemsToRemove = (int)((double)map.size() * 0.15) + 1;
        __cobertura_counters[336] = __cobertura_counters[336] + 1;
        __cobertura_counters[337] = __cobertura_counters[337] + 1;
        Iterator iter = map.entrySet().iterator();
        while (true) {
            __cobertura_counters[338] = __cobertura_counters[338] + 1;
            n = 340;
            if (!iter.hasNext()) break;
            __cobertura_counters[339] = __cobertura_counters[339] + 1;
            n = 0;
            n = 342;
            if (itemsToRemove <= 0) break;
            __cobertura_counters[341] = __cobertura_counters[341] + 1;
            n = 0;
            __cobertura_counters[343] = __cobertura_counters[343] + 1;
            Map.Entry entry = iter.next();
            __cobertura_counters[344] = __cobertura_counters[344] + 1;
            Object key = entry.getValue();
            __cobertura_counters[345] = __cobertura_counters[345] + 1;
            PooledObject p = (PooledObject)entry.getKey();
            __cobertura_counters[346] = __cobertura_counters[346] + 1;
            boolean destroyed = true;
            try {
                __cobertura_counters[347] = __cobertura_counters[347] + 1;
                destroyed = this.destroy(key, p, false);
            }
            catch (Exception exception) {
                __cobertura_counters[348] = __cobertura_counters[348] + 1;
                Exception e = exception;
                __cobertura_counters[349] = __cobertura_counters[349] + 1;
                this.swallowException(e);
            }
            __cobertura_counters[350] = __cobertura_counters[350] + 1;
            __cobertura_counters[351] = __cobertura_counters[351] + 1;
            n = 353;
            if (destroyed) {
                __cobertura_counters[352] = __cobertura_counters[352] + 1;
                n = 0;
                __cobertura_counters[354] = __cobertura_counters[354] + 1;
                --itemsToRemove;
            }
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[355] = __cobertura_counters[355] + 1;
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[356] = __cobertura_counters[356] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reuseCapacity() {
        int n = 0;
        __cobertura_counters[357] = __cobertura_counters[357] + 1;
        int maxTotalPerKeySave = this.getMaxTotalPerKey();
        __cobertura_counters[358] = __cobertura_counters[358] + 1;
        int maxQueueLength = 0;
        __cobertura_counters[359] = __cobertura_counters[359] + 1;
        LinkedBlockingDeque<PooledObject<T>> mostLoaded = null;
        __cobertura_counters[360] = __cobertura_counters[360] + 1;
        K loadedKey = null;
        __cobertura_counters[361] = __cobertura_counters[361] + 1;
        Iterator<K> iterator = this.poolMap.keySet().iterator();
        while (true) {
            n = 363;
            if (!iterator.hasNext()) break;
            __cobertura_counters[362] = __cobertura_counters[362] + 1;
            n = 0;
            K k = iterator.next();
            __cobertura_counters[364] = __cobertura_counters[364] + 1;
            ObjectDeque<T> deque = this.poolMap.get(k);
            __cobertura_counters[365] = __cobertura_counters[365] + 1;
            n = 367;
            if (deque != null) {
                __cobertura_counters[366] = __cobertura_counters[366] + 1;
                n = 0;
                __cobertura_counters[368] = __cobertura_counters[368] + 1;
                LinkedBlockingDeque<PooledObject<T>> pool = deque.getIdleObjects();
                __cobertura_counters[369] = __cobertura_counters[369] + 1;
                int queueLength = pool.getTakeQueueLength();
                __cobertura_counters[370] = __cobertura_counters[370] + 1;
                n = 372;
                if (this.getNumActive(k) < maxTotalPerKeySave) {
                    __cobertura_counters[371] = __cobertura_counters[371] + 1;
                    n = 0;
                    n = 374;
                    if (queueLength > maxQueueLength) {
                        __cobertura_counters[373] = __cobertura_counters[373] + 1;
                        n = 0;
                        __cobertura_counters[375] = __cobertura_counters[375] + 1;
                        maxQueueLength = queueLength;
                        __cobertura_counters[376] = __cobertura_counters[376] + 1;
                        mostLoaded = pool;
                        __cobertura_counters[377] = __cobertura_counters[377] + 1;
                        loadedKey = k;
                    }
                }
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[378] = __cobertura_counters[378] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[379] = __cobertura_counters[379] + 1;
        n = 381;
        if (mostLoaded != null) {
            int n4;
            __cobertura_counters[380] = __cobertura_counters[380] + 1;
            n = 0;
            __cobertura_counters[382] = __cobertura_counters[382] + 1;
            this.register(loadedKey);
            try {
                __cobertura_counters[383] = __cobertura_counters[383] + 1;
                PooledObject<T> p = this.create(loadedKey);
                __cobertura_counters[384] = __cobertura_counters[384] + 1;
                n = 386;
                if (p != null) {
                    __cobertura_counters[385] = __cobertura_counters[385] + 1;
                    n = 0;
                    __cobertura_counters[387] = __cobertura_counters[387] + 1;
                    this.addIdleObject(loadedKey, p);
                }
                n4 = n;
            }
            catch (Exception exception) {
                try {
                    __cobertura_counters[388] = __cobertura_counters[388] + 1;
                    Exception e = exception;
                    __cobertura_counters[389] = __cobertura_counters[389] + 1;
                    this.swallowException(e);
                }
                catch (Throwable throwable) {
                    __cobertura_counters[390] = __cobertura_counters[390] + 1;
                    Throwable throwable2 = throwable;
                    this.deregister(loadedKey);
                    throw throwable2;
                }
                __cobertura_counters[390] = __cobertura_counters[390] + 1;
                this.deregister(loadedKey);
                __cobertura_counters[392] = __cobertura_counters[392] + 1;
            }
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[390] = __cobertura_counters[390] + 1;
            this.deregister(loadedKey);
            __cobertura_counters[391] = __cobertura_counters[391] + 1;
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[393] = __cobertura_counters[393] + 1;
    }

    private boolean hasBorrowWaiters() {
        int n = 0;
        __cobertura_counters[394] = __cobertura_counters[394] + 1;
        Iterator<K> iterator = this.poolMap.keySet().iterator();
        while (true) {
            n = 396;
            if (!iterator.hasNext()) break;
            __cobertura_counters[395] = __cobertura_counters[395] + 1;
            n = 0;
            K k = iterator.next();
            __cobertura_counters[397] = __cobertura_counters[397] + 1;
            ObjectDeque<T> deque = this.poolMap.get(k);
            __cobertura_counters[398] = __cobertura_counters[398] + 1;
            n = 400;
            if (deque != null) {
                __cobertura_counters[399] = __cobertura_counters[399] + 1;
                n = 0;
                __cobertura_counters[401] = __cobertura_counters[401] + 1;
                __cobertura_counters[402] = __cobertura_counters[402] + 1;
                LinkedBlockingDeque<PooledObject<T>> pool = deque.getIdleObjects();
                __cobertura_counters[403] = __cobertura_counters[403] + 1;
                n = 405;
                if (pool.hasTakeWaiters()) {
                    __cobertura_counters[404] = __cobertura_counters[404] + 1;
                    n = 0;
                    __cobertura_counters[406] = __cobertura_counters[406] + 1;
                    return true;
                }
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[407] = __cobertura_counters[407] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[408] = __cobertura_counters[408] + 1;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void evict() throws Exception {
        int n = 0;
        __cobertura_counters[409] = __cobertura_counters[409] + 1;
        this.assertOpen();
        __cobertura_counters[410] = __cobertura_counters[410] + 1;
        n = 412;
        if (this.getNumIdle() == 0) {
            __cobertura_counters[411] = __cobertura_counters[411] + 1;
            n = 0;
            __cobertura_counters[413] = __cobertura_counters[413] + 1;
            return;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[414] = __cobertura_counters[414] + 1;
        Object underTest = null;
        __cobertura_counters[415] = __cobertura_counters[415] + 1;
        EvictionPolicy evictionPolicy = this.getEvictionPolicy();
        __cobertura_counters[416] = __cobertura_counters[416] + 1;
        Object object = this.evictionLock;
        synchronized (object) {
            __cobertura_counters[417] = __cobertura_counters[417] + 1;
            __cobertura_counters[418] = __cobertura_counters[418] + 1;
            __cobertura_counters[419] = __cobertura_counters[419] + 1;
            __cobertura_counters[420] = __cobertura_counters[420] + 1;
            EvictionConfig evictionConfig = new EvictionConfig(this.getMinEvictableIdleTimeMillis(), this.getSoftMinEvictableIdleTimeMillis(), this.getMinIdlePerKey());
            __cobertura_counters[421] = __cobertura_counters[421] + 1;
            boolean testWhileIdle = this.getTestWhileIdle();
            __cobertura_counters[422] = __cobertura_counters[422] + 1;
            int i = 0;
            int m = this.getNumTests();
            while (true) {
                block30: {
                    Deque idleObjects;
                    block35: {
                        block37: {
                            block36: {
                                block34: {
                                    n = 424;
                                    if (i >= m) {
                                        int n3 = n;
                                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                                        n = 0;
                                        __cobertura_counters[516] = __cobertura_counters[516] + 1;
                                        // MONITOREXIT @DISABLED, blocks:[18, 6, 12] lbl38 : MonitorExitStatement: MONITOREXIT : object
                                        __cobertura_counters[517] = __cobertura_counters[517] + 1;
                                        return;
                                    }
                                    __cobertura_counters[423] = __cobertura_counters[423] + 1;
                                    n = 0;
                                    __cobertura_counters[426] = __cobertura_counters[426] + 1;
                                    n = 428;
                                    if (this.evictionIterator == null) break block34;
                                    __cobertura_counters[427] = __cobertura_counters[427] + 1;
                                    n = 0;
                                    n = 430;
                                    if (this.evictionIterator.hasNext()) break block35;
                                    __cobertura_counters[429] = __cobertura_counters[429] + 1;
                                    n = 0;
                                }
                                int n4 = n;
                                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                                n = 0;
                                __cobertura_counters[431] = __cobertura_counters[431] + 1;
                                n = 433;
                                if (this.evictionKeyIterator == null) break block36;
                                __cobertura_counters[432] = __cobertura_counters[432] + 1;
                                n = 0;
                                __cobertura_counters[434] = __cobertura_counters[434] + 1;
                                n = 436;
                                if (this.evictionKeyIterator.hasNext()) break block37;
                                __cobertura_counters[435] = __cobertura_counters[435] + 1;
                                n = 0;
                            }
                            int n5 = n;
                            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                            n = 0;
                            __cobertura_counters[437] = __cobertura_counters[437] + 1;
                            ArrayList<K> keyCopy = new ArrayList<K>();
                            __cobertura_counters[438] = __cobertura_counters[438] + 1;
                            Lock readLock = this.keyLock.readLock();
                            __cobertura_counters[439] = __cobertura_counters[439] + 1;
                            readLock.lock();
                            try {
                                __cobertura_counters[440] = __cobertura_counters[440] + 1;
                                keyCopy.addAll(this.poolKeyList);
                            }
                            catch (Throwable throwable) {
                                __cobertura_counters[441] = __cobertura_counters[441] + 1;
                                Throwable throwable2 = throwable;
                                readLock.unlock();
                                throw throwable2;
                            }
                            __cobertura_counters[441] = __cobertura_counters[441] + 1;
                            readLock.unlock();
                            __cobertura_counters[442] = __cobertura_counters[442] + 1;
                            __cobertura_counters[443] = __cobertura_counters[443] + 1;
                            this.evictionKeyIterator = keyCopy.iterator();
                        }
                        while (true) {
                            int n6 = n;
                            __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                            n = 0;
                            __cobertura_counters[444] = __cobertura_counters[444] + 1;
                            n = 446;
                            if (!this.evictionKeyIterator.hasNext()) break;
                            __cobertura_counters[445] = __cobertura_counters[445] + 1;
                            n = 0;
                            __cobertura_counters[447] = __cobertura_counters[447] + 1;
                            this.evictionKey = this.evictionKeyIterator.next();
                            __cobertura_counters[448] = __cobertura_counters[448] + 1;
                            ObjectDeque<T> objectDeque = this.poolMap.get(this.evictionKey);
                            __cobertura_counters[449] = __cobertura_counters[449] + 1;
                            n = 451;
                            if (objectDeque == null) {
                                __cobertura_counters[450] = __cobertura_counters[450] + 1;
                                n = 0;
                                __cobertura_counters[452] = __cobertura_counters[452] + 1;
                                continue;
                            }
                            int n7 = n;
                            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                            n = 0;
                            __cobertura_counters[453] = __cobertura_counters[453] + 1;
                            LinkedBlockingDeque<PooledObject<T>> idleObjects2 = objectDeque.getIdleObjects();
                            __cobertura_counters[454] = __cobertura_counters[454] + 1;
                            this.evictionIterator = new BaseGenericObjectPool.EvictionIterator(this, idleObjects2);
                            __cobertura_counters[455] = __cobertura_counters[455] + 1;
                            n = 457;
                            if (this.evictionIterator.hasNext()) {
                                __cobertura_counters[456] = __cobertura_counters[456] + 1;
                                n = 0;
                                __cobertura_counters[458] = __cobertura_counters[458] + 1;
                                break;
                            }
                            int n8 = n;
                            __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                            n = 0;
                            __cobertura_counters[459] = __cobertura_counters[459] + 1;
                            this.evictionIterator = null;
                            __cobertura_counters[460] = __cobertura_counters[460] + 1;
                        }
                    }
                    int n9 = n;
                    __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                    n = 0;
                    __cobertura_counters[461] = __cobertura_counters[461] + 1;
                    n = 463;
                    if (this.evictionIterator == null) {
                        __cobertura_counters[462] = __cobertura_counters[462] + 1;
                        n = 0;
                        __cobertura_counters[464] = __cobertura_counters[464] + 1;
                        return;
                    }
                    try {
                        int n10 = n;
                        __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                        n = 0;
                        __cobertura_counters[465] = __cobertura_counters[465] + 1;
                        underTest = this.evictionIterator.next();
                        __cobertura_counters[466] = __cobertura_counters[466] + 1;
                        idleObjects = this.evictionIterator.getIdleObjects();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        __cobertura_counters[467] = __cobertura_counters[467] + 1;
                        NoSuchElementException nsee = noSuchElementException;
                        __cobertura_counters[468] = __cobertura_counters[468] + 1;
                        --i;
                        __cobertura_counters[469] = __cobertura_counters[469] + 1;
                        this.evictionIterator = null;
                        __cobertura_counters[470] = __cobertura_counters[470] + 1;
                        break block30;
                    }
                    __cobertura_counters[471] = __cobertura_counters[471] + 1;
                    __cobertura_counters[472] = __cobertura_counters[472] + 1;
                    n = 474;
                    if (!underTest.startEvictionTest()) {
                        __cobertura_counters[473] = __cobertura_counters[473] + 1;
                        n = 0;
                        __cobertura_counters[475] = __cobertura_counters[475] + 1;
                        --i;
                        __cobertura_counters[476] = __cobertura_counters[476] + 1;
                    } else {
                        boolean evict;
                        block31: {
                            try {
                                int n11 = n;
                                __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                                n = 0;
                                __cobertura_counters[477] = __cobertura_counters[477] + 1;
                                __cobertura_counters[479] = __cobertura_counters[479] + 1;
                                __cobertura_counters[478] = __cobertura_counters[478] + 1;
                                evict = evictionPolicy.evict(evictionConfig, underTest, this.poolMap.get(this.evictionKey).getIdleObjects().size());
                            }
                            catch (Throwable throwable) {
                                __cobertura_counters[480] = __cobertura_counters[480] + 1;
                                Throwable t = throwable;
                                __cobertura_counters[481] = __cobertura_counters[481] + 1;
                                PoolUtils.checkRethrow(t);
                                __cobertura_counters[482] = __cobertura_counters[482] + 1;
                                this.swallowException(new Exception(t));
                                __cobertura_counters[483] = __cobertura_counters[483] + 1;
                                evict = false;
                                break block31;
                            }
                            __cobertura_counters[484] = __cobertura_counters[484] + 1;
                        }
                        __cobertura_counters[485] = __cobertura_counters[485] + 1;
                        n = 487;
                        if (evict) {
                            __cobertura_counters[486] = __cobertura_counters[486] + 1;
                            n = 0;
                            __cobertura_counters[488] = __cobertura_counters[488] + 1;
                            this.destroy(this.evictionKey, (PooledObject<T>)underTest, true);
                            __cobertura_counters[489] = __cobertura_counters[489] + 1;
                            this.destroyedByEvictorCount.incrementAndGet();
                        } else {
                            block33: {
                                int n12 = n;
                                __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
                                n = 0;
                                __cobertura_counters[490] = __cobertura_counters[490] + 1;
                                n = 492;
                                if (testWhileIdle) {
                                    Exception e;
                                    boolean active;
                                    block32: {
                                        __cobertura_counters[491] = __cobertura_counters[491] + 1;
                                        n = 0;
                                        __cobertura_counters[493] = __cobertura_counters[493] + 1;
                                        active = false;
                                        try {
                                            __cobertura_counters[494] = __cobertura_counters[494] + 1;
                                            this.factory.activateObject(this.evictionKey, (PooledObject<T>)underTest);
                                            __cobertura_counters[495] = __cobertura_counters[495] + 1;
                                            active = true;
                                        }
                                        catch (Exception exception) {
                                            __cobertura_counters[496] = __cobertura_counters[496] + 1;
                                            e = exception;
                                            __cobertura_counters[497] = __cobertura_counters[497] + 1;
                                            this.destroy(this.evictionKey, (PooledObject<T>)underTest, true);
                                            __cobertura_counters[498] = __cobertura_counters[498] + 1;
                                            this.destroyedByEvictorCount.incrementAndGet();
                                            break block32;
                                        }
                                        __cobertura_counters[499] = __cobertura_counters[499] + 1;
                                    }
                                    __cobertura_counters[500] = __cobertura_counters[500] + 1;
                                    n = 502;
                                    if (active) {
                                        __cobertura_counters[501] = __cobertura_counters[501] + 1;
                                        n = 0;
                                        __cobertura_counters[503] = __cobertura_counters[503] + 1;
                                        n = 505;
                                        if (!this.factory.validateObject(this.evictionKey, (PooledObject<T>)underTest)) {
                                            __cobertura_counters[504] = __cobertura_counters[504] + 1;
                                            n = 0;
                                            __cobertura_counters[506] = __cobertura_counters[506] + 1;
                                            this.destroy(this.evictionKey, (PooledObject<T>)underTest, true);
                                            __cobertura_counters[507] = __cobertura_counters[507] + 1;
                                            this.destroyedByEvictorCount.incrementAndGet();
                                        } else {
                                            try {
                                                int n13 = n;
                                                __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
                                                n = 0;
                                                __cobertura_counters[508] = __cobertura_counters[508] + 1;
                                                this.factory.passivateObject(this.evictionKey, (PooledObject<T>)underTest);
                                            }
                                            catch (Exception exception) {
                                                __cobertura_counters[509] = __cobertura_counters[509] + 1;
                                                e = exception;
                                                __cobertura_counters[510] = __cobertura_counters[510] + 1;
                                                this.destroy(this.evictionKey, (PooledObject<T>)underTest, true);
                                                __cobertura_counters[511] = __cobertura_counters[511] + 1;
                                                this.destroyedByEvictorCount.incrementAndGet();
                                                break block33;
                                            }
                                            __cobertura_counters[512] = __cobertura_counters[512] + 1;
                                        }
                                    }
                                }
                            }
                            int n14 = n;
                            __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
                            n = 0;
                            __cobertura_counters[513] = __cobertura_counters[513] + 1;
                            n = 515;
                            if (!underTest.endEvictionTest(idleObjects)) {
                                __cobertura_counters[514] = __cobertura_counters[514] + 1;
                                n = 0;
                            }
                        }
                    }
                }
                int n15 = n;
                __cobertura_counters[n15] = __cobertura_counters[n15] + 1;
                n = 0;
                __cobertura_counters[425] = __cobertura_counters[425] + 1;
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private PooledObject<T> create(K var1_1) throws Exception {
        block11: {
            block10: {
                block9: {
                    var2_2 = 0;
                    GenericKeyedObjectPool.__cobertura_counters[518] = GenericKeyedObjectPool.__cobertura_counters[518] + 1;
                    maxTotalPerKeySave = this.getMaxTotalPerKey();
                    GenericKeyedObjectPool.__cobertura_counters[519] = GenericKeyedObjectPool.__cobertura_counters[519] + 1;
                    maxTotal = this.getMaxTotal();
                    GenericKeyedObjectPool.__cobertura_counters[520] = GenericKeyedObjectPool.__cobertura_counters[520] + 1;
                    loop = true;
                    while (true) {
                        GenericKeyedObjectPool.__cobertura_counters[521] = GenericKeyedObjectPool.__cobertura_counters[521] + 1;
                        var2_2 = 523;
                        if (!loop) break;
                        GenericKeyedObjectPool.__cobertura_counters[522] = GenericKeyedObjectPool.__cobertura_counters[522] + 1;
                        var2_2 = 0;
                        GenericKeyedObjectPool.__cobertura_counters[524] = GenericKeyedObjectPool.__cobertura_counters[524] + 1;
                        newNumTotal = this.numTotal.incrementAndGet();
                        GenericKeyedObjectPool.__cobertura_counters[525] = GenericKeyedObjectPool.__cobertura_counters[525] + 1;
                        var2_2 = 527;
                        if (maxTotal <= -1) ** GOTO lbl-1000
                        GenericKeyedObjectPool.__cobertura_counters[526] = GenericKeyedObjectPool.__cobertura_counters[526] + 1;
                        var2_2 = 0;
                        var2_2 = 529;
                        if (newNumTotal > maxTotal) {
                            GenericKeyedObjectPool.__cobertura_counters[528] = GenericKeyedObjectPool.__cobertura_counters[528] + 1;
                            var2_2 = 0;
                            GenericKeyedObjectPool.__cobertura_counters[530] = GenericKeyedObjectPool.__cobertura_counters[530] + 1;
                            this.numTotal.decrementAndGet();
                            GenericKeyedObjectPool.__cobertura_counters[531] = GenericKeyedObjectPool.__cobertura_counters[531] + 1;
                            var2_2 = 533;
                            if (this.getNumIdle() == 0) {
                                GenericKeyedObjectPool.__cobertura_counters[532] = GenericKeyedObjectPool.__cobertura_counters[532] + 1;
                                var2_2 = 0;
                                GenericKeyedObjectPool.__cobertura_counters[534] = GenericKeyedObjectPool.__cobertura_counters[534] + 1;
                                return null;
                            }
                            v0 = var2_2;
                            GenericKeyedObjectPool.__cobertura_counters[v0] = GenericKeyedObjectPool.__cobertura_counters[v0] + 1;
                            var2_2 = 0;
                            GenericKeyedObjectPool.__cobertura_counters[535] = GenericKeyedObjectPool.__cobertura_counters[535] + 1;
                            this.clearOldest();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = var2_2;
                            GenericKeyedObjectPool.__cobertura_counters[v1] = GenericKeyedObjectPool.__cobertura_counters[v1] + 1;
                            var2_2 = 0;
                            GenericKeyedObjectPool.__cobertura_counters[536] = GenericKeyedObjectPool.__cobertura_counters[536] + 1;
                            loop = false;
                        }
                        GenericKeyedObjectPool.__cobertura_counters[537] = GenericKeyedObjectPool.__cobertura_counters[537] + 1;
                    }
                    v2 = var2_2;
                    GenericKeyedObjectPool.__cobertura_counters[v2] = GenericKeyedObjectPool.__cobertura_counters[v2] + 1;
                    var2_2 = 0;
                    GenericKeyedObjectPool.__cobertura_counters[538] = GenericKeyedObjectPool.__cobertura_counters[538] + 1;
                    objectDeque = this.poolMap.get(key);
                    GenericKeyedObjectPool.__cobertura_counters[539] = GenericKeyedObjectPool.__cobertura_counters[539] + 1;
                    newCreateCount = objectDeque.getCreateCount().incrementAndGet();
                    GenericKeyedObjectPool.__cobertura_counters[540] = GenericKeyedObjectPool.__cobertura_counters[540] + 1;
                    var2_2 = 542;
                    if (maxTotalPerKeySave <= -1) break block9;
                    GenericKeyedObjectPool.__cobertura_counters[541] = GenericKeyedObjectPool.__cobertura_counters[541] + 1;
                    var2_2 = 0;
                    var2_2 = 544;
                    if (newCreateCount > (long)maxTotalPerKeySave) break block10;
                    GenericKeyedObjectPool.__cobertura_counters[543] = GenericKeyedObjectPool.__cobertura_counters[543] + 1;
                    var2_2 = 0;
                }
                v3 = var2_2;
                GenericKeyedObjectPool.__cobertura_counters[v3] = GenericKeyedObjectPool.__cobertura_counters[v3] + 1;
                var2_2 = 0;
                var2_2 = 546;
                if (newCreateCount <= 0x7FFFFFFFL) break block11;
                GenericKeyedObjectPool.__cobertura_counters[545] = GenericKeyedObjectPool.__cobertura_counters[545] + 1;
                var2_2 = 0;
            }
            v4 = var2_2;
            GenericKeyedObjectPool.__cobertura_counters[v4] = GenericKeyedObjectPool.__cobertura_counters[v4] + 1;
            var2_2 = 0;
            GenericKeyedObjectPool.__cobertura_counters[547] = GenericKeyedObjectPool.__cobertura_counters[547] + 1;
            this.numTotal.decrementAndGet();
            GenericKeyedObjectPool.__cobertura_counters[548] = GenericKeyedObjectPool.__cobertura_counters[548] + 1;
            objectDeque.getCreateCount().decrementAndGet();
            GenericKeyedObjectPool.__cobertura_counters[549] = GenericKeyedObjectPool.__cobertura_counters[549] + 1;
            return null;
        }
        v5 = var2_2;
        GenericKeyedObjectPool.__cobertura_counters[v5] = GenericKeyedObjectPool.__cobertura_counters[v5] + 1;
        var2_2 = 0;
        GenericKeyedObjectPool.__cobertura_counters[550] = GenericKeyedObjectPool.__cobertura_counters[550] + 1;
        p = null;
        try {
            GenericKeyedObjectPool.__cobertura_counters[551] = GenericKeyedObjectPool.__cobertura_counters[551] + 1;
            p = this.factory.makeObject(key);
        }
        catch (Exception v6) {
            GenericKeyedObjectPool.__cobertura_counters[552] = GenericKeyedObjectPool.__cobertura_counters[552] + 1;
            e = v6;
            GenericKeyedObjectPool.__cobertura_counters[553] = GenericKeyedObjectPool.__cobertura_counters[553] + 1;
            this.numTotal.decrementAndGet();
            GenericKeyedObjectPool.__cobertura_counters[554] = GenericKeyedObjectPool.__cobertura_counters[554] + 1;
            objectDeque.getCreateCount().decrementAndGet();
            GenericKeyedObjectPool.__cobertura_counters[555] = GenericKeyedObjectPool.__cobertura_counters[555] + 1;
            throw e;
        }
        GenericKeyedObjectPool.__cobertura_counters[556] = GenericKeyedObjectPool.__cobertura_counters[556] + 1;
        GenericKeyedObjectPool.__cobertura_counters[557] = GenericKeyedObjectPool.__cobertura_counters[557] + 1;
        this.createdCount.incrementAndGet();
        GenericKeyedObjectPool.__cobertura_counters[558] = GenericKeyedObjectPool.__cobertura_counters[558] + 1;
        objectDeque.getAllObjects().put(new BaseGenericObjectPool.IdentityWrapper<T>(p.getObject()), p);
        GenericKeyedObjectPool.__cobertura_counters[559] = GenericKeyedObjectPool.__cobertura_counters[559] + 1;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean destroy(K k, PooledObject<T> pooledObject, boolean bl) throws Exception {
        void key;
        int n;
        block6: {
            boolean bl2;
            n = 0;
            __cobertura_counters[560] = __cobertura_counters[560] + 1;
            ObjectDeque<T> objectDeque = this.register(key);
            try {
                void toDestroy;
                __cobertura_counters[561] = __cobertura_counters[561] + 1;
                boolean isIdle = objectDeque.getIdleObjects().remove(toDestroy);
                __cobertura_counters[562] = __cobertura_counters[562] + 1;
                n = 564;
                if (!isIdle) {
                    void always;
                    __cobertura_counters[563] = __cobertura_counters[563] + 1;
                    n = 0;
                    n = 566;
                    if (always == false) break block6;
                    __cobertura_counters[565] = __cobertura_counters[565] + 1;
                    n = 0;
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[567] = __cobertura_counters[567] + 1;
                objectDeque.getAllObjects().remove(new BaseGenericObjectPool.IdentityWrapper(toDestroy.getObject()));
                __cobertura_counters[568] = __cobertura_counters[568] + 1;
                toDestroy.invalidate();
                try {
                    __cobertura_counters[569] = __cobertura_counters[569] + 1;
                    this.factory.destroyObject(key, (PooledObject<T>)toDestroy);
                }
                catch (Throwable throwable) {
                    __cobertura_counters[570] = __cobertura_counters[570] + 1;
                    Throwable throwable2 = throwable;
                    objectDeque.getCreateCount().decrementAndGet();
                    __cobertura_counters[571] = __cobertura_counters[571] + 1;
                    this.destroyedCount.incrementAndGet();
                    __cobertura_counters[572] = __cobertura_counters[572] + 1;
                    this.numTotal.decrementAndGet();
                    throw throwable2;
                }
                __cobertura_counters[570] = __cobertura_counters[570] + 1;
                objectDeque.getCreateCount().decrementAndGet();
                __cobertura_counters[571] = __cobertura_counters[571] + 1;
                this.destroyedCount.incrementAndGet();
                __cobertura_counters[572] = __cobertura_counters[572] + 1;
                this.numTotal.decrementAndGet();
                __cobertura_counters[573] = __cobertura_counters[573] + 1;
                __cobertura_counters[574] = __cobertura_counters[574] + 1;
                bl2 = true;
            }
            catch (Throwable throwable) {
                this.deregister(key);
                throw throwable;
            }
            __cobertura_counters[576] = __cobertura_counters[576] + 1;
            this.deregister(key);
            return bl2;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[575] = __cobertura_counters[575] + 1;
        boolean bl3 = false;
        __cobertura_counters[577] = __cobertura_counters[577] + 1;
        this.deregister(key);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ObjectDeque<T> register(K k) {
        ObjectDeque<Object> objectDeque;
        Lock lock;
        block5: {
            int n = 0;
            __cobertura_counters[578] = __cobertura_counters[578] + 1;
            lock = this.keyLock.readLock();
            __cobertura_counters[579] = __cobertura_counters[579] + 1;
            objectDeque = null;
            try {
                void k2;
                __cobertura_counters[580] = __cobertura_counters[580] + 1;
                lock.lock();
                __cobertura_counters[581] = __cobertura_counters[581] + 1;
                objectDeque = this.poolMap.get(k2);
                __cobertura_counters[582] = __cobertura_counters[582] + 1;
                n = 584;
                if (objectDeque == null) {
                    __cobertura_counters[583] = __cobertura_counters[583] + 1;
                    n = 0;
                    __cobertura_counters[585] = __cobertura_counters[585] + 1;
                    lock.unlock();
                    __cobertura_counters[586] = __cobertura_counters[586] + 1;
                    lock = this.keyLock.writeLock();
                    __cobertura_counters[587] = __cobertura_counters[587] + 1;
                    lock.lock();
                    __cobertura_counters[588] = __cobertura_counters[588] + 1;
                    objectDeque = this.poolMap.get(k2);
                    __cobertura_counters[589] = __cobertura_counters[589] + 1;
                    n = 591;
                    if (objectDeque == null) {
                        __cobertura_counters[590] = __cobertura_counters[590] + 1;
                        n = 0;
                        __cobertura_counters[592] = __cobertura_counters[592] + 1;
                        objectDeque = new ObjectDeque(this, this.fairness);
                        __cobertura_counters[593] = __cobertura_counters[593] + 1;
                        objectDeque.getNumInterested().incrementAndGet();
                        __cobertura_counters[594] = __cobertura_counters[594] + 1;
                        this.poolMap.put(k2, objectDeque);
                        __cobertura_counters[595] = __cobertura_counters[595] + 1;
                        this.poolKeyList.add(k2);
                    } else {
                        int n2 = n;
                        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                        n = 0;
                        __cobertura_counters[596] = __cobertura_counters[596] + 1;
                        objectDeque.getNumInterested().incrementAndGet();
                    }
                    break block5;
                }
                int n3 = n;
                __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                n = 0;
                __cobertura_counters[597] = __cobertura_counters[597] + 1;
                objectDeque.getNumInterested().incrementAndGet();
            }
            catch (Throwable throwable) {
                __cobertura_counters[598] = __cobertura_counters[598] + 1;
                Throwable throwable2 = throwable;
                lock.unlock();
                throw throwable2;
            }
        }
        __cobertura_counters[598] = __cobertura_counters[598] + 1;
        lock.unlock();
        __cobertura_counters[599] = __cobertura_counters[599] + 1;
        __cobertura_counters[600] = __cobertura_counters[600] + 1;
        return objectDeque;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void deregister(K k) {
        void k2;
        int n = 0;
        __cobertura_counters[601] = __cobertura_counters[601] + 1;
        ObjectDeque<T> objectDeque = this.poolMap.get(k2);
        __cobertura_counters[602] = __cobertura_counters[602] + 1;
        long numInterested = objectDeque.getNumInterested().decrementAndGet();
        __cobertura_counters[603] = __cobertura_counters[603] + 1;
        n = 605;
        if (numInterested == 0L) {
            __cobertura_counters[604] = __cobertura_counters[604] + 1;
            n = 0;
            n = 607;
            if (objectDeque.getCreateCount().get() == 0) {
                int n2;
                __cobertura_counters[606] = __cobertura_counters[606] + 1;
                n = 0;
                __cobertura_counters[608] = __cobertura_counters[608] + 1;
                Lock writeLock = this.keyLock.writeLock();
                __cobertura_counters[609] = __cobertura_counters[609] + 1;
                writeLock.lock();
                try {
                    __cobertura_counters[610] = __cobertura_counters[610] + 1;
                    n = 612;
                    if (objectDeque.getCreateCount().get() == 0) {
                        __cobertura_counters[611] = __cobertura_counters[611] + 1;
                        n = 0;
                        __cobertura_counters[613] = __cobertura_counters[613] + 1;
                        n = 615;
                        if (objectDeque.getNumInterested().get() == 0L) {
                            __cobertura_counters[614] = __cobertura_counters[614] + 1;
                            n = 0;
                            __cobertura_counters[616] = __cobertura_counters[616] + 1;
                            this.poolMap.remove(k2);
                            __cobertura_counters[617] = __cobertura_counters[617] + 1;
                            this.poolKeyList.remove(k2);
                        }
                    }
                    n2 = n;
                }
                catch (Throwable throwable) {
                    __cobertura_counters[618] = __cobertura_counters[618] + 1;
                    Throwable throwable2 = throwable;
                    writeLock.unlock();
                    throw throwable2;
                }
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[618] = __cobertura_counters[618] + 1;
                writeLock.unlock();
                __cobertura_counters[619] = __cobertura_counters[619] + 1;
            }
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[620] = __cobertura_counters[620] + 1;
    }

    @Override
    void ensureMinIdle() throws Exception {
        int n = 0;
        __cobertura_counters[621] = __cobertura_counters[621] + 1;
        int minIdlePerKeySave = this.getMinIdlePerKey();
        __cobertura_counters[622] = __cobertura_counters[622] + 1;
        n = 624;
        if (minIdlePerKeySave < 1) {
            __cobertura_counters[623] = __cobertura_counters[623] + 1;
            n = 0;
            __cobertura_counters[625] = __cobertura_counters[625] + 1;
            return;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[626] = __cobertura_counters[626] + 1;
        Iterator<K> iterator = this.poolMap.keySet().iterator();
        while (true) {
            n = 628;
            if (!iterator.hasNext()) break;
            __cobertura_counters[627] = __cobertura_counters[627] + 1;
            n = 0;
            K k = iterator.next();
            __cobertura_counters[629] = __cobertura_counters[629] + 1;
            this.ensureMinIdle(k);
            __cobertura_counters[630] = __cobertura_counters[630] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[631] = __cobertura_counters[631] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureMinIdle(K k) throws Exception {
        void key;
        int n = 0;
        __cobertura_counters[632] = __cobertura_counters[632] + 1;
        ObjectDeque<T> objectDeque = this.poolMap.get(key);
        __cobertura_counters[633] = __cobertura_counters[633] + 1;
        int deficit = this.calculateDeficit(objectDeque);
        __cobertura_counters[634] = __cobertura_counters[634] + 1;
        int i = 0;
        while (true) {
            n = 636;
            if (i >= deficit) break;
            __cobertura_counters[635] = __cobertura_counters[635] + 1;
            n = 0;
            n = 638;
            if (this.calculateDeficit(objectDeque) <= 0) break;
            __cobertura_counters[637] = __cobertura_counters[637] + 1;
            n = 0;
            __cobertura_counters[640] = __cobertura_counters[640] + 1;
            this.addObject(key);
            __cobertura_counters[639] = __cobertura_counters[639] + 1;
            ++i;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[641] = __cobertura_counters[641] + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addObject(K k) throws Exception {
        void key;
        int n = 0;
        __cobertura_counters[642] = __cobertura_counters[642] + 1;
        this.assertOpen();
        __cobertura_counters[643] = __cobertura_counters[643] + 1;
        this.register(key);
        try {
            __cobertura_counters[644] = __cobertura_counters[644] + 1;
            PooledObject<T> p = this.create(key);
            __cobertura_counters[645] = __cobertura_counters[645] + 1;
            this.addIdleObject(key, p);
        }
        catch (Throwable throwable) {
            __cobertura_counters[646] = __cobertura_counters[646] + 1;
            Throwable throwable2 = throwable;
            this.deregister(key);
            throw throwable2;
        }
        __cobertura_counters[646] = __cobertura_counters[646] + 1;
        this.deregister(key);
        __cobertura_counters[647] = __cobertura_counters[647] + 1;
        __cobertura_counters[648] = __cobertura_counters[648] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void addIdleObject(K k, PooledObject<T> pooledObject) throws Exception {
        void p;
        int n = 0;
        __cobertura_counters[649] = __cobertura_counters[649] + 1;
        n = 651;
        if (p != null) {
            void key;
            __cobertura_counters[650] = __cobertura_counters[650] + 1;
            n = 0;
            __cobertura_counters[652] = __cobertura_counters[652] + 1;
            this.factory.passivateObject(key, (PooledObject<T>)p);
            __cobertura_counters[653] = __cobertura_counters[653] + 1;
            __cobertura_counters[654] = __cobertura_counters[654] + 1;
            LinkedBlockingDeque<PooledObject<T>> idleObjects = this.poolMap.get(key).getIdleObjects();
            __cobertura_counters[655] = __cobertura_counters[655] + 1;
            n = 657;
            if (this.getLifo()) {
                __cobertura_counters[656] = __cobertura_counters[656] + 1;
                n = 0;
                __cobertura_counters[658] = __cobertura_counters[658] + 1;
                idleObjects.addFirst((PooledObject<T>)p);
            } else {
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[659] = __cobertura_counters[659] + 1;
                idleObjects.addLast((PooledObject<T>)p);
            }
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[660] = __cobertura_counters[660] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void preparePool(K k) throws Exception {
        void key;
        int n = 0;
        __cobertura_counters[661] = __cobertura_counters[661] + 1;
        int minIdlePerKeySave = this.getMinIdlePerKey();
        __cobertura_counters[662] = __cobertura_counters[662] + 1;
        n = 664;
        if (minIdlePerKeySave < 1) {
            __cobertura_counters[663] = __cobertura_counters[663] + 1;
            n = 0;
            __cobertura_counters[665] = __cobertura_counters[665] + 1;
            return;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[666] = __cobertura_counters[666] + 1;
        this.ensureMinIdle(key);
        __cobertura_counters[667] = __cobertura_counters[667] + 1;
    }

    private int getNumTests() {
        int n = 0;
        __cobertura_counters[668] = __cobertura_counters[668] + 1;
        int totalIdle = this.getNumIdle();
        __cobertura_counters[669] = __cobertura_counters[669] + 1;
        int numTests = this.getNumTestsPerEvictionRun();
        __cobertura_counters[670] = __cobertura_counters[670] + 1;
        n = 672;
        if (numTests >= 0) {
            __cobertura_counters[671] = __cobertura_counters[671] + 1;
            n = 0;
            __cobertura_counters[673] = __cobertura_counters[673] + 1;
            return Math.min(numTests, totalIdle);
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[674] = __cobertura_counters[674] + 1;
        return (int)Math.ceil((double)totalIdle / Math.abs((double)numTests));
    }

    /*
     * WARNING - void declaration
     */
    private int calculateDeficit(ObjectDeque<T> objectDeque) {
        int growLimit;
        void objectDeque2;
        int n = 0;
        __cobertura_counters[675] = __cobertura_counters[675] + 1;
        n = 677;
        if (objectDeque2 == null) {
            __cobertura_counters[676] = __cobertura_counters[676] + 1;
            n = 0;
            __cobertura_counters[678] = __cobertura_counters[678] + 1;
            return this.getMinIdlePerKey();
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[679] = __cobertura_counters[679] + 1;
        int maxTotal = this.getMaxTotal();
        __cobertura_counters[680] = __cobertura_counters[680] + 1;
        int maxTotalPerKeySave = this.getMaxTotalPerKey();
        __cobertura_counters[681] = __cobertura_counters[681] + 1;
        int objectDefecit = 0;
        __cobertura_counters[682] = __cobertura_counters[682] + 1;
        objectDefecit = this.getMinIdlePerKey() - objectDeque2.getIdleObjects().size();
        __cobertura_counters[683] = __cobertura_counters[683] + 1;
        n = 685;
        if (maxTotalPerKeySave > 0) {
            __cobertura_counters[684] = __cobertura_counters[684] + 1;
            n = 0;
            __cobertura_counters[686] = __cobertura_counters[686] + 1;
            __cobertura_counters[688] = __cobertura_counters[688] + 1;
            __cobertura_counters[687] = __cobertura_counters[687] + 1;
            growLimit = Math.max(0, maxTotalPerKeySave - objectDeque2.getIdleObjects().size());
            __cobertura_counters[689] = __cobertura_counters[689] + 1;
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[690] = __cobertura_counters[690] + 1;
        n = 692;
        if (maxTotal > 0) {
            __cobertura_counters[691] = __cobertura_counters[691] + 1;
            n = 0;
            __cobertura_counters[693] = __cobertura_counters[693] + 1;
            growLimit = Math.max(0, maxTotal - this.getNumActive() - this.getNumIdle());
            __cobertura_counters[694] = __cobertura_counters[694] + 1;
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        int n4 = n;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n = 0;
        __cobertura_counters[695] = __cobertura_counters[695] + 1;
        return objectDefecit;
    }

    @Override
    public Map<String, Integer> getNumActivePerKey() {
        int n = 0;
        __cobertura_counters[696] = __cobertura_counters[696] + 1;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        __cobertura_counters[697] = __cobertura_counters[697] + 1;
        Iterator<Map.Entry<K, ObjectDeque<T>>> iter = this.poolMap.entrySet().iterator();
        while (true) {
            __cobertura_counters[698] = __cobertura_counters[698] + 1;
            n = 700;
            if (!iter.hasNext()) break;
            __cobertura_counters[699] = __cobertura_counters[699] + 1;
            n = 0;
            __cobertura_counters[701] = __cobertura_counters[701] + 1;
            Map.Entry<K, ObjectDeque<T>> entry = iter.next();
            __cobertura_counters[702] = __cobertura_counters[702] + 1;
            n = 704;
            if (entry != null) {
                __cobertura_counters[703] = __cobertura_counters[703] + 1;
                n = 0;
                __cobertura_counters[705] = __cobertura_counters[705] + 1;
                K key = entry.getKey();
                __cobertura_counters[706] = __cobertura_counters[706] + 1;
                ObjectDeque<T> objectDequeue = entry.getValue();
                __cobertura_counters[707] = __cobertura_counters[707] + 1;
                n = 709;
                if (key != null) {
                    __cobertura_counters[708] = __cobertura_counters[708] + 1;
                    n = 0;
                    n = 711;
                    if (objectDequeue != null) {
                        __cobertura_counters[710] = __cobertura_counters[710] + 1;
                        n = 0;
                        __cobertura_counters[712] = __cobertura_counters[712] + 1;
                        __cobertura_counters[714] = __cobertura_counters[714] + 1;
                        __cobertura_counters[715] = __cobertura_counters[715] + 1;
                        __cobertura_counters[713] = __cobertura_counters[713] + 1;
                        result.put(key.toString(), objectDequeue.getAllObjects().size() - objectDequeue.getIdleObjects().size());
                    }
                }
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[716] = __cobertura_counters[716] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[717] = __cobertura_counters[717] + 1;
        return result;
    }

    @Override
    public int getNumWaiters() {
        int n = 0;
        __cobertura_counters[718] = __cobertura_counters[718] + 1;
        int result = 0;
        __cobertura_counters[719] = __cobertura_counters[719] + 1;
        n = 721;
        if (this.getBlockWhenExhausted()) {
            __cobertura_counters[720] = __cobertura_counters[720] + 1;
            n = 0;
            __cobertura_counters[722] = __cobertura_counters[722] + 1;
            Iterator<ObjectDeque<T>> iter = this.poolMap.values().iterator();
            while (true) {
                __cobertura_counters[723] = __cobertura_counters[723] + 1;
                n = 725;
                if (!iter.hasNext()) break;
                __cobertura_counters[724] = __cobertura_counters[724] + 1;
                n = 0;
                __cobertura_counters[726] = __cobertura_counters[726] + 1;
                result += iter.next().getIdleObjects().getTakeQueueLength();
            }
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[727] = __cobertura_counters[727] + 1;
        return result;
    }

    @Override
    public Map<String, Integer> getNumWaitersByKey() {
        int n = 0;
        __cobertura_counters[728] = __cobertura_counters[728] + 1;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        __cobertura_counters[729] = __cobertura_counters[729] + 1;
        Iterator<K> iterator = this.poolMap.keySet().iterator();
        while (true) {
            n = 731;
            if (!iterator.hasNext()) break;
            __cobertura_counters[730] = __cobertura_counters[730] + 1;
            n = 0;
            K key = iterator.next();
            __cobertura_counters[732] = __cobertura_counters[732] + 1;
            ObjectDeque<T> queue = this.poolMap.get(key);
            __cobertura_counters[733] = __cobertura_counters[733] + 1;
            n = 735;
            if (queue != null) {
                __cobertura_counters[734] = __cobertura_counters[734] + 1;
                n = 0;
                __cobertura_counters[736] = __cobertura_counters[736] + 1;
                n = 738;
                if (this.getBlockWhenExhausted()) {
                    __cobertura_counters[737] = __cobertura_counters[737] + 1;
                    n = 0;
                    __cobertura_counters[739] = __cobertura_counters[739] + 1;
                    __cobertura_counters[741] = __cobertura_counters[741] + 1;
                    __cobertura_counters[740] = __cobertura_counters[740] + 1;
                    result.put(key.toString(), queue.getIdleObjects().getTakeQueueLength());
                } else {
                    int n2 = n;
                    __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                    n = 0;
                    __cobertura_counters[742] = __cobertura_counters[742] + 1;
                    result.put(key.toString(), 0);
                }
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[743] = __cobertura_counters[743] + 1;
        }
        int n4 = n;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n = 0;
        __cobertura_counters[744] = __cobertura_counters[744] + 1;
        return result;
    }

    @Override
    public Map<String, List<DefaultPooledObjectInfo>> listAllObjects() {
        int n = 0;
        __cobertura_counters[745] = __cobertura_counters[745] + 1;
        HashMap<String, List<DefaultPooledObjectInfo>> result = new HashMap<String, List<DefaultPooledObjectInfo>>();
        __cobertura_counters[746] = __cobertura_counters[746] + 1;
        Iterator<K> iterator = this.poolMap.keySet().iterator();
        while (true) {
            n = 748;
            if (!iterator.hasNext()) break;
            __cobertura_counters[747] = __cobertura_counters[747] + 1;
            n = 0;
            K key = iterator.next();
            __cobertura_counters[749] = __cobertura_counters[749] + 1;
            ObjectDeque<T> queue = this.poolMap.get(key);
            __cobertura_counters[750] = __cobertura_counters[750] + 1;
            n = 752;
            if (queue != null) {
                __cobertura_counters[751] = __cobertura_counters[751] + 1;
                n = 0;
                __cobertura_counters[753] = __cobertura_counters[753] + 1;
                ArrayList<DefaultPooledObjectInfo> list = new ArrayList<DefaultPooledObjectInfo>();
                __cobertura_counters[754] = __cobertura_counters[754] + 1;
                result.put(key.toString(), list);
                __cobertura_counters[755] = __cobertura_counters[755] + 1;
                Iterator<PooledObject<T>> iterator2 = queue.getAllObjects().values().iterator();
                while (true) {
                    n = 757;
                    if (!iterator2.hasNext()) break;
                    __cobertura_counters[756] = __cobertura_counters[756] + 1;
                    n = 0;
                    PooledObject<T> p = iterator2.next();
                    __cobertura_counters[758] = __cobertura_counters[758] + 1;
                    list.add(new DefaultPooledObjectInfo(p));
                    __cobertura_counters[759] = __cobertura_counters[759] + 1;
                }
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[760] = __cobertura_counters[760] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[761] = __cobertura_counters[761] + 1;
        return result;
    }

    static {
        GenericKeyedObjectPool.__cobertura_init();
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[771];
            TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/GenericKeyedObjectPool");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(87, 1, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(88, 2, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(103, 3, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(105, 4, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(105, 6, 5);
        lightClassmapListener2.putLineTouchPoint(106, 7, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(107, 8, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(109, 9, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(110, 10, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(112, 11, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(114, 12, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(115, 13, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(128, 14, "getMaxTotalPerKey", "()I");
        lightClassmapListener2.putLineTouchPoint(141, 15, "setMaxTotalPerKey", "(I)V");
        lightClassmapListener2.putLineTouchPoint(142, 16, "setMaxTotalPerKey", "(I)V");
        lightClassmapListener2.putLineTouchPoint(162, 17, "getMaxIdlePerKey", "()I");
        lightClassmapListener2.putLineTouchPoint(182, 18, "setMaxIdlePerKey", "(I)V");
        lightClassmapListener2.putLineTouchPoint(183, 19, "setMaxIdlePerKey", "(I)V");
        lightClassmapListener2.putLineTouchPoint(204, 20, "setMinIdlePerKey", "(I)V");
        lightClassmapListener2.putLineTouchPoint(205, 21, "setMinIdlePerKey", "(I)V");
        lightClassmapListener2.putLineTouchPoint(225, 22, "getMinIdlePerKey", "()I");
        lightClassmapListener2.putLineTouchPoint(226, 23, "getMinIdlePerKey", "()I");
        lightClassmapListener2.putJumpTouchPoint(226, 25, 24);
        lightClassmapListener2.putLineTouchPoint(227, 26, "getMinIdlePerKey", "()I");
        lightClassmapListener2.putLineTouchPoint(229, 27, "getMinIdlePerKey", "()I");
        lightClassmapListener2.putLineTouchPoint(241, 28, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(242, 29, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(243, 30, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(244, 31, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(245, 32, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(246, 33, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(247, 34, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(248, 35, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(249, 36, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(250, 37, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(251, 38, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(252, 39, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(253, 40, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(254, 41, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(254, 42, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(255, 43, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(256, 44, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(256, 45, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(257, 46, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(258, 47, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(259, 48, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(268, 49, "getFactory", "()Lorg/apache/commons/pool2/KeyedPooledObjectFactory;");
        lightClassmapListener2.putLineTouchPoint(279, 50, "borrowObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(339, 51, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(341, 52, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(345, 53, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(348, 54, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(349, 55, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(352, 56, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(352, 58, 57);
        lightClassmapListener2.putLineTouchPoint(353, 59, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(354, 60, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(354, 62, 61);
        lightClassmapListener2.putLineTouchPoint(355, 63, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(356, 64, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(356, 66, 65);
        lightClassmapListener2.putLineTouchPoint(357, 67, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(358, 68, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(358, 70, 69);
        lightClassmapListener2.putLineTouchPoint(359, 71, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(362, 72, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(362, 74, 73);
        lightClassmapListener2.putLineTouchPoint(363, 75, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(363, 77, 76);
        lightClassmapListener2.putLineTouchPoint(364, 78, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(366, 79, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(370, 80, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(370, 82, 81);
        lightClassmapListener2.putLineTouchPoint(371, 83, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(374, 84, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(374, 86, 85);
        lightClassmapListener2.putLineTouchPoint(375, 87, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(378, 88, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(379, 89, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(379, 91, 90);
        lightClassmapListener2.putLineTouchPoint(380, 92, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(381, 93, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(381, 95, 94);
        lightClassmapListener2.putLineTouchPoint(382, 96, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(385, 97, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(385, 99, 98);
        lightClassmapListener2.putLineTouchPoint(386, 100, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(388, 101, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(388, 103, 102);
        lightClassmapListener2.putLineTouchPoint(389, 104, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(393, 105, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(393, 107, 106);
        lightClassmapListener2.putLineTouchPoint(395, 108, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(396, 109, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(398, 110, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(399, 111, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(401, 112, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(402, 113, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(403, 114, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(403, 116, 115);
        lightClassmapListener2.putLineTouchPoint(404, 117, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(406, 118, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(407, 119, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(409, 120, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(410, 121, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(410, 123, 122);
        lightClassmapListener2.putJumpTouchPoint(410, 125, 124);
        lightClassmapListener2.putJumpTouchPoint(410, 127, 126);
        lightClassmapListener2.putJumpTouchPoint(410, 129, 128);
        lightClassmapListener2.putLineTouchPoint(411, 130, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(412, 131, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(414, 132, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(415, 133, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(416, 134, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(417, 135, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(418, 136, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(419, 137, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(419, 139, 138);
        lightClassmapListener2.putLineTouchPoint(421, 140, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(422, 141, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(423, 142, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(425, 143, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(426, 144, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(427, 145, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(427, 147, 146);
        lightClassmapListener2.putLineTouchPoint(428, 148, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(430, 149, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(431, 150, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(434, 151, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(438, 152, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(439, 153, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(441, 154, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(443, 155, "borrowObject", "(Ljava/lang/Object;J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(472, 156, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(474, 157, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(476, 158, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(476, 160, 159);
        lightClassmapListener2.putLineTouchPoint(477, 161, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(481, 162, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(482, 163, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(483, 164, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(483, 166, 165);
        lightClassmapListener2.putLineTouchPoint(484, 167, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(487, 168, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(489, 169, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(491, 170, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(493, 171, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(493, 173, 172);
        lightClassmapListener2.putLineTouchPoint(494, 174, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(494, 176, 175);
        lightClassmapListener2.putLineTouchPoint(496, 177, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(497, 178, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(498, 179, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(499, 180, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(500, 181, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(500, 183, 182);
        lightClassmapListener2.putLineTouchPoint(502, 184, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(503, 185, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(504, 186, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(505, 187, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(507, 188, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(508, 189, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(513, 190, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(514, 191, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(515, 192, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(517, 193, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(518, 194, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(519, 195, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(520, 196, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(521, 197, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(521, 199, 198);
        lightClassmapListener2.putLineTouchPoint(523, 200, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(524, 201, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(525, 202, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(526, 203, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(528, 204, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(529, 205, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(530, 206, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(532, 207, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(532, 209, 208);
        lightClassmapListener2.putLineTouchPoint(533, 210, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(537, 211, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(538, 212, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(539, 213, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(541, 214, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(541, 216, 215);
        lightClassmapListener2.putJumpTouchPoint(541, 218, 217);
        lightClassmapListener2.putJumpTouchPoint(541, 220, 219);
        lightClassmapListener2.putLineTouchPoint(543, 221, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(544, 222, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(545, 223, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(546, 224, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(546, 225, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(548, 226, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(548, 228, 227);
        lightClassmapListener2.putLineTouchPoint(549, 229, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(551, 230, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(553, 231, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(553, 233, 232);
        lightClassmapListener2.putLineTouchPoint(557, 234, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(561, 235, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(561, 237, 236);
        lightClassmapListener2.putLineTouchPoint(562, 238, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(565, 239, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(566, 240, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(586, 241, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(588, 242, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(589, 243, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(589, 245, 244);
        lightClassmapListener2.putLineTouchPoint(590, 246, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(593, 247, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(594, 248, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(594, 250, 249);
        lightClassmapListener2.putLineTouchPoint(595, 251, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(597, 252, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(598, 253, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(598, 255, 254);
        lightClassmapListener2.putLineTouchPoint(599, 256, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(601, 257, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(624, 258, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(626, 259, "clear", "()V");
        lightClassmapListener2.putJumpTouchPoint(626, 261, 260);
        lightClassmapListener2.putLineTouchPoint(627, 262, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(629, 263, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(643, 264, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(646, 265, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(647, 266, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(649, 267, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(651, 268, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(651, 270, 269);
        lightClassmapListener2.putLineTouchPoint(653, 271, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(654, 272, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(655, 273, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(656, 274, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(657, 275, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(660, 276, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(661, 277, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(662, 278, "clear", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(667, 279, "getNumActive", "()I");
        lightClassmapListener2.putLineTouchPoint(673, 280, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(674, 281, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(676, 282, "getNumIdle", "()I");
        lightClassmapListener2.putJumpTouchPoint(676, 284, 283);
        lightClassmapListener2.putLineTouchPoint(677, 285, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(680, 286, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(686, 287, "getNumActive", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putLineTouchPoint(687, 288, "getNumActive", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putJumpTouchPoint(687, 290, 289);
        lightClassmapListener2.putLineTouchPoint(688, 291, "getNumActive", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putLineTouchPoint(689, 292, "getNumActive", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putLineTouchPoint(691, 293, "getNumActive", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putLineTouchPoint(698, 294, "getNumIdle", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putLineTouchPoint(699, 295, "getNumIdle", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putJumpTouchPoint(699, 297, 296);
        lightClassmapListener2.putLineTouchPoint(714, 298, "close", "()V");
        lightClassmapListener2.putJumpTouchPoint(714, 300, 299);
        lightClassmapListener2.putLineTouchPoint(715, 301, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(718, 302, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(719, 303, "close", "()V");
        lightClassmapListener2.putJumpTouchPoint(719, 305, 304);
        lightClassmapListener2.putLineTouchPoint(720, 306, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(725, 307, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(727, 308, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(729, 309, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(731, 310, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(734, 311, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(735, 312, "close", "()V");
        lightClassmapListener2.putJumpTouchPoint(735, 314, 313);
        lightClassmapListener2.putLineTouchPoint(736, 315, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(740, 316, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(741, 317, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(742, 318, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(752, 319, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(754, 320, "clearOldest", "()V");
        lightClassmapListener2.putJumpTouchPoint(754, 322, 321);
        lightClassmapListener2.putLineTouchPoint(755, 323, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(758, 324, "clearOldest", "()V");
        lightClassmapListener2.putJumpTouchPoint(758, 326, 325);
        lightClassmapListener2.putLineTouchPoint(759, 327, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(760, 328, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(761, 329, "clearOldest", "()V");
        lightClassmapListener2.putJumpTouchPoint(761, 331, 330);
        lightClassmapListener2.putLineTouchPoint(764, 332, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(765, 333, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(767, 334, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(771, 335, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(772, 336, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(773, 337, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(775, 338, "clearOldest", "()V");
        lightClassmapListener2.putJumpTouchPoint(775, 340, 339);
        lightClassmapListener2.putJumpTouchPoint(775, 342, 341);
        lightClassmapListener2.putLineTouchPoint(776, 343, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(781, 344, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(782, 345, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(784, 346, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(786, 347, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(787, 348, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(788, 349, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(789, 350, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(790, 351, "clearOldest", "()V");
        lightClassmapListener2.putJumpTouchPoint(790, 353, 352);
        lightClassmapListener2.putLineTouchPoint(791, 354, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(793, 355, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(794, 356, "clearOldest", "()V");
        lightClassmapListener2.putLineTouchPoint(810, 357, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(813, 358, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(814, 359, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(815, 360, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(816, 361, "reuseCapacity", "()V");
        lightClassmapListener2.putJumpTouchPoint(816, 363, 362);
        lightClassmapListener2.putLineTouchPoint(817, 364, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(818, 365, "reuseCapacity", "()V");
        lightClassmapListener2.putJumpTouchPoint(818, 367, 366);
        lightClassmapListener2.putLineTouchPoint(819, 368, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(820, 369, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(821, 370, "reuseCapacity", "()V");
        lightClassmapListener2.putJumpTouchPoint(821, 372, 371);
        lightClassmapListener2.putJumpTouchPoint(821, 374, 373);
        lightClassmapListener2.putLineTouchPoint(822, 375, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(823, 376, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(824, 377, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(827, 378, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(830, 379, "reuseCapacity", "()V");
        lightClassmapListener2.putJumpTouchPoint(830, 381, 380);
        lightClassmapListener2.putLineTouchPoint(831, 382, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(833, 383, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(834, 384, "reuseCapacity", "()V");
        lightClassmapListener2.putJumpTouchPoint(834, 386, 385);
        lightClassmapListener2.putLineTouchPoint(835, 387, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(837, 388, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(838, 389, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(840, 390, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(841, 391, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(841, 392, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(843, 393, "reuseCapacity", "()V");
        lightClassmapListener2.putLineTouchPoint(853, 394, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putJumpTouchPoint(853, 396, 395);
        lightClassmapListener2.putLineTouchPoint(854, 397, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putLineTouchPoint(855, 398, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putJumpTouchPoint(855, 400, 399);
        lightClassmapListener2.putLineTouchPoint(856, 401, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putLineTouchPoint(857, 402, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putLineTouchPoint(858, 403, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putJumpTouchPoint(858, 405, 404);
        lightClassmapListener2.putLineTouchPoint(859, 406, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putLineTouchPoint(862, 407, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putLineTouchPoint(863, 408, "hasBorrowWaiters", "()Z");
        lightClassmapListener2.putLineTouchPoint(876, 409, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(878, 410, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(878, 412, 411);
        lightClassmapListener2.putLineTouchPoint(879, 413, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(882, 414, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(883, 415, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(885, 416, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(886, 417, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(887, 418, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(888, 419, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(889, 420, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(891, 421, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(893, 422, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(893, 424, 423);
        lightClassmapListener2.putLineTouchPoint(893, 425, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(894, 426, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(894, 428, 427);
        lightClassmapListener2.putJumpTouchPoint(894, 430, 429);
        lightClassmapListener2.putLineTouchPoint(895, 431, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(895, 433, 432);
        lightClassmapListener2.putLineTouchPoint(896, 434, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(896, 436, 435);
        lightClassmapListener2.putLineTouchPoint(897, 437, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(898, 438, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(899, 439, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(901, 440, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(903, 441, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(904, 442, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(905, 443, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(907, 444, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(907, 446, 445);
        lightClassmapListener2.putLineTouchPoint(908, 447, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(909, 448, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(910, 449, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(910, 451, 450);
        lightClassmapListener2.putLineTouchPoint(911, 452, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(914, 453, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(915, 454, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(916, 455, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(916, 457, 456);
        lightClassmapListener2.putLineTouchPoint(917, 458, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(919, 459, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(920, 460, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(922, 461, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(922, 463, 462);
        lightClassmapListener2.putLineTouchPoint(924, 464, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(928, 465, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(929, 466, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(930, 467, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(933, 468, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(934, 469, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(935, 470, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(936, 471, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(938, 472, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(938, 474, 473);
        lightClassmapListener2.putLineTouchPoint(941, 475, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(942, 476, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(950, 477, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(950, 478, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(951, 479, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(952, 480, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(955, 481, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(956, 482, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(958, 483, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(959, 484, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(961, 485, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(961, 487, 486);
        lightClassmapListener2.putLineTouchPoint(962, 488, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(963, 489, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(965, 490, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(965, 492, 491);
        lightClassmapListener2.putLineTouchPoint(966, 493, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(968, 494, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(969, 495, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(970, 496, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(971, 497, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(972, 498, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(973, 499, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(974, 500, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(974, 502, 501);
        lightClassmapListener2.putLineTouchPoint(975, 503, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(975, 505, 504);
        lightClassmapListener2.putLineTouchPoint(976, 506, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(977, 507, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(980, 508, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(981, 509, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(982, 510, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(983, 511, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(984, 512, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(988, 513, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(988, 515, 514);
        lightClassmapListener2.putLineTouchPoint(994, 516, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(995, 517, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(1007, 518, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1008, 519, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1011, 520, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1013, 521, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putJumpTouchPoint(1013, 523, 522);
        lightClassmapListener2.putLineTouchPoint(1014, 524, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1015, 525, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putJumpTouchPoint(1015, 527, 526);
        lightClassmapListener2.putJumpTouchPoint(1015, 529, 528);
        lightClassmapListener2.putLineTouchPoint(1016, 530, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1017, 531, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putJumpTouchPoint(1017, 533, 532);
        lightClassmapListener2.putLineTouchPoint(1018, 534, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1020, 535, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1023, 536, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1025, 537, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1027, 538, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1028, 539, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1031, 540, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putJumpTouchPoint(1031, 542, 541);
        lightClassmapListener2.putJumpTouchPoint(1031, 544, 543);
        lightClassmapListener2.putJumpTouchPoint(1031, 546, 545);
        lightClassmapListener2.putLineTouchPoint(1033, 547, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1034, 548, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1035, 549, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1039, 550, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1041, 551, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1042, 552, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1043, 553, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1044, 554, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1045, 555, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1046, 556, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1048, 557, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1049, 558, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1050, 559, "create", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(1066, 560, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1069, 561, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1071, 562, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putJumpTouchPoint(1071, 564, 563);
        lightClassmapListener2.putJumpTouchPoint(1071, 566, 565);
        lightClassmapListener2.putLineTouchPoint(1072, 567, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1073, 568, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1076, 569, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1078, 570, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1079, 571, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1080, 572, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1081, 573, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1082, 574, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1084, 575, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1087, 576, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1087, 577, "destroy", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;Z)Z");
        lightClassmapListener2.putLineTouchPoint(1104, 578, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1105, 579, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1107, 580, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1108, 581, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1109, 582, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putJumpTouchPoint(1109, 584, 583);
        lightClassmapListener2.putLineTouchPoint(1111, 585, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1112, 586, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1113, 587, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1114, 588, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1115, 589, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putJumpTouchPoint(1115, 591, 590);
        lightClassmapListener2.putLineTouchPoint(1116, 592, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1117, 593, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1121, 594, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1122, 595, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1124, 596, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1127, 597, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1130, 598, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1131, 599, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1132, 600, "register", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;");
        lightClassmapListener2.putLineTouchPoint(1145, 601, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1146, 602, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1147, 603, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(1147, 605, 604);
        lightClassmapListener2.putJumpTouchPoint(1147, 607, 606);
        lightClassmapListener2.putLineTouchPoint(1149, 608, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1150, 609, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1152, 610, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(1152, 612, 611);
        lightClassmapListener2.putLineTouchPoint(1153, 613, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(1153, 615, 614);
        lightClassmapListener2.putLineTouchPoint(1157, 616, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1158, 617, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1161, 618, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1162, 619, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1164, 620, "deregister", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1168, 621, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(1169, 622, "ensureMinIdle", "()V");
        lightClassmapListener2.putJumpTouchPoint(1169, 624, 623);
        lightClassmapListener2.putLineTouchPoint(1170, 625, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(1173, 626, "ensureMinIdle", "()V");
        lightClassmapListener2.putJumpTouchPoint(1173, 628, 627);
        lightClassmapListener2.putLineTouchPoint(1174, 629, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(1175, 630, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(1176, 631, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(1188, 632, "ensureMinIdle", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1198, 633, "ensureMinIdle", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1200, 634, "ensureMinIdle", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(1200, 636, 635);
        lightClassmapListener2.putJumpTouchPoint(1200, 638, 637);
        lightClassmapListener2.putLineTouchPoint(1200, 639, "ensureMinIdle", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1201, 640, "ensureMinIdle", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1203, 641, "ensureMinIdle", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1218, 642, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1219, 643, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1221, 644, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1222, 645, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1224, 646, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1225, 647, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1226, 648, "addObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1238, 649, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putJumpTouchPoint(1238, 651, 650);
        lightClassmapListener2.putLineTouchPoint(1239, 652, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(1240, 653, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(1241, 654, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(1242, 655, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putJumpTouchPoint(1242, 657, 656);
        lightClassmapListener2.putLineTouchPoint(1243, 658, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(1245, 659, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(1248, 660, "addIdleObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(1259, 661, "preparePool", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1260, 662, "preparePool", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(1260, 664, 663);
        lightClassmapListener2.putLineTouchPoint(1261, 665, "preparePool", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1263, 666, "preparePool", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1264, 667, "preparePool", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1273, 668, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(1274, 669, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(1275, 670, "getNumTests", "()I");
        lightClassmapListener2.putJumpTouchPoint(1275, 672, 671);
        lightClassmapListener2.putLineTouchPoint(1276, 673, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(1278, 674, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(1292, 675, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putJumpTouchPoint(1292, 677, 676);
        lightClassmapListener2.putLineTouchPoint(1293, 678, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1297, 679, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1298, 680, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1300, 681, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1304, 682, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1305, 683, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putJumpTouchPoint(1305, 685, 684);
        lightClassmapListener2.putLineTouchPoint(1306, 686, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1306, 687, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1307, 688, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1308, 689, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1312, 690, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putJumpTouchPoint(1312, 692, 691);
        lightClassmapListener2.putLineTouchPoint(1313, 693, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1314, 694, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1317, 695, "calculateDeficit", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)I");
        lightClassmapListener2.putLineTouchPoint(1325, 696, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1327, 697, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1328, 698, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1328, 700, 699);
        lightClassmapListener2.putLineTouchPoint(1329, 701, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1330, 702, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1330, 704, 703);
        lightClassmapListener2.putLineTouchPoint(1331, 705, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1332, 706, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1333, 707, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1333, 709, 708);
        lightClassmapListener2.putJumpTouchPoint(1333, 711, 710);
        lightClassmapListener2.putLineTouchPoint(1334, 712, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1334, 713, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1335, 714, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1336, 715, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1339, 716, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1340, 717, "getNumActivePerKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1353, 718, "getNumWaiters", "()I");
        lightClassmapListener2.putLineTouchPoint(1355, 719, "getNumWaiters", "()I");
        lightClassmapListener2.putJumpTouchPoint(1355, 721, 720);
        lightClassmapListener2.putLineTouchPoint(1356, 722, "getNumWaiters", "()I");
        lightClassmapListener2.putLineTouchPoint(1358, 723, "getNumWaiters", "()I");
        lightClassmapListener2.putJumpTouchPoint(1358, 725, 724);
        lightClassmapListener2.putLineTouchPoint(1360, 726, "getNumWaiters", "()I");
        lightClassmapListener2.putLineTouchPoint(1364, 727, "getNumWaiters", "()I");
        lightClassmapListener2.putLineTouchPoint(1377, 728, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1379, 729, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1379, 731, 730);
        lightClassmapListener2.putLineTouchPoint(1380, 732, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1381, 733, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1381, 735, 734);
        lightClassmapListener2.putLineTouchPoint(1382, 736, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1382, 738, 737);
        lightClassmapListener2.putLineTouchPoint(1383, 739, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1383, 740, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1384, 741, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1386, 742, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1389, 743, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1390, 744, "getNumWaitersByKey", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1406, 745, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1409, 746, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1409, 748, 747);
        lightClassmapListener2.putLineTouchPoint(1410, 749, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1411, 750, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1411, 752, 751);
        lightClassmapListener2.putLineTouchPoint(1412, 753, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1414, 754, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1415, 755, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(1415, 757, 756);
        lightClassmapListener2.putLineTouchPoint(1416, 758, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1417, 759, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1419, 760, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1420, 761, "listAllObjects", "()Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(1503, 762, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1505, 763, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1507, 764, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1520, 765, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1528, 766, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1529, 767, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1536, 768, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1537, 769, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1538, 770, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericKeyedObjectPoolConfig;)V");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/GenericKeyedObjectPool");
        lightClassmapListener2.setSource("GenericKeyedObjectPool.java");
        GenericKeyedObjectPool.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }

    private class ObjectDeque<S> {
        public static final transient int[] __cobertura_counters;
        private final LinkedBlockingDeque<PooledObject<S>> idleObjects;
        private final AtomicInteger createCount;
        private final Map<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>> allObjects;
        private final AtomicLong numInterested;
        final /* synthetic */ GenericKeyedObjectPool this$0;

        /*
         * WARNING - void declaration
         */
        public ObjectDeque(GenericKeyedObjectPool genericKeyedObjectPool, boolean bl) {
            void fairness;
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            this.this$0 = genericKeyedObjectPool;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.createCount = new AtomicInteger(0);
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.allObjects = new ConcurrentHashMap<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>>();
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            this.numInterested = new AtomicLong(0L);
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
            this.idleObjects = new LinkedBlockingDeque((boolean)fairness);
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
        }

        public LinkedBlockingDeque<PooledObject<S>> getIdleObjects() {
            int n = 0;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            return this.idleObjects;
        }

        public AtomicInteger getCreateCount() {
            int n = 0;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            return this.createCount;
        }

        public AtomicLong getNumInterested() {
            int n = 0;
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            return this.numInterested;
        }

        public Map<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>> getAllObjects() {
            int n = 0;
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            return this.allObjects;
        }

        static /* synthetic */ LinkedBlockingDeque access$000(ObjectDeque objectDeque) {
            ObjectDeque x0;
            ObjectDeque.__cobertura_init();
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            return x0.idleObjects;
        }

        static {
            ObjectDeque.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[12];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1429, 1, "access$000", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque;)Lorg/apache/commons/pool2/impl/LinkedBlockingDeque;");
            lightClassmapListener2.putLineTouchPoint(1437, 2, "<init>", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;Z)V");
            lightClassmapListener2.putLineTouchPoint(1443, 3, "<init>", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;Z)V");
            lightClassmapListener2.putLineTouchPoint(1452, 4, "<init>", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;Z)V");
            lightClassmapListener2.putLineTouchPoint(1459, 5, "<init>", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;Z)V");
            lightClassmapListener2.putLineTouchPoint(1460, 6, "<init>", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;Z)V");
            lightClassmapListener2.putLineTouchPoint(1461, 7, "<init>", "(Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;Z)V");
            lightClassmapListener2.putLineTouchPoint(1469, 8, "getIdleObjects", "()Lorg/apache/commons/pool2/impl/LinkedBlockingDeque;");
            lightClassmapListener2.putLineTouchPoint(1479, 9, "getCreateCount", "()Ljava/util/concurrent/atomic/AtomicInteger;");
            lightClassmapListener2.putLineTouchPoint(1488, 10, "getNumInterested", "()Ljava/util/concurrent/atomic/AtomicLong;");
            lightClassmapListener2.putLineTouchPoint(1497, 11, "getAllObjects", "()Ljava/util/Map;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/GenericKeyedObjectPool$ObjectDeque");
            lightClassmapListener2.setSource("GenericKeyedObjectPool.java");
            ObjectDeque.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }
}

