/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Deque;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.TrackedUse;

public class DefaultPooledObject<T>
implements PooledObject<T> {
    public static final transient int[] __cobertura_counters;
    private final T object;
    private PooledObjectState state;
    private final long createTime;
    private volatile long lastBorrowTime;
    private volatile long lastUseTime;
    private volatile long lastReturnTime;
    private volatile boolean logAbandoned;
    private volatile Exception borrowedBy;
    private volatile Exception usedBy;
    private volatile long borrowedCount;

    /*
     * WARNING - void declaration
     */
    public DefaultPooledObject(T t) {
        void object;
        int n = 0;
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
        this.state = PooledObjectState.IDLE;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        this.createTime = System.currentTimeMillis();
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        this.lastBorrowTime = this.createTime;
        __cobertura_counters[5] = __cobertura_counters[5] + 1;
        this.lastUseTime = this.createTime;
        __cobertura_counters[6] = __cobertura_counters[6] + 1;
        this.lastReturnTime = this.createTime;
        __cobertura_counters[7] = __cobertura_counters[7] + 1;
        this.logAbandoned = false;
        __cobertura_counters[8] = __cobertura_counters[8] + 1;
        this.borrowedBy = null;
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
        this.usedBy = null;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        this.borrowedCount = 0L;
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        this.object = object;
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
    }

    @Override
    public T getObject() {
        int n = 0;
        __cobertura_counters[14] = __cobertura_counters[14] + 1;
        return this.object;
    }

    @Override
    public long getCreateTime() {
        int n = 0;
        __cobertura_counters[15] = __cobertura_counters[15] + 1;
        return this.createTime;
    }

    @Override
    public long getActiveTimeMillis() {
        int n = 0;
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
        long rTime = this.lastReturnTime;
        __cobertura_counters[17] = __cobertura_counters[17] + 1;
        long bTime = this.lastBorrowTime;
        __cobertura_counters[18] = __cobertura_counters[18] + 1;
        n = 20;
        if (rTime > bTime) {
            __cobertura_counters[19] = __cobertura_counters[19] + 1;
            n = 0;
            __cobertura_counters[21] = __cobertura_counters[21] + 1;
            return rTime - bTime;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        return System.currentTimeMillis() - bTime;
    }

    @Override
    public long getIdleTimeMillis() {
        long l;
        int n = 0;
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        long elapsed = System.currentTimeMillis() - this.lastReturnTime;
        __cobertura_counters[24] = __cobertura_counters[24] + 1;
        n = 26;
        if (elapsed >= 0L) {
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            n = 0;
            l = elapsed;
        } else {
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            l = 0L;
        }
        return l;
    }

    @Override
    public long getLastBorrowTime() {
        int n = 0;
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        return this.lastBorrowTime;
    }

    @Override
    public long getLastReturnTime() {
        int n = 0;
        __cobertura_counters[28] = __cobertura_counters[28] + 1;
        return this.lastReturnTime;
    }

    public long getBorrowedCount() {
        int n = 0;
        __cobertura_counters[29] = __cobertura_counters[29] + 1;
        return this.borrowedCount;
    }

    @Override
    public long getLastUsedTime() {
        int n = 0;
        __cobertura_counters[30] = __cobertura_counters[30] + 1;
        n = 32;
        if (this.object instanceof TrackedUse) {
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            n = 0;
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            return Math.max(((TrackedUse)this.object).getLastUsed(), this.lastUseTime);
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[34] = __cobertura_counters[34] + 1;
        return this.lastUseTime;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(PooledObject<T> pooledObject) {
        void other;
        int n = 0;
        __cobertura_counters[35] = __cobertura_counters[35] + 1;
        long lastActiveDiff = this.getLastReturnTime() - other.getLastReturnTime();
        __cobertura_counters[36] = __cobertura_counters[36] + 1;
        n = 38;
        if (lastActiveDiff == 0L) {
            __cobertura_counters[37] = __cobertura_counters[37] + 1;
            n = 0;
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            return System.identityHashCode(this) - System.identityHashCode(other);
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[40] = __cobertura_counters[40] + 1;
        return (int)Math.min(Math.max(lastActiveDiff, Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        int n = 0;
        __cobertura_counters[41] = __cobertura_counters[41] + 1;
        StringBuilder result = new StringBuilder();
        __cobertura_counters[42] = __cobertura_counters[42] + 1;
        result.append("Object: ");
        __cobertura_counters[43] = __cobertura_counters[43] + 1;
        result.append(this.object.toString());
        __cobertura_counters[44] = __cobertura_counters[44] + 1;
        result.append(", State: ");
        __cobertura_counters[45] = __cobertura_counters[45] + 1;
        DefaultPooledObject defaultPooledObject = this;
        synchronized (defaultPooledObject) {
            __cobertura_counters[46] = __cobertura_counters[46] + 1;
            result.append(this.state.toString());
            __cobertura_counters[47] = __cobertura_counters[47] + 1;
        }
        __cobertura_counters[48] = __cobertura_counters[48] + 1;
        return result.toString();
    }

    @Override
    public synchronized boolean startEvictionTest() {
        int n = 0;
        __cobertura_counters[49] = __cobertura_counters[49] + 1;
        n = 51;
        if (this.state == PooledObjectState.IDLE) {
            __cobertura_counters[50] = __cobertura_counters[50] + 1;
            n = 0;
            __cobertura_counters[52] = __cobertura_counters[52] + 1;
            this.state = PooledObjectState.EVICTION;
            __cobertura_counters[53] = __cobertura_counters[53] + 1;
            return true;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[54] = __cobertura_counters[54] + 1;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean endEvictionTest(Deque<PooledObject<T>> deque) {
        int n = 0;
        __cobertura_counters[55] = __cobertura_counters[55] + 1;
        n = 57;
        if (this.state == PooledObjectState.EVICTION) {
            __cobertura_counters[56] = __cobertura_counters[56] + 1;
            n = 0;
            __cobertura_counters[58] = __cobertura_counters[58] + 1;
            this.state = PooledObjectState.IDLE;
            __cobertura_counters[59] = __cobertura_counters[59] + 1;
            return true;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[60] = __cobertura_counters[60] + 1;
        n = 62;
        if (this.state == PooledObjectState.EVICTION_RETURN_TO_HEAD) {
            void idleQueue;
            __cobertura_counters[61] = __cobertura_counters[61] + 1;
            n = 0;
            __cobertura_counters[63] = __cobertura_counters[63] + 1;
            this.state = PooledObjectState.IDLE;
            __cobertura_counters[64] = __cobertura_counters[64] + 1;
            n = 66;
            if (!idleQueue.offerFirst(this)) {
                __cobertura_counters[65] = __cobertura_counters[65] + 1;
                n = 0;
            }
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[67] = __cobertura_counters[67] + 1;
        return false;
    }

    @Override
    public synchronized boolean allocate() {
        int n = 0;
        __cobertura_counters[68] = __cobertura_counters[68] + 1;
        n = 70;
        if (this.state == PooledObjectState.IDLE) {
            __cobertura_counters[69] = __cobertura_counters[69] + 1;
            n = 0;
            __cobertura_counters[71] = __cobertura_counters[71] + 1;
            this.state = PooledObjectState.ALLOCATED;
            __cobertura_counters[72] = __cobertura_counters[72] + 1;
            this.lastBorrowTime = System.currentTimeMillis();
            __cobertura_counters[73] = __cobertura_counters[73] + 1;
            this.lastUseTime = this.lastBorrowTime;
            __cobertura_counters[74] = __cobertura_counters[74] + 1;
            ++this.borrowedCount;
            __cobertura_counters[75] = __cobertura_counters[75] + 1;
            n = 77;
            if (this.logAbandoned) {
                __cobertura_counters[76] = __cobertura_counters[76] + 1;
                n = 0;
                __cobertura_counters[78] = __cobertura_counters[78] + 1;
                this.borrowedBy = new AbandonedObjectCreatedException();
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[79] = __cobertura_counters[79] + 1;
            return true;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[80] = __cobertura_counters[80] + 1;
        n = 82;
        if (this.state == PooledObjectState.EVICTION) {
            __cobertura_counters[81] = __cobertura_counters[81] + 1;
            n = 0;
            __cobertura_counters[83] = __cobertura_counters[83] + 1;
            this.state = PooledObjectState.EVICTION_RETURN_TO_HEAD;
            __cobertura_counters[84] = __cobertura_counters[84] + 1;
            return false;
        }
        int n4 = n;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n = 0;
        __cobertura_counters[85] = __cobertura_counters[85] + 1;
        return false;
    }

    @Override
    public synchronized boolean deallocate() {
        int n;
        block3: {
            block2: {
                n = 0;
                __cobertura_counters[86] = __cobertura_counters[86] + 1;
                n = 88;
                if (this.state == PooledObjectState.ALLOCATED) break block2;
                __cobertura_counters[87] = __cobertura_counters[87] + 1;
                n = 0;
                n = 90;
                if (this.state != PooledObjectState.RETURNING) break block3;
                __cobertura_counters[89] = __cobertura_counters[89] + 1;
                n = 0;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[91] = __cobertura_counters[91] + 1;
            this.state = PooledObjectState.IDLE;
            __cobertura_counters[92] = __cobertura_counters[92] + 1;
            this.lastReturnTime = System.currentTimeMillis();
            __cobertura_counters[93] = __cobertura_counters[93] + 1;
            this.borrowedBy = null;
            __cobertura_counters[94] = __cobertura_counters[94] + 1;
            return true;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[95] = __cobertura_counters[95] + 1;
        return false;
    }

    @Override
    public synchronized void invalidate() {
        int n = 0;
        __cobertura_counters[96] = __cobertura_counters[96] + 1;
        this.state = PooledObjectState.INVALID;
        __cobertura_counters[97] = __cobertura_counters[97] + 1;
    }

    @Override
    public void use() {
        int n = 0;
        __cobertura_counters[98] = __cobertura_counters[98] + 1;
        this.lastUseTime = System.currentTimeMillis();
        __cobertura_counters[99] = __cobertura_counters[99] + 1;
        this.usedBy = new Exception("The last code to use this object was:");
        __cobertura_counters[100] = __cobertura_counters[100] + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        void writer;
        int n = 0;
        __cobertura_counters[101] = __cobertura_counters[101] + 1;
        Exception borrowedByCopy = this.borrowedBy;
        __cobertura_counters[102] = __cobertura_counters[102] + 1;
        n = 104;
        if (borrowedByCopy != null) {
            __cobertura_counters[103] = __cobertura_counters[103] + 1;
            n = 0;
            __cobertura_counters[105] = __cobertura_counters[105] + 1;
            borrowedByCopy.printStackTrace((PrintWriter)writer);
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[106] = __cobertura_counters[106] + 1;
        Exception usedByCopy = this.usedBy;
        __cobertura_counters[107] = __cobertura_counters[107] + 1;
        n = 109;
        if (usedByCopy != null) {
            __cobertura_counters[108] = __cobertura_counters[108] + 1;
            n = 0;
            __cobertura_counters[110] = __cobertura_counters[110] + 1;
            usedByCopy.printStackTrace((PrintWriter)writer);
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[111] = __cobertura_counters[111] + 1;
    }

    @Override
    public synchronized PooledObjectState getState() {
        int n = 0;
        __cobertura_counters[112] = __cobertura_counters[112] + 1;
        return this.state;
    }

    @Override
    public synchronized void markAbandoned() {
        int n = 0;
        __cobertura_counters[113] = __cobertura_counters[113] + 1;
        this.state = PooledObjectState.ABANDONED;
        __cobertura_counters[114] = __cobertura_counters[114] + 1;
    }

    @Override
    public synchronized void markReturning() {
        int n = 0;
        __cobertura_counters[115] = __cobertura_counters[115] + 1;
        this.state = PooledObjectState.RETURNING;
        __cobertura_counters[116] = __cobertura_counters[116] + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLogAbandoned(boolean bl) {
        void logAbandoned;
        int n = 0;
        __cobertura_counters[117] = __cobertura_counters[117] + 1;
        this.logAbandoned = logAbandoned;
        __cobertura_counters[118] = __cobertura_counters[118] + 1;
    }

    static {
        DefaultPooledObject.__cobertura_init();
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[119];
            TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/DefaultPooledObject");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(40, 1, "compareTo", "(Ljava/lang/Object;)I");
        lightClassmapListener2.putLineTouchPoint(43, 2, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(44, 3, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(45, 4, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(46, 5, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(47, 6, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(48, 7, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(49, 8, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(50, 9, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(51, 10, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(59, 11, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(60, 12, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(61, 13, "<init>", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(65, 14, "getObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(70, 15, "getCreateTime", "()J");
        lightClassmapListener2.putLineTouchPoint(76, 16, "getActiveTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(77, 17, "getActiveTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(79, 18, "getActiveTimeMillis", "()J");
        lightClassmapListener2.putJumpTouchPoint(79, 20, 19);
        lightClassmapListener2.putLineTouchPoint(80, 21, "getActiveTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(82, 22, "getActiveTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(88, 23, "getIdleTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(92, 24, "getIdleTimeMillis", "()J");
        lightClassmapListener2.putJumpTouchPoint(92, 26, 25);
        lightClassmapListener2.putLineTouchPoint(97, 27, "getLastBorrowTime", "()J");
        lightClassmapListener2.putLineTouchPoint(102, 28, "getLastReturnTime", "()J");
        lightClassmapListener2.putLineTouchPoint(111, 29, "getBorrowedCount", "()J");
        lightClassmapListener2.putLineTouchPoint(125, 30, "getLastUsedTime", "()J");
        lightClassmapListener2.putJumpTouchPoint(125, 32, 31);
        lightClassmapListener2.putLineTouchPoint(126, 33, "getLastUsedTime", "()J");
        lightClassmapListener2.putLineTouchPoint(128, 34, "getLastUsedTime", "()J");
        lightClassmapListener2.putLineTouchPoint(134, 35, "compareTo", "(Lorg/apache/commons/pool2/PooledObject;)I");
        lightClassmapListener2.putLineTouchPoint(135, 36, "compareTo", "(Lorg/apache/commons/pool2/PooledObject;)I");
        lightClassmapListener2.putJumpTouchPoint(135, 38, 37);
        lightClassmapListener2.putLineTouchPoint(140, 39, "compareTo", "(Lorg/apache/commons/pool2/PooledObject;)I");
        lightClassmapListener2.putLineTouchPoint(143, 40, "compareTo", "(Lorg/apache/commons/pool2/PooledObject;)I");
        lightClassmapListener2.putLineTouchPoint(148, 41, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(149, 42, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(150, 43, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(151, 44, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(152, 45, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(153, 46, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(154, 47, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(155, 48, "toString", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(161, 49, "startEvictionTest", "()Z");
        lightClassmapListener2.putJumpTouchPoint(161, 51, 50);
        lightClassmapListener2.putLineTouchPoint(162, 52, "startEvictionTest", "()Z");
        lightClassmapListener2.putLineTouchPoint(163, 53, "startEvictionTest", "()Z");
        lightClassmapListener2.putLineTouchPoint(166, 54, "startEvictionTest", "()Z");
        lightClassmapListener2.putLineTouchPoint(172, 55, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putJumpTouchPoint(172, 57, 56);
        lightClassmapListener2.putLineTouchPoint(173, 58, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putLineTouchPoint(174, 59, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putLineTouchPoint(175, 60, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putJumpTouchPoint(175, 62, 61);
        lightClassmapListener2.putLineTouchPoint(176, 63, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putLineTouchPoint(177, 64, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putJumpTouchPoint(177, 66, 65);
        lightClassmapListener2.putLineTouchPoint(182, 67, "endEvictionTest", "(Ljava/util/Deque;)Z");
        lightClassmapListener2.putLineTouchPoint(192, 68, "allocate", "()Z");
        lightClassmapListener2.putJumpTouchPoint(192, 70, 69);
        lightClassmapListener2.putLineTouchPoint(193, 71, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(194, 72, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(195, 73, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(196, 74, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(197, 75, "allocate", "()Z");
        lightClassmapListener2.putJumpTouchPoint(197, 77, 76);
        lightClassmapListener2.putLineTouchPoint(198, 78, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(200, 79, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(201, 80, "allocate", "()Z");
        lightClassmapListener2.putJumpTouchPoint(201, 82, 81);
        lightClassmapListener2.putLineTouchPoint(203, 83, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(204, 84, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(208, 85, "allocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(219, 86, "deallocate", "()Z");
        lightClassmapListener2.putJumpTouchPoint(219, 88, 87);
        lightClassmapListener2.putJumpTouchPoint(219, 90, 89);
        lightClassmapListener2.putLineTouchPoint(221, 91, "deallocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(222, 92, "deallocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(223, 93, "deallocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(224, 94, "deallocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(227, 95, "deallocate", "()Z");
        lightClassmapListener2.putLineTouchPoint(235, 96, "invalidate", "()V");
        lightClassmapListener2.putLineTouchPoint(236, 97, "invalidate", "()V");
        lightClassmapListener2.putLineTouchPoint(240, 98, "use", "()V");
        lightClassmapListener2.putLineTouchPoint(241, 99, "use", "()V");
        lightClassmapListener2.putLineTouchPoint(242, 100, "use", "()V");
        lightClassmapListener2.putLineTouchPoint(246, 101, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putLineTouchPoint(247, 102, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putJumpTouchPoint(247, 104, 103);
        lightClassmapListener2.putLineTouchPoint(248, 105, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putLineTouchPoint(250, 106, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putLineTouchPoint(251, 107, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putJumpTouchPoint(251, 109, 108);
        lightClassmapListener2.putLineTouchPoint(252, 110, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putLineTouchPoint(254, 111, "printStackTrace", "(Ljava/io/PrintWriter;)V");
        lightClassmapListener2.putLineTouchPoint(262, 112, "getState", "()Lorg/apache/commons/pool2/PooledObjectState;");
        lightClassmapListener2.putLineTouchPoint(270, 113, "markAbandoned", "()V");
        lightClassmapListener2.putLineTouchPoint(271, 114, "markAbandoned", "()V");
        lightClassmapListener2.putLineTouchPoint(278, 115, "markReturning", "()V");
        lightClassmapListener2.putLineTouchPoint(279, 116, "markReturning", "()V");
        lightClassmapListener2.putLineTouchPoint(283, 117, "setLogAbandoned", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(284, 118, "setLogAbandoned", "(Z)V");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/DefaultPooledObject");
        lightClassmapListener2.setSource("DefaultPooledObject.java");
        DefaultPooledObject.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }

    static class AbandonedObjectCreatedException
    extends Exception {
        public static final transient int[] __cobertura_counters;
        private static final long serialVersionUID = 7398692158058772916L;
        private static final SimpleDateFormat format;
        private final long _createdTime;

        public AbandonedObjectCreatedException() {
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this._createdTime = System.currentTimeMillis();
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            String msg;
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                msg = format.format(new Date(this._createdTime));
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
            }
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            return msg;
        }

        static {
            AbandonedObjectCreatedException.__cobertura_init();
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            format = new SimpleDateFormat("'Pooled object created' yyyy-MM-dd HH:mm:ss Z 'by the following code has not been returned to the pool:'");
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[9];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/DefaultPooledObject$AbandonedObjectCreatedException");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(297, 1, "<clinit>", "()V");
            lightClassmapListener2.putLineTouchPoint(309, 2, "<init>", "()V");
            lightClassmapListener2.putLineTouchPoint(310, 3, "<init>", "()V");
            lightClassmapListener2.putLineTouchPoint(311, 4, "<init>", "()V");
            lightClassmapListener2.putLineTouchPoint(318, 5, "getMessage", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(319, 6, "getMessage", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(320, 7, "getMessage", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(321, 8, "getMessage", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/DefaultPooledObject$AbandonedObjectCreatedException");
            lightClassmapListener2.setSource("DefaultPooledObject.java");
            AbandonedObjectCreatedException.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }
}

