/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLinkedBlockingDeque {
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;
    LinkedBlockingDeque<Integer> deque;

    @Before
    public void setUp() {
        this.deque = new LinkedBlockingDeque(2);
    }

    @Test
    public void testConstructors() {
        LinkedBlockingDeque deque = new LinkedBlockingDeque();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)deque.remainingCapacity());
        deque = new LinkedBlockingDeque(2);
        Assert.assertEquals((long)2L, (long)deque.remainingCapacity());
        deque = new LinkedBlockingDeque(Arrays.asList(ONE, TWO));
        Assert.assertEquals((long)2L, (long)deque.size());
        try {
            deque = new LinkedBlockingDeque(Arrays.asList(ONE, null));
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddFirst() {
        this.deque.addFirst((Object)ONE);
        this.deque.addFirst((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        try {
            this.deque.addFirst((Object)THREE);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)2, (Object)this.deque.pop());
    }

    @Test
    public void testAddLast() {
        this.deque.addLast((Object)ONE);
        this.deque.addLast((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        try {
            this.deque.addLast((Object)THREE);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)1, (Object)this.deque.pop());
    }

    @Test
    public void testOfferFirst() {
        this.deque.offerFirst((Object)ONE);
        this.deque.offerFirst((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        try {
            this.deque.offerFirst(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)2, (Object)this.deque.pop());
    }

    @Test
    public void testOfferLast() {
        this.deque.offerLast((Object)ONE);
        this.deque.offerLast((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        try {
            this.deque.offerLast(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)1, (Object)this.deque.pop());
    }

    @Test
    public void testPutFirst() throws InterruptedException {
        try {
            this.deque.putFirst(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.deque.putFirst((Object)ONE);
        this.deque.putFirst((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        Assert.assertEquals((Object)2, (Object)this.deque.pop());
    }

    @Test
    public void testPutLast() throws InterruptedException {
        try {
            this.deque.putLast(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.deque.putLast((Object)ONE);
        this.deque.putLast((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        Assert.assertEquals((Object)1, (Object)this.deque.pop());
    }

    @Test
    public void testOfferFirstWithTimeout() throws InterruptedException {
        try {
            this.deque.offerFirst(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)ONE, 50L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)TWO, 50L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.deque.offerFirst((Object)THREE, 50L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOfferLastWithTimeout() throws InterruptedException {
        try {
            this.deque.offerLast(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.deque.offerLast((Object)ONE, 50L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.deque.offerLast((Object)TWO, 50L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.deque.offerLast((Object)THREE, 50L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testRemoveFirst() {
        try {
            this.deque.removeFirst();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.removeFirst());
        try {
            this.deque.removeFirst();
            this.deque.removeFirst();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLast() {
        try {
            this.deque.removeLast();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)2, (Object)this.deque.removeLast());
        try {
            this.deque.removeLast();
            this.deque.removeLast();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testPollFirst() {
        Assert.assertNull((Object)this.deque.pollFirst());
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assert.assertEquals((Object)2, (Object)this.deque.pollFirst());
    }

    @Test
    public void testPollLast() {
        Assert.assertNull((Object)this.deque.pollLast());
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assert.assertEquals((Object)1, (Object)this.deque.pollLast());
    }

    @Test
    public void testTakeFirst() throws InterruptedException {
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assert.assertEquals((Object)2, (Object)this.deque.takeFirst());
    }

    @Test
    public void testTakeLast() throws InterruptedException {
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assert.assertEquals((Object)1, (Object)this.deque.takeLast());
    }

    @Test
    public void testPollFirstWithTimeout() throws InterruptedException {
        Assert.assertNull((Object)this.deque.pollFirst());
        Assert.assertNull((Object)this.deque.pollFirst(50L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testPollLastWithTimeout() throws InterruptedException {
        Assert.assertNull((Object)this.deque.pollLast());
        Assert.assertNull((Object)this.deque.pollLast(50L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testGetFirst() {
        try {
            this.deque.getFirst();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.getFirst());
    }

    @Test
    public void testGetLast() {
        try {
            this.deque.getLast();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)2, (Object)this.deque.getLast());
    }

    @Test
    public void testPeekFirst() {
        Assert.assertNull((Object)this.deque.peekFirst());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.peekFirst());
    }

    @Test
    public void testPeekLast() {
        Assert.assertNull((Object)this.deque.peekLast());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)2, (Object)this.deque.peekLast());
    }

    @Test
    public void testRemoveLastOccurence() {
        Assert.assertFalse((boolean)this.deque.removeLastOccurrence(null));
        Assert.assertFalse((boolean)this.deque.removeLastOccurrence((Object)ONE));
        this.deque.add((Object)ONE);
        this.deque.add((Object)ONE);
        Assert.assertTrue((boolean)this.deque.removeLastOccurrence((Object)ONE));
        Assert.assertTrue((this.deque.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAdd() {
        Assert.assertTrue((boolean)this.deque.add((Object)ONE));
        Assert.assertTrue((boolean)this.deque.add((Object)TWO));
        try {
            Assert.assertTrue((boolean)this.deque.add((Object)THREE));
            Assert.fail((String)"Not supposed to get here");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Assert.assertTrue((boolean)this.deque.add(null));
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testOffer() {
        Assert.assertTrue((boolean)this.deque.offer((Object)ONE));
        Assert.assertTrue((boolean)this.deque.offer((Object)TWO));
        Assert.assertFalse((boolean)this.deque.offer((Object)THREE));
        try {
            this.deque.offer(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPut() throws InterruptedException {
        try {
            this.deque.put(null);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.deque.put((Object)ONE);
        this.deque.put((Object)TWO);
    }

    @Test
    public void testOfferWithTimeout() throws InterruptedException {
        Assert.assertTrue((boolean)this.deque.offer((Object)ONE, 50L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.deque.offer((Object)TWO, 50L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.deque.offer((Object)THREE, 50L, TimeUnit.MILLISECONDS));
        try {
            this.deque.offer(null, 50L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() {
        try {
            this.deque.remove();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.remove());
    }

    @Test
    public void testTake() throws InterruptedException {
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)ONE));
        Assert.assertTrue((boolean)this.deque.offerFirst((Object)TWO));
        Assert.assertEquals((Object)2, (Object)this.deque.take());
    }

    @Test
    public void testPollWithTimeout() throws InterruptedException {
        Assert.assertNull((Object)this.deque.poll(50L, TimeUnit.MILLISECONDS));
        Assert.assertNull((Object)this.deque.poll(50L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testElement() {
        try {
            this.deque.element();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.element());
    }

    @Test
    public void testPeek() {
        Assert.assertNull((Object)this.deque.peek());
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.peek());
    }

    @Test
    public void testDrainTo() {
        ArrayList c = new ArrayList();
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.drainTo(c));
        Assert.assertEquals((long)2L, (long)c.size());
        c = new ArrayList();
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((long)1L, (long)this.deque.drainTo(c, 1));
        Assert.assertEquals((long)1L, (long)this.deque.size());
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertEquals((Object)1, c.iterator().next());
    }

    @Test
    public void testPush() {
        this.deque.push((Object)ONE);
        this.deque.push((Object)TWO);
        Assert.assertEquals((long)2L, (long)this.deque.size());
        try {
            this.deque.push((Object)THREE);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)2, (Object)this.deque.pop());
    }

    @Test
    public void testPop() {
        try {
            this.deque.pop();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Assert.assertEquals((Object)1, (Object)this.deque.pop());
        try {
            this.deque.pop();
            this.deque.pop();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testContains() {
        this.deque.add((Object)ONE);
        Assert.assertTrue((boolean)this.deque.contains((Object)ONE));
        Assert.assertFalse((boolean)this.deque.contains((Object)TWO));
        Assert.assertFalse((boolean)this.deque.contains(null));
        this.deque.add((Object)TWO);
        Assert.assertTrue((boolean)this.deque.contains((Object)TWO));
        Assert.assertFalse((boolean)this.deque.contains((Object)THREE));
    }

    @Test
    public void testToArray() {
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Object[] arr = this.deque.toArray();
        Assert.assertEquals((Object)1, (Object)arr[0]);
        Assert.assertEquals((Object)2, (Object)arr[1]);
        arr = this.deque.toArray((Object[])new Integer[0]);
        Assert.assertEquals((Object)1, (Object)arr[0]);
        Assert.assertEquals((Object)2, (Object)arr[1]);
        arr = this.deque.toArray((Object[])new Integer[this.deque.size()]);
        Assert.assertEquals((Object)1, (Object)arr[0]);
        Assert.assertEquals((Object)2, (Object)arr[1]);
    }

    @Test
    public void testClear() {
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        this.deque.clear();
        this.deque.add((Object)ONE);
        Assert.assertEquals((long)1L, (long)this.deque.size());
    }

    @Test
    public void testIterator() {
        try {
            this.deque.iterator().next();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Iterator iter = this.deque.iterator();
        Assert.assertEquals((Object)1, iter.next());
        iter.remove();
        Assert.assertEquals((Object)2, iter.next());
    }

    @Test
    public void testDescendingIterator() {
        try {
            this.deque.descendingIterator().next();
            Assert.fail((String)"Not supposed to get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.deque.add((Object)ONE);
        this.deque.add((Object)TWO);
        Iterator iter = this.deque.descendingIterator();
        Assert.assertEquals((Object)2, iter.next());
        iter.remove();
        Assert.assertEquals((Object)1, iter.next());
    }

    @Test(timeout=10000L)
    public void testPossibleBug() {
        this.deque = new LinkedBlockingDeque();
        for (int i = 0; i < 3; ++i) {
            this.deque.add((Object)i);
        }
        Iterator iter = this.deque.iterator();
        iter.next();
        this.deque.remove((Object)1);
        this.deque.remove((Object)0);
        this.deque.remove((Object)2);
        iter.next();
    }
}

