/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.MethodCall;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PrivateException;
import org.apache.commons.pool2.TestObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestKeyedObjectPool {
    protected static final String KEY = "key";
    private KeyedObjectPool<Object, Object> _pool = null;
    private final Integer ZERO = new Integer(0);
    private final Integer ONE = new Integer(1);

    protected abstract KeyedObjectPool<Object, Object> makeEmptyPool(KeyedPooledObjectFactory<Object, Object> var1);

    protected abstract Object makeKey(int var1);

    protected abstract boolean isFifo();

    protected abstract boolean isLifo();

    @After
    public void tearDown() throws Exception {
        this._pool = null;
    }

    protected abstract KeyedObjectPool<Object, Object> makeEmptyPool(int var1);

    protected abstract Object getNthObject(Object var1, int var2);

    @Test
    public void testClosedPoolBehavior() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        try {
            pool = this.makeEmptyPool((KeyedPooledObjectFactory<Object, Object>)new TestFactory());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object o1 = pool.borrowObject((Object)KEY);
        Object o2 = pool.borrowObject((Object)KEY);
        pool.close();
        try {
            pool.addObject((Object)KEY);
            Assert.fail((String)"A closed pool must throw an IllegalStateException when addObject is called.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            pool.borrowObject((Object)KEY);
            Assert.fail((String)"A closed pool must throw an IllegalStateException when borrowObject is called.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((String)"A closed pool shouldn't have any idle objects.", (long)0L, (long)pool.getNumIdle((Object)KEY));
        Assert.assertEquals((String)"A closed pool shouldn't have any idle objects.", (long)0L, (long)pool.getNumIdle());
        pool.getNumActive();
        pool.getNumActive((Object)KEY);
        pool.returnObject((Object)KEY, o1);
        Assert.assertEquals((String)"returnObject should not add items back into the idle object pool for a closed pool.", (long)0L, (long)pool.getNumIdle((Object)KEY));
        Assert.assertEquals((String)"returnObject should not add items back into the idle object pool for a closed pool.", (long)0L, (long)pool.getNumIdle());
        pool.invalidateObject((Object)KEY, o2);
        pool.clear((Object)KEY);
        pool.clear();
        pool.close();
    }

    @Test
    public void testKPOFAddObjectUsage() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObject((Object)KEY);
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ZERO));
        expectedMethods.add(new MethodCall("passivateObject", KEY, this.ZERO));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        try {
            pool.addObject((Object)KEY);
            Assert.fail((String)"Expected addObject to propagate makeObject exception.");
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject", KEY));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        this.clear(factory, expectedMethods);
        factory.setMakeObjectFail(false);
        factory.setPassivateObjectFail(true);
        try {
            pool.addObject((Object)KEY);
            Assert.fail((String)"Expected addObject to propagate passivateObject exception.");
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ONE));
        expectedMethods.add(new MethodCall("passivateObject", KEY, this.ONE));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testKPOFBorrowObjectUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        if (pool instanceof GenericKeyedObjectPool) {
            ((GenericKeyedObjectPool)pool).setTestOnBorrow(true);
        }
        pool.addObject((Object)KEY);
        this.clear(factory, expectedMethods);
        Object obj = pool.borrowObject((Object)KEY);
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", KEY, this.ZERO).returned(Boolean.TRUE));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.returnObject((Object)KEY, obj);
        this.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        try {
            obj = pool.borrowObject((Object)KEY);
            Assert.fail((String)"Expected borrowObject to propagate makeObject exception.");
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject", KEY));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        pool.addObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setActivateObjectFail(true);
        expectedMethods.add(new MethodCall("activateObject", KEY, obj));
        try {
            pool.borrowObject((Object)KEY);
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ONE));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        pool.addObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setValidateObjectFail(true);
        try {
            pool.borrowObject((Object)KEY);
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", KEY, this.ZERO));
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ONE));
        expectedMethods.add(new MethodCall("validateObject", KEY, this.ONE));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testKPOFReturnObjectUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        pool.returnObject((Object)KEY, obj);
        expectedMethods.add(new MethodCall("passivateObject", KEY, obj));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        pool.addObject((Object)KEY);
        pool.addObject((Object)KEY);
        pool.addObject((Object)KEY);
        Assert.assertEquals((long)3L, (long)pool.getNumIdle((Object)KEY));
        obj = pool.borrowObject((Object)KEY);
        obj = pool.borrowObject((Object)KEY);
        Assert.assertEquals((long)1L, (long)pool.getNumIdle((Object)KEY));
        Assert.assertEquals((long)2L, (long)pool.getNumActive((Object)KEY));
        this.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        pool.returnObject((Object)KEY, obj);
        expectedMethods.add(new MethodCall("passivateObject", KEY, obj));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        Assert.assertEquals((long)1L, (long)pool.getNumIdle((Object)KEY));
        Assert.assertEquals((long)1L, (long)pool.getNumActive((Object)KEY));
        this.reset(pool, factory, expectedMethods);
        obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        factory.setDestroyObjectFail(true);
        try {
            pool.returnObject((Object)KEY, obj);
            if (!(pool instanceof GenericKeyedObjectPool)) {
                Assert.fail((String)"Expecting destroyObject exception to be propagated");
            }
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        pool.close();
    }

    @Test
    public void testKPOFInvalidateObjectUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        pool.invalidateObject((Object)KEY, obj);
        expectedMethods.add(new MethodCall("destroyObject", KEY, obj));
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        try {
            pool.invalidateObject((Object)KEY, obj);
            Assert.fail((String)"Expecting destroy exception to propagate");
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        Thread.sleep(250L);
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assert.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testKPOFClearUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObjects((Object)KEY, 5);
        pool.clear();
        this.reset(pool, factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        pool.addObjects((Object)KEY, 5);
        pool.clear();
        pool.close();
    }

    @Test
    public void testKPOFCloseUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObjects((Object)KEY, 5);
        pool.close();
        try (KeyedObjectPool<Object, Object> pool2 = this.makeEmptyPool(factory);){
            this.reset(pool2, factory, expectedMethods);
            factory.setDestroyObjectFail(true);
            pool2.addObjects((Object)KEY, 5);
        }
    }

    @Test
    public void testToString() throws Exception {
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try (KeyedObjectPool<Object, Object> pool = this.makeEmptyPool(factory);){
            pool.toString();
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
    }

    @Test
    public void testBaseBorrowReturn() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Object obj0 = this._pool.borrowObject(keya);
        Assert.assertEquals((Object)this.getNthObject(keya, 0), (Object)obj0);
        Object obj1 = this._pool.borrowObject(keya);
        Assert.assertEquals((Object)this.getNthObject(keya, 1), (Object)obj1);
        Object obj2 = this._pool.borrowObject(keya);
        Assert.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        this._pool.returnObject(keya, obj2);
        obj2 = this._pool.borrowObject(keya);
        Assert.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        this._pool.returnObject(keya, obj1);
        obj1 = this._pool.borrowObject(keya);
        Assert.assertEquals((Object)this.getNthObject(keya, 1), (Object)obj1);
        this._pool.returnObject(keya, obj0);
        this._pool.returnObject(keya, obj2);
        obj2 = this._pool.borrowObject(keya);
        if (this.isLifo()) {
            Assert.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        }
        if (this.isFifo()) {
            Assert.assertEquals((Object)this.getNthObject(keya, 0), (Object)obj2);
        }
        obj0 = this._pool.borrowObject(keya);
        if (this.isLifo()) {
            Assert.assertEquals((Object)this.getNthObject(keya, 0), (Object)obj0);
        }
        if (this.isFifo()) {
            Assert.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj0);
        }
        this._pool.close();
    }

    @Test
    public void testBaseBorrow() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Object keyb = this.makeKey(1);
        Assert.assertEquals((String)"1", (Object)this.getNthObject(keya, 0), (Object)this._pool.borrowObject(keya));
        Assert.assertEquals((String)"2", (Object)this.getNthObject(keyb, 0), (Object)this._pool.borrowObject(keyb));
        Assert.assertEquals((String)"3", (Object)this.getNthObject(keyb, 1), (Object)this._pool.borrowObject(keyb));
        Assert.assertEquals((String)"4", (Object)this.getNthObject(keya, 1), (Object)this._pool.borrowObject(keya));
        Assert.assertEquals((String)"5", (Object)this.getNthObject(keyb, 2), (Object)this._pool.borrowObject(keyb));
        Assert.assertEquals((String)"6", (Object)this.getNthObject(keya, 2), (Object)this._pool.borrowObject(keya));
        this._pool.close();
    }

    @Test
    public void testBaseNumActiveNumIdle() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Object obj0 = this._pool.borrowObject(keya);
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Object obj1 = this._pool.borrowObject(keya);
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        this._pool.returnObject(keya, obj1);
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)1L, (long)this._pool.getNumIdle(keya));
        this._pool.returnObject(keya, obj0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive((Object)"xyzzy12345"));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle((Object)"xyzzy12345"));
        this._pool.close();
    }

    @Test
    public void testBaseNumActiveNumIdle2() throws Exception {
        try {
            this._pool = this.makeEmptyPool(6);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Object keyb = this.makeKey(1);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keyb));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keyb));
        Object objA0 = this._pool.borrowObject(keya);
        Object objB0 = this._pool.borrowObject(keyb);
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keyb));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keyb));
        Object objA1 = this._pool.borrowObject(keya);
        Object objB1 = this._pool.borrowObject(keyb);
        Assert.assertEquals((long)4L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive(keyb));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keyb));
        this._pool.returnObject(keya, objA0);
        this._pool.returnObject(keyb, objB0);
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)1L, (long)this._pool.getNumIdle(keya));
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keyb));
        Assert.assertEquals((long)1L, (long)this._pool.getNumIdle(keyb));
        this._pool.returnObject(keya, objA1);
        this._pool.returnObject(keyb, objB1);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)4L, (long)this._pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keyb));
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle(keyb));
        this._pool.close();
    }

    @Test
    public void testBaseClear() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Object obj0 = this._pool.borrowObject(keya);
        Object obj1 = this._pool.borrowObject(keya);
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        this._pool.returnObject(keya, obj1);
        this._pool.returnObject(keya, obj0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle(keya));
        this._pool.clear(keya);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Object obj2 = this._pool.borrowObject(keya);
        Assert.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        this._pool.close();
    }

    @Test
    public void testBaseInvalidateObject() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        Object obj0 = this._pool.borrowObject(keya);
        Object obj1 = this._pool.borrowObject(keya);
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        this._pool.invalidateObject(keya, obj0);
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        this._pool.invalidateObject(keya, obj1);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive(keya));
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(keya));
        this._pool.close();
    }

    @Test
    public void testBaseAddObject() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object key = this.makeKey(0);
        try {
            Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
            Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(key));
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive(key));
            this._pool.addObject(key);
            Assert.assertEquals((long)1L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
            Assert.assertEquals((long)1L, (long)this._pool.getNumIdle(key));
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive(key));
            Object obj = this._pool.borrowObject(key);
            Assert.assertEquals((Object)this.getNthObject(key, 0), (Object)obj);
            Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)1L, (long)this._pool.getNumActive());
            Assert.assertEquals((long)0L, (long)this._pool.getNumIdle(key));
            Assert.assertEquals((long)1L, (long)this._pool.getNumActive(key));
            this._pool.returnObject(key, obj);
            Assert.assertEquals((long)1L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
            Assert.assertEquals((long)1L, (long)this._pool.getNumIdle(key));
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive(key));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        finally {
            this._pool.close();
        }
    }

    private void reset(KeyedObjectPool<Object, Object> pool, FailingKeyedPooledObjectFactory factory, List<MethodCall> expectedMethods) throws Exception {
        pool.clear();
        this.clear(factory, expectedMethods);
        factory.reset();
    }

    private void clear(FailingKeyedPooledObjectFactory factory, List<MethodCall> expectedMethods) {
        factory.getMethodCalls().clear();
        expectedMethods.clear();
    }

    protected static class FailingKeyedPooledObjectFactory
    implements KeyedPooledObjectFactory<Object, Object> {
        private final List<MethodCall> methodCalls = new ArrayList<MethodCall>();
        private int count = 0;
        private boolean makeObjectFail;
        private boolean activateObjectFail;
        private boolean validateObjectFail;
        private boolean passivateObjectFail;
        private boolean destroyObjectFail;

        public void reset() {
            this.count = 0;
            this.getMethodCalls().clear();
            this.setMakeObjectFail(false);
            this.setActivateObjectFail(false);
            this.setValidateObjectFail(false);
            this.setPassivateObjectFail(false);
            this.setDestroyObjectFail(false);
        }

        public List<MethodCall> getMethodCalls() {
            return this.methodCalls;
        }

        public int getCurrentCount() {
            return this.count;
        }

        public void setCurrentCount(int count) {
            this.count = count;
        }

        public boolean isMakeObjectFail() {
            return this.makeObjectFail;
        }

        public void setMakeObjectFail(boolean makeObjectFail) {
            this.makeObjectFail = makeObjectFail;
        }

        public boolean isDestroyObjectFail() {
            return this.destroyObjectFail;
        }

        public void setDestroyObjectFail(boolean destroyObjectFail) {
            this.destroyObjectFail = destroyObjectFail;
        }

        public boolean isValidateObjectFail() {
            return this.validateObjectFail;
        }

        public void setValidateObjectFail(boolean validateObjectFail) {
            this.validateObjectFail = validateObjectFail;
        }

        public boolean isActivateObjectFail() {
            return this.activateObjectFail;
        }

        public void setActivateObjectFail(boolean activateObjectFail) {
            this.activateObjectFail = activateObjectFail;
        }

        public boolean isPassivateObjectFail() {
            return this.passivateObjectFail;
        }

        public void setPassivateObjectFail(boolean passivateObjectFail) {
            this.passivateObjectFail = passivateObjectFail;
        }

        public PooledObject<Object> makeObject(Object key) throws Exception {
            MethodCall call = new MethodCall("makeObject", key);
            this.methodCalls.add(call);
            int originalCount = this.count++;
            if (this.makeObjectFail) {
                throw new PrivateException("makeObject");
            }
            Integer obj = new Integer(originalCount);
            call.setReturned(obj);
            return new DefaultPooledObject((Object)obj);
        }

        public void activateObject(Object key, PooledObject<Object> obj) throws Exception {
            this.methodCalls.add(new MethodCall("activateObject", key, obj.getObject()));
            if (this.activateObjectFail) {
                throw new PrivateException("activateObject");
            }
        }

        public boolean validateObject(Object key, PooledObject<Object> obj) {
            MethodCall call = new MethodCall("validateObject", key, obj.getObject());
            this.methodCalls.add(call);
            if (this.validateObjectFail) {
                throw new PrivateException("validateObject");
            }
            boolean r = true;
            call.returned(true);
            return true;
        }

        public void passivateObject(Object key, PooledObject<Object> obj) throws Exception {
            this.methodCalls.add(new MethodCall("passivateObject", key, obj.getObject()));
            if (this.passivateObjectFail) {
                throw new PrivateException("passivateObject");
            }
        }

        public void destroyObject(Object key, PooledObject<Object> obj) throws Exception {
            this.methodCalls.add(new MethodCall("destroyObject", key, obj.getObject()));
            if (this.destroyObjectFail) {
                throw new PrivateException("destroyObject");
            }
        }
    }

    private static class TestFactory
    extends BaseKeyedPooledObjectFactory<Object, Object> {
        private TestFactory() {
        }

        public Object create(Object key) throws Exception {
            return new Object();
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }
}

