/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.PooledTestObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbandonedObjectPool {
    private GenericObjectPool<PooledTestObject> pool = null;
    private AbandonedConfig abandonedConfig = null;

    @Before
    public void setUp() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        this.pool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory(), new GenericObjectPoolConfig(), this.abandonedConfig);
    }

    @After
    public void tearDown() throws Exception {
        String poolName = this.pool.getJmxName().toString();
        this.pool.clear();
        this.pool.close();
        this.pool = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assert.assertEquals((String)msg.toString(), (long)0L, (long)registeredPoolCount);
    }

    @Test
    public void testConcurrentInvalidation() throws Exception {
        int i;
        int POOL_SIZE = 30;
        this.pool.setMaxTotal(30);
        this.pool.setMaxIdle(30);
        this.pool.setBlockWhenExhausted(false);
        ArrayList<PooledTestObject> vec = new ArrayList<PooledTestObject>();
        for (int i2 = 0; i2 < 30; ++i2) {
            vec.add((PooledTestObject)this.pool.borrowObject());
        }
        for (PooledTestObject element : vec) {
            element.setAbandoned(true);
        }
        int CONCURRENT_BORROWS = 5;
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new ConcurrentBorrower(vec);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
        for (PooledTestObject pto : vec) {
            if (!pto.isActive()) continue;
            this.pool.returnObject((Object)pto);
        }
        Assert.assertTrue((String)("numActive should have been 0, was " + this.pool.getNumActive()), (this.pool.getNumActive() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAbandonedReturn() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        this.pool.close();
        this.pool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory(200L, 0L), new GenericObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        PooledTestObject obj = null;
        for (int i = 0; i < 8; ++i) {
            obj = (PooledTestObject)this.pool.borrowObject();
        }
        Objects.requireNonNull(obj, "Unable to borrow object from pool");
        int deadMansHash = obj.hashCode();
        ConcurrentReturner returner = new ConcurrentReturner(obj);
        Thread.sleep(2000L);
        returner.start();
        Assert.assertTrue((((PooledTestObject)this.pool.borrowObject()).hashCode() != deadMansHash ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
    }

    @Test
    public void testAbandonedInvalidate() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        this.pool.close();
        this.pool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory(200L, 0L), new GenericObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        PooledTestObject obj = null;
        for (int i = 0; i < 5; ++i) {
            obj = (PooledTestObject)this.pool.borrowObject();
        }
        Thread.sleep(1000L);
        this.pool.invalidateObject((Object)obj);
        Thread.sleep(2000L);
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)5L, (long)this.pool.getDestroyedCount());
    }

    @Test
    public void testRemoveAbandonedWhileReturning() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        this.pool.close();
        this.pool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory(0L, 1000L), new GenericObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        this.pool.setTestOnReturn(true);
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject();
        Thread.sleep(50L);
        this.pool.returnObject((Object)obj);
        PooledTestObject obj2 = (PooledTestObject)this.pool.borrowObject();
        Assert.assertEquals((Object)obj, (Object)obj2);
        Assert.assertTrue((!obj2.isDestroyed() ? 1 : 0) != 0);
    }

    @Test
    public void testWhenExhaustedBlock() throws Exception {
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.pool.setAbandonedConfig(this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        this.pool.setMaxTotal(1);
        PooledTestObject o1 = (PooledTestObject)this.pool.borrowObject();
        long start = System.currentTimeMillis();
        PooledTestObject o2 = (PooledTestObject)this.pool.borrowObject(5000L);
        long end = System.currentTimeMillis();
        this.pool.returnObject((Object)o2);
        Assert.assertTrue((end - start < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testStackTrace() throws Exception {
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setLogAbandoned(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        PrintWriter pw = new PrintWriter(bos);
        this.abandonedConfig.setLogWriter(pw);
        this.pool.setAbandonedConfig(this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        PooledTestObject o1 = (PooledTestObject)this.pool.borrowObject();
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)o1.isDestroyed());
        bos.flush();
        Assert.assertTrue((baos.toString().indexOf("Pooled object") >= 0 ? 1 : 0) != 0);
    }

    private static class SimpleFactory
    implements PooledObjectFactory<PooledTestObject> {
        private final long destroyLatency;
        private final long validateLatency;

        public SimpleFactory() {
            this.destroyLatency = 0L;
            this.validateLatency = 0L;
        }

        public SimpleFactory(long destroyLatency, long validateLatency) {
            this.destroyLatency = destroyLatency;
            this.validateLatency = validateLatency;
        }

        public PooledObject<PooledTestObject> makeObject() {
            return new DefaultPooledObject((Object)new PooledTestObject());
        }

        public boolean validateObject(PooledObject<PooledTestObject> obj) {
            try {
                Thread.sleep(this.validateLatency);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public void activateObject(PooledObject<PooledTestObject> obj) {
            ((PooledTestObject)obj.getObject()).setActive(true);
        }

        public void passivateObject(PooledObject<PooledTestObject> obj) {
            ((PooledTestObject)obj.getObject()).setActive(false);
        }

        public void destroyObject(PooledObject<PooledTestObject> obj) throws Exception {
            ((PooledTestObject)obj.getObject()).setActive(false);
            Thread.yield();
            if (this.destroyLatency != 0L) {
                Thread.sleep(this.destroyLatency);
            }
            ((PooledTestObject)obj.getObject()).destroy();
        }
    }

    class ConcurrentReturner
    extends Thread {
        private final PooledTestObject returned;

        public ConcurrentReturner(PooledTestObject obj) {
            this.returned = obj;
        }

        @Override
        public void run() {
            try {
                ConcurrentReturner.sleep(20L);
                TestAbandonedObjectPool.this.pool.returnObject((Object)this.returned);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ConcurrentBorrower
    extends Thread {
        private final ArrayList<PooledTestObject> _borrowed;

        public ConcurrentBorrower(ArrayList<PooledTestObject> borrowed) {
            this._borrowed = borrowed;
        }

        @Override
        public void run() {
            try {
                this._borrowed.add((PooledTestObject)TestAbandonedObjectPool.this.pool.borrowObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

