/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericObjectPoolFactoryCreateFailure {
    private static void println(String msg) {
    }

    private static void sleepIgnoreException(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testBorrowObjectStuck() {
        SingleObjectFactory factory = new SingleObjectFactory();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(1);
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(true);
        config.setMinIdle(0);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        config.setTestWhileIdle(false);
        config.setTimeBetweenEvictionRunsMillis(-1L);
        config.setMinEvictableIdleTimeMillis(-1L);
        config.setSoftMinEvictableIdleTimeMillis(-1L);
        config.setMaxWaitMillis(-1L);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, config);){
            AtomicBoolean failed = new AtomicBoolean();
            CountDownLatch barrier = new CountDownLatch(1);
            Thread thread1 = new Thread(new WinnerRunnable(pool, barrier, failed));
            thread1.start();
            while (!factory.created.get()) {
                TestGenericObjectPoolFactoryCreateFailure.sleepIgnoreException(5L);
            }
            barrier.countDown();
            try {
                TestGenericObjectPoolFactoryCreateFailure.println("try borrow in main thread");
                Object o = pool.borrowObject();
                TestGenericObjectPoolFactoryCreateFailure.println("Success borrow in main thread " + o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assert.assertFalse((boolean)failed.get());
        }
    }

    private static class WinnerRunnable
    implements Runnable {
        private final CountDownLatch barrier;
        private final AtomicBoolean failed;
        private final GenericObjectPool<Object> pool;

        private WinnerRunnable(GenericObjectPool<Object> pool, CountDownLatch barrier, AtomicBoolean failed) {
            this.pool = pool;
            this.failed = failed;
            this.barrier = barrier;
        }

        @Override
        public void run() {
            try {
                TestGenericObjectPoolFactoryCreateFailure.println("start borrowing in parallel thread");
                Object obj = this.pool.borrowObject();
                if (!this.barrier.await(5L, TimeUnit.SECONDS)) {
                    TestGenericObjectPoolFactoryCreateFailure.println("Timeout waiting");
                    this.failed.set(true);
                } else {
                    TestGenericObjectPoolFactoryCreateFailure.sleepIgnoreException(1000L);
                }
                this.pool.returnObject(obj);
                TestGenericObjectPoolFactoryCreateFailure.println("ended borrowing in parallel thread");
            }
            catch (Exception e) {
                this.failed.set(true);
                e.printStackTrace();
            }
        }
    }

    private static class SingleObjectFactory
    extends BasePooledObjectFactory<Object> {
        private final AtomicBoolean created = new AtomicBoolean();

        private SingleObjectFactory() {
        }

        public Object create() throws Exception {
            if (!this.created.getAndSet(true)) {
                return new Object();
            }
            throw new Exception("Already created");
        }

        public boolean validateObject(PooledObject<Object> p) {
            return true;
        }

        public PooledObject<Object> wrap(Object obj) {
            return new DefaultPooledObject(new Object());
        }
    }
}

