/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class SoftReferenceObjectPool
extends BaseObjectPool
implements ObjectPool {
    private List _pool = new ArrayList();
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;

    public SoftReferenceObjectPool() {
        this._factory = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this._factory = poolableObjectFactory;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory poolableObjectFactory, int n) throws Exception {
        this._factory = poolableObjectFactory;
        if (null != this._factory) {
            int n2 = 0;
            while (n2 < n) {
                Object object = this._factory.makeObject();
                this._factory.passivateObject(object);
                this._pool.add(new SoftReference<Object>(object));
                ++n2;
            }
        }
    }

    public synchronized Object borrowObject() throws Exception {
        Object object = null;
        while (null == object) {
            if (this._pool.isEmpty()) {
                if (null == this._factory) {
                    throw new NoSuchElementException();
                }
                object = this._factory.makeObject();
                continue;
            }
            SoftReference softReference = (SoftReference)this._pool.remove(this._pool.size() - 1);
            object = softReference.get();
        }
        if (null != this._factory && null != object) {
            this._factory.activateObject(object);
        }
        ++this._numActive;
        return object;
    }

    public void returnObject(Object object) throws Exception {
        boolean bl = true;
        if (!this._factory.validateObject(object)) {
            bl = false;
        } else {
            try {
                this._factory.passivateObject(object);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        boolean bl2 = !bl;
        SoftReferenceObjectPool softReferenceObjectPool = this;
        synchronized (softReferenceObjectPool) {
            --this._numActive;
            if (bl) {
                this._pool.add(new SoftReference<Object>(object));
            }
            this.notifyAll();
        }
        if (bl2) {
            try {
                this._factory.destroyObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumIdle() {
        return this._pool.size();
    }

    public int getNumActive() {
        return this._numActive;
    }

    public synchronized void clear() {
        if (null != this._factory) {
            Iterator iterator = this._pool.iterator();
            while (iterator.hasNext()) {
                try {
                    Object t = ((SoftReference)iterator.next()).get();
                    if (null == t) continue;
                    this._factory.destroyObject(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }
}

