/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class LongProvider
extends BaseProvider
implements RandomLongSource {
    @Override
    public abstract long next();

    public long nextLong() {
        return this.next();
    }

    public int nextInt() {
        return NumberFactory.makeInt(this.nextLong());
    }

    public double nextDouble() {
        return NumberFactory.makeDouble(this.nextLong());
    }

    public boolean nextBoolean() {
        return NumberFactory.makeBoolean(this.nextLong());
    }

    public float nextFloat() {
        return NumberFactory.makeFloat(this.nextInt());
    }

    public void nextBytes(byte[] bytes) {
        LongProvider.nextBytesFill(this, bytes, 0, bytes.length);
    }

    public void nextBytes(byte[] bytes, int start, int len) {
        this.checkIndex(0, bytes.length - 1, start);
        this.checkIndex(0, bytes.length - start, len);
        LongProvider.nextBytesFill(this, bytes, start, len);
    }

    static void nextBytesFill(RandomLongSource source, byte[] bytes, int start, int len) {
        int index = start;
        int indexLoopLimit = index + (len & 0x7FFFFFF8);
        while (index < indexLoopLimit) {
            long random = source.next();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
            bytes[index++] = (byte)(random >>> 32);
            bytes[index++] = (byte)(random >>> 40);
            bytes[index++] = (byte)(random >>> 48);
            bytes[index++] = (byte)(random >>> 56);
        }
        int indexLimit = start + len;
        if (index < indexLimit) {
            long random = source.next();
            while (true) {
                bytes[index++] = (byte)random;
                if (index >= indexLimit) break;
                random >>>= 8;
            }
        }
    }
}

